/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.xsom.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class DeferedCollection<T>
implements Collection<T> {
    private final Iterator<T> result;
    private final List<T> archive = new ArrayList<T>();

    public DeferedCollection(Iterator<T> result) {
        this.result = result;
    }

    @Override
    public boolean isEmpty() {
        if (this.archive.isEmpty()) {
            this.fetch();
        }
        return this.archive.isEmpty();
    }

    @Override
    public int size() {
        this.fetchAll();
        return this.archive.size();
    }

    @Override
    public boolean contains(Object o) {
        if (this.archive.contains(o)) {
            return true;
        }
        while (this.result.hasNext()) {
            T value = this.result.next();
            this.archive.add(value);
            if (!value.equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                if (this.idx < DeferedCollection.this.archive.size()) {
                    return true;
                }
                return DeferedCollection.this.result.hasNext();
            }

            @Override
            public T next() {
                if (this.idx == DeferedCollection.this.archive.size()) {
                    DeferedCollection.this.fetch();
                }
                if (this.idx == DeferedCollection.this.archive.size()) {
                    throw new NoSuchElementException();
                }
                return DeferedCollection.this.archive.get(this.idx++);
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public Object[] toArray() {
        this.fetchAll();
        return this.archive.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.fetchAll();
        return this.archive.toArray(a);
    }

    private void fetchAll() {
        while (this.result.hasNext()) {
            this.archive.add(this.result.next());
        }
    }

    private void fetch() {
        if (this.result.hasNext()) {
            this.archive.add(this.result.next());
        }
    }

    @Override
    public boolean add(T o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

