/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers.deployment;

import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.webservices.deployers.WSEndpointConfigMapping;
import org.jboss.as.webservices.deployers.deployment.AbstractDeploymentModelBuilder;
import org.jboss.as.webservices.logging.WSLogger;
import org.jboss.as.webservices.metadata.model.AbstractEndpoint;
import org.jboss.as.webservices.metadata.model.POJOEndpoint;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.msc.service.ServiceName;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.EndpointType;

final class DeploymentModelBuilderJAXWS_POJO
extends AbstractDeploymentModelBuilder {
    DeploymentModelBuilderJAXWS_POJO() {
        super(EndpointType.JAXWS_JSE);
    }

    @Override
    protected void build(Deployment dep, DeploymentUnit unit) {
        WSLogger.ROOT_LOGGER.trace("Creating JAXWS POJO endpoints meta data model");
        WSEndpointConfigMapping ecm = (WSEndpointConfigMapping)unit.getAttachment(WSAttachmentKeys.WS_ENDPOINT_CONFIG_MAPPING_KEY);
        for (POJOEndpoint pojoEndpoint : ASHelper.getJaxwsPojos(unit)) {
            String pojoEndpointName = pojoEndpoint.getName();
            WSLogger.ROOT_LOGGER.tracef("POJO name: %s", pojoEndpointName);
            String pojoEndpointClassName = pojoEndpoint.getClassName();
            WSLogger.ROOT_LOGGER.tracef("POJO class: %s", pojoEndpointClassName);
            Endpoint ep = this.newHttpEndpoint(pojoEndpointClassName, pojoEndpointName, dep);
            ServiceName componentViewName = pojoEndpoint.getComponentViewName();
            if (componentViewName != null) {
                ep.setProperty(AbstractEndpoint.COMPONENT_VIEW_NAME, (Object)componentViewName);
            }
            if (ecm == null) continue;
            ep.setEndpointConfig(ecm.getConfig(pojoEndpointClassName));
            this.markWeldDeployment(unit, ep);
        }
    }
}

