/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.ejb;

import io.undertow.client.ClientResponse;
import io.undertow.util.HttpString;
import java.io.Closeable;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Base64;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBModuleIdentifier;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.SessionID;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Unmarshaller;
import org.wildfly.httpclient.common.ByteInputs;
import org.wildfly.httpclient.common.ByteOutputs;
import org.wildfly.httpclient.common.HeadersHelper;
import org.wildfly.httpclient.common.HttpTargetContext;
import org.wildfly.httpclient.ejb.Constants;
import org.wildfly.httpclient.ejb.EjbHttpClientMessages;
import org.wildfly.httpclient.ejb.InvocationInfo;
import org.wildfly.httpclient.ejb.Serializer;
import org.wildfly.httpclient.ejb.TransactionInfo;
import org.xnio.IoUtils;

final class ClientHandlers {
    private ClientHandlers() {
    }

    static HttpTargetContext.HttpMarshaller invokeHttpMarshaller(Marshaller marshaller, TransactionInfo txnInfo, Object[] objects, Map<String, Object> map) {
        return new InvokeHttpMarshaller(marshaller, txnInfo, objects, map);
    }

    static HttpTargetContext.HttpMarshaller createSessionHttpMarshaller(Marshaller marshaller, TransactionInfo txnInfo) {
        return new CreateSessionHttpMarshaller(marshaller, txnInfo);
    }

    static <T> HttpTargetContext.HttpResultHandler emptyHttpResultHandler(CompletableFuture<T> result, Function<ClientResponse, T> function) {
        return new EmptyHttpResultHandler<T>(result, function);
    }

    static HttpTargetContext.HttpResultHandler discoveryHttpResultHandler(Unmarshaller unmarshaller, CompletableFuture<Set<EJBModuleIdentifier>> result) {
        return new DiscoveryHttpResultHandler(unmarshaller, result);
    }

    static HttpTargetContext.HttpResultHandler invokeHttpResultHandler(Unmarshaller unmarshaller, EJBReceiverInvocationContext receiverCtx, EJBClientInvocationContext clientCtx) {
        return new EjbClassLoaderAwareHttpResultHandler(unmarshaller, receiverCtx, clientCtx);
    }

    static Function<ClientResponse, Boolean> cancelInvocationResponseFunction() {
        return new CancelInvocationResponseFunction();
    }

    static Function<ClientResponse, SessionID> createSessionResponseFunction() {
        return new CreateSessionResponseFunction();
    }

    private static HttpTargetContext.HttpResultHandler invokeHttpResultHandlerInternal(Unmarshaller unmarshaller, CompletableFuture<InvocationInfo> result) {
        return new InvokeHttpResultHandler(unmarshaller, result);
    }

    private static final class CreateSessionResponseFunction
    implements Function<ClientResponse, SessionID> {
        private CreateSessionResponseFunction() {
        }

        @Override
        public SessionID apply(ClientResponse response) {
            String sessionId = HeadersHelper.getResponseHeader((ClientResponse)response, (HttpString)Constants.EJB_SESSION_ID);
            if (sessionId != null) {
                return SessionID.createSessionID((byte[])Base64.getUrlDecoder().decode(sessionId));
            }
            throw new IllegalStateException(EjbHttpClientMessages.MESSAGES.noSessionIdInResponse());
        }
    }

    private static final class CancelInvocationResponseFunction
    implements Function<ClientResponse, Boolean> {
        private CancelInvocationResponseFunction() {
        }

        @Override
        public Boolean apply(ClientResponse response) {
            return true;
        }
    }

    private static final class InvokeHttpResultHandler
    implements HttpTargetContext.HttpResultHandler {
        private final Unmarshaller unmarshaller;
        private final CompletableFuture<InvocationInfo> result;

        private InvokeHttpResultHandler(Unmarshaller unmarshaller, CompletableFuture<InvocationInfo> result) {
            this.unmarshaller = unmarshaller;
            this.result = result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleResult(InputStream is, ClientResponse response, Closeable doneCallback) {
            try (ByteInput in = ByteInputs.byteInputOf((InputStream)is);){
                this.unmarshaller.start(in);
                Object returned = Serializer.deserializeObject((ObjectInput)this.unmarshaller);
                Map<String, Object> attachments = Serializer.deserializeMap((ObjectInput)this.unmarshaller);
                this.unmarshaller.finish();
                this.result.complete(InvocationInfo.newInstance(returned, attachments));
            }
            catch (Exception e) {
                this.result.completeExceptionally(e);
            }
            finally {
                IoUtils.safeClose((Closeable)doneCallback);
            }
        }
    }

    private static final class EjbClassLoaderAwareHttpResultHandler
    implements HttpTargetContext.HttpResultHandler {
        private static final Set<String> WELL_KNOWN_KEYS = new HashSet<String>();
        private final Unmarshaller unmarshaller;
        private final EJBReceiverInvocationContext receiverCtx;
        private final EJBClientInvocationContext clientCtx;

        private EjbClassLoaderAwareHttpResultHandler(Unmarshaller unmarshaller, EJBReceiverInvocationContext receiverCtx, EJBClientInvocationContext clientCtx) {
            this.unmarshaller = unmarshaller;
            this.receiverCtx = receiverCtx;
            this.clientCtx = clientCtx;
        }

        public void handleResult(final InputStream is, final ClientResponse response, final Closeable doneCallback) {
            this.receiverCtx.resultReady(new EJBReceiverInvocationContext.ResultProducer(){

                public Object getResult() throws Exception {
                    CompletableFuture<InvocationInfo> result = new CompletableFuture<InvocationInfo>();
                    ClientHandlers.invokeHttpResultHandlerInternal(unmarshaller, result).handleResult(is, response, doneCallback);
                    Set returnedContextDataKeys = (Set)clientCtx.getContextData().get("jboss.returned.keys");
                    if (returnedContextDataKeys != null) {
                        clientCtx.getContextData().keySet().removeIf(k -> !k.equals("jboss.returned.keys"));
                    }
                    Set returnedKeys = (Set)clientCtx.getContextData().get("jboss.returned.keys");
                    if (result.get().getAttachments() != null) {
                        for (Map.Entry<String, Object> entry : result.get().getAttachments().entrySet()) {
                            if (entry.getValue() == null || (returnedKeys == null || !returnedKeys.contains(entry.getKey())) && !WELL_KNOWN_KEYS.contains(entry.getKey())) continue;
                            clientCtx.getContextData().put(entry.getKey(), entry.getValue());
                        }
                    }
                    return result.get().getResult();
                }

                public void discardResult() {
                    IoUtils.safeClose((Closeable)doneCallback);
                    IoUtils.safeClose((Closeable)is);
                }
            });
        }

        static {
            WELL_KNOWN_KEYS.add("jboss.source.address");
        }
    }

    private static final class DiscoveryHttpResultHandler
    implements HttpTargetContext.HttpResultHandler {
        private final Unmarshaller unmarshaller;
        private final CompletableFuture<Set<EJBModuleIdentifier>> result;

        private DiscoveryHttpResultHandler(Unmarshaller unmarshaller, CompletableFuture<Set<EJBModuleIdentifier>> result) {
            this.unmarshaller = unmarshaller;
            this.result = result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleResult(InputStream is, ClientResponse response, Closeable doneCallback) {
            try (ByteInput in = ByteInputs.byteInputOf((InputStream)is);){
                this.unmarshaller.start(in);
                Set<EJBModuleIdentifier> modules = Serializer.deserializeSet((ObjectInput)this.unmarshaller);
                this.unmarshaller.finish();
                this.result.complete(modules);
            }
            catch (Exception e) {
                this.result.completeExceptionally(e);
            }
            finally {
                IoUtils.safeClose((Closeable)doneCallback);
            }
        }
    }

    private static final class EmptyHttpResultHandler<T>
    implements HttpTargetContext.HttpResultHandler {
        private final CompletableFuture<T> result;
        private final Function<ClientResponse, T> function;

        private EmptyHttpResultHandler(CompletableFuture<T> result, Function<ClientResponse, T> function) {
            this.result = result;
            this.function = function;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleResult(InputStream is, ClientResponse response, Closeable doneCallback) {
            try {
                this.result.complete(this.function != null ? (Object)this.function.apply(response) : null);
            }
            finally {
                IoUtils.safeClose((Closeable)doneCallback);
            }
        }
    }

    private static final class CreateSessionHttpMarshaller
    implements HttpTargetContext.HttpMarshaller {
        private final Marshaller marshaller;
        private final TransactionInfo txnInfo;

        private CreateSessionHttpMarshaller(Marshaller marshaller, TransactionInfo txnInfo) {
            this.marshaller = marshaller;
            this.txnInfo = txnInfo;
        }

        public void marshall(OutputStream os) throws Exception {
            try (ByteOutput out = ByteOutputs.byteOutputOf((OutputStream)os);){
                this.marshaller.start(out);
                Serializer.serializeTransaction((ObjectOutput)this.marshaller, this.txnInfo);
                this.marshaller.finish();
            }
        }
    }

    private static final class InvokeHttpMarshaller
    implements HttpTargetContext.HttpMarshaller {
        private final Marshaller marshaller;
        private final TransactionInfo txnInfo;
        private final Object[] objects;
        private final Map<String, Object> map;

        private InvokeHttpMarshaller(Marshaller marshaller, TransactionInfo txnInfo, Object[] objects, Map<String, Object> map) {
            this.marshaller = marshaller;
            this.txnInfo = txnInfo;
            this.objects = objects;
            this.map = map;
        }

        public void marshall(OutputStream os) throws Exception {
            try (ByteOutput out = ByteOutputs.byteOutputOf((OutputStream)os);){
                this.marshaller.start(out);
                Serializer.serializeTransaction((ObjectOutput)this.marshaller, this.txnInfo);
                Serializer.serializeObjectArray((ObjectOutput)this.marshaller, this.objects);
                Serializer.serializeMap((ObjectOutput)this.marshaller, this.map);
                this.marshaller.finish();
            }
        }
    }
}

