/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.address;

import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.address.AddressAbstract;
import picocli.CommandLine;

@CommandLine.Command(name="show", description={"Show the selected address."})
public class ShowAddress
extends AddressAbstract {
    @CommandLine.Option(names={"--bindings"}, description={"Show the bindings for this address."})
    boolean bindings;

    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        this.showAddress(context);
        return null;
    }

    private void showAddress(ActionContext context) throws Exception {
        this.performCoreManagement(message -> {
            if (this.getName(false) == null) {
                ManagementHelper.putOperationInvocation((ICoreMessage)message, (String)"broker", (String)"listAddresses", (Object[])new Object[]{"\n"});
            } else if (this.bindings) {
                ManagementHelper.putOperationInvocation((ICoreMessage)message, (String)"broker", (String)"listBindingsForAddress", (Object[])new Object[]{this.getName(false)});
            } else {
                ManagementHelper.putOperationInvocation((ICoreMessage)message, (String)"broker", (String)"getAddressInfo", (Object[])new Object[]{this.getName(false)});
            }
        }, reply -> {
            String result = (String)ManagementHelper.getResult((ICoreMessage)reply, String.class);
            context.out.println(result);
        }, reply -> {
            String errMsg = (String)ManagementHelper.getResult((ICoreMessage)reply, String.class);
            context.err.println("Failed to show address " + this.getName(false) + ". Reason: " + errMsg);
        });
    }

    public boolean isBindings() {
        return this.bindings;
    }

    public void setBindings(boolean bindings) {
        this.bindings = bindings;
    }
}

