/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.cli.commands.messages.ConnectionConfigurationAbtract;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;

public class BasicConnectionAbstract
extends ConnectionConfigurationAbtract {
    protected ConnectionFactory createConnectionFactory() throws Exception {
        this.recoverConnectionInformation();
        return this.createConnectionFactory(this.brokerURL, this.user, this.password);
    }

    protected ConnectionFactory createConnectionFactory(String brokerURL, String user, String password) throws Exception {
        this.recoverConnectionInformation();
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(brokerURL, user, password);
        try {
            this.tryConnect(brokerURL, user, password, (ConnectionFactory)cf);
            return cf;
        }
        catch (JMSSecurityException e) {
            if (this.getActionContext() != null) {
                this.getActionContext().err.println("Connection failed::" + e.getMessage());
            }
            user = this.inputUser(user);
            password = this.inputPassword(password);
            cf = new ActiveMQConnectionFactory(brokerURL, user, password);
            try {
                this.tryConnect(brokerURL, user, password, (ConnectionFactory)cf);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return cf;
        }
        catch (JMSException e) {
            if (this.getActionContext() != null) {
                this.getActionContext().err.println("Connection failed::" + e.getMessage());
            }
            brokerURL = this.inputBrokerURL(brokerURL);
            user = this.inputUser(user);
            password = this.inputPassword(password);
            cf = new ActiveMQConnectionFactory(brokerURL, user, password);
            try {
                this.tryConnect(brokerURL, user, password, (ConnectionFactory)cf);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return cf;
        }
    }

    protected void tryConnect(String brokerURL, String user, String password, ConnectionFactory cf) throws JMSException {
        Connection connection = cf.createConnection();
        connection.close();
        this.saveConnectionInfo(brokerURL, user, password);
    }

    protected void performCoreManagement(ManagementHelper.MessageAcceptor setup, ManagementHelper.MessageAcceptor ok, ManagementHelper.MessageAcceptor failed) throws Exception {
        try (ActiveMQConnectionFactory factory = (ActiveMQConnectionFactory)this.createConnectionFactory();){
            ManagementHelper.doManagement((ServerLocator)factory.getServerLocator(), (String)this.user, (String)this.password, (ManagementHelper.MessageAcceptor)setup, (ManagementHelper.MessageAcceptor)ok, (ManagementHelper.MessageAcceptor)failed);
        }
    }

    protected void performCoreManagement(String uri, String user, String password, ManagementHelper.MessageAcceptor setup, ManagementHelper.MessageAcceptor ok, ManagementHelper.MessageAcceptor failed) throws Exception {
        try (ActiveMQConnectionFactory factory = (ActiveMQConnectionFactory)this.createConnectionFactory(uri, user, password);){
            ManagementHelper.doManagement((ServerLocator)factory.getServerLocator(), (String)user, (String)password, (ManagementHelper.MessageAcceptor)setup, (ManagementHelper.MessageAcceptor)ok, (ManagementHelper.MessageAcceptor)failed);
        }
    }
}

