/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.checksums.internal;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.utils.ClassLoaderHelper;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public final class ConstructorCache {
    private static final Logger log = Logger.loggerFor(ConstructorCache.class);
    private final Map<String, Map<ClassLoader, Optional<WeakReference<Class<?>>>>> classesByClassName = new ConcurrentHashMap();

    private Optional<Class<?>> getClass(String className) {
        Map classesByClassLoader = this.classesByClassName.computeIfAbsent(className, k -> Collections.synchronizedMap(new WeakHashMap()));
        ClassLoader classLoader = ClassLoaderHelper.contextClassLoader();
        Optional classRef = classesByClassLoader.computeIfAbsent(classLoader, k -> {
            try {
                Class<?> clazz = classLoader.loadClass(className);
                return Optional.of(new WeakReference(clazz));
            }
            catch (ClassNotFoundException e) {
                return Optional.empty();
            }
        });
        return classRef.map(Reference::get);
    }

    public Optional<Constructor<?>> getConstructor(String className) {
        return this.getClass(className).flatMap(clazz -> {
            try {
                return Optional.of(clazz.getConstructor(new Class[0]));
            }
            catch (NoSuchMethodException e) {
                log.debug(() -> "Classloader contains " + className + ", but without a zero-arg constructor.", (Throwable)e);
                return Optional.empty();
            }
        });
    }
}

