/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.util.function.SerializableSupplier;

public class CacheCollectors {
    private CacheCollectors() {
    }

    public static <T, R> Collector<T, ?, R> serializableCollector(SerializableSupplier<Collector<T, ?, R>> supplier) {
        return new CollectorSupplier<T, R>(supplier);
    }

    public static <T, R> Collector<T, ?, R> collector(Supplier<Collector<T, ?, R>> supplier) {
        return new CollectorSupplier<T, R>(supplier);
    }

    @SerializeWith(value=CollectorSupplierExternalizer.class)
    private static final class CollectorSupplier<T, R>
    implements Collector<T, Object, R> {
        private final Supplier<Collector<T, ?, R>> supplier;
        private transient Collector<T, Object, R> collector;

        private Collector<T, Object, R> getCollector() {
            if (this.collector == null) {
                this.collector = this.supplier.get();
            }
            return this.collector;
        }

        CollectorSupplier(Supplier<Collector<T, ?, R>> supplier) {
            this.supplier = supplier;
        }

        @Override
        public Supplier<Object> supplier() {
            return this.getCollector().supplier();
        }

        @Override
        public BiConsumer<Object, T> accumulator() {
            return this.getCollector().accumulator();
        }

        @Override
        public BinaryOperator<Object> combiner() {
            return this.getCollector().combiner();
        }

        @Override
        public Function<Object, R> finisher() {
            return this.getCollector().finisher();
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return this.getCollector().characteristics();
        }

        public static final class CollectorSupplierExternalizer
        implements Externalizer<CollectorSupplier<?, ?>> {
            public void writeObject(ObjectOutput output, CollectorSupplier object) throws IOException {
                output.writeObject(object.supplier);
            }

            public CollectorSupplier readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                return new CollectorSupplier((Supplier)input.readObject());
            }
        }
    }
}

