/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.proton;

import java.lang.invoke.MethodHandles;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.impl.nullpm.NullStorageManager;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.impl.RoutingContextImpl;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInternalErrorException;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPLargeMessageReader;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPMessageReader;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.MessageReader;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonDeliveryHandler;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonInitializable;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.transaction.TransactionalState;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProtonAbstractReceiver
extends ProtonInitializable
implements ProtonDeliveryHandler {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final AMQPConnectionContext connection;
    protected final AMQPSessionContext protonSession;
    protected final Receiver receiver;
    protected final int minLargeMessageSize;
    protected final RoutingContext routingContext;
    protected final AMQPSessionCallback sessionSPI;
    protected final MessageReader standardMessageReader = new AMQPMessageReader(this);
    protected final MessageReader largeMessageReader = new AMQPLargeMessageReader(this);
    protected final Runnable creditRunnable;
    protected final boolean useModified;
    protected final Runnable creditTopUpRunner = this::doCreditTopUpRun;
    protected volatile MessageReader messageReader;
    protected int pendingSettles = 0;
    protected volatile ReceiverState state = ReceiverState.STARTED;
    protected BiConsumer<ProtonAbstractReceiver, Boolean> pendingStop;
    protected ScheduledFuture<?> pendingStopTimeout;

    public ProtonAbstractReceiver(AMQPSessionCallback sessionSPI, AMQPConnectionContext connection, AMQPSessionContext protonSession, Receiver receiver) {
        this.sessionSPI = sessionSPI;
        this.connection = connection;
        this.protonSession = protonSession;
        this.receiver = receiver;
        this.minLargeMessageSize = this.getConfiguredMinLargeMessageSize(connection);
        this.creditRunnable = this.createCreditRunnable(connection);
        this.useModified = this.connection.getProtocolManager().isUseModifiedForTransientDeliveryErrors();
        this.routingContext = new RoutingContextImpl(null).setDuplicateDetection(connection.getProtocolManager().isAmqpDuplicateDetection());
    }

    public AMQPSessionContext getSessionContext() {
        return this.protonSession;
    }

    public void start() {
        this.connection.requireInHandler();
        if (this.state == ReceiverState.CLOSED) {
            throw new IllegalStateException("Cannot start a closed receiver");
        }
        if (this.state == ReceiverState.STOPPING) {
            throw new IllegalStateException("Cannot start a receiver that is not yet stopped");
        }
        if (this.state == ReceiverState.STOPPED) {
            this.state = ReceiverState.STARTED;
            this.topUpCreditIfNeeded();
        }
    }

    public void stop(int stopTimeout, BiConsumer<ProtonAbstractReceiver, Boolean> onStopped) {
        Objects.requireNonNull(onStopped, "The stopped callback must not be null");
        this.connection.requireInHandler();
        if (this.isStarted()) {
            this.state = ReceiverState.STOPPING;
            this.pendingStop = onStopped;
            if (!this.checkIfPendingStopCanComplete()) {
                if (this.receiver.getCredit() != 0) {
                    this.receiver.drain(0);
                }
                if (stopTimeout > 0) {
                    this.pendingStopTimeout = this.protonSession.getServer().getScheduledPool().schedule(() -> this.connection.runNow(() -> this.signalStoppedCallback(false)), (long)stopTimeout, TimeUnit.MILLISECONDS);
                }
            }
        } else if (this.isStopped() || this.isClosed()) {
            this.pendingStop = onStopped;
            this.signalStoppedCallback(true);
        } else {
            throw new IllegalStateException("Receiver is currently in the process of stopping");
        }
    }

    @Override
    public void close(boolean remoteLinkClose) throws ActiveMQAMQPException {
        this.state = ReceiverState.CLOSED;
        this.protonSession.removeReceiver(this.receiver);
        this.closeCurrentReader();
        this.connection.runNow(() -> this.signalStoppedCallback(true));
    }

    @Override
    public void close(ErrorCondition condition) throws ActiveMQAMQPException {
        this.receiver.setCondition(condition);
        this.close(false);
    }

    public AMQPConnectionContext getConnection() {
        return this.connection;
    }

    public boolean isStarted() {
        return this.state == ReceiverState.STARTED;
    }

    public boolean isBusy() {
        return false;
    }

    public boolean isStopping() {
        return this.state == ReceiverState.STOPPING;
    }

    public boolean isStopped() {
        return this.state == ReceiverState.STOPPED;
    }

    public boolean isClosed() {
        return this.state == ReceiverState.CLOSED;
    }

    protected OperationContext recoverContext() {
        return this.sessionSPI.recoverContext();
    }

    protected void closeCurrentReader() {
        this.connection.runNow(() -> {
            if (this.messageReader != null) {
                this.messageReader.close();
                this.messageReader = null;
            }
        });
    }

    protected Runnable createCreditRunnable(AMQPConnectionContext connection) {
        return ProtonAbstractReceiver.createCreditRunnable(connection.getAmqpCredits(), connection.getAmqpLowCredits(), this.receiver, connection, this);
    }

    protected int getConfiguredMinLargeMessageSize(AMQPConnectionContext connection) {
        return connection.getProtocolManager().getAmqpMinLargeMessageSize();
    }

    public static Runnable createCreditRunnable(int refill, int threshold, Receiver receiver, AMQPConnectionContext connection, ProtonAbstractReceiver context) {
        return new FlowControlRunner(refill, threshold, receiver, connection, context);
    }

    public void incrementSettle() {
        assert (this.pendingSettles >= 0);
        this.connection.requireInHandler();
        ++this.pendingSettles;
    }

    public void settle(Delivery settlement) {
        this.connection.requireInHandler();
        --this.pendingSettles;
        assert (this.pendingSettles >= 0);
        settlement.settle();
        if (this.isStarted()) {
            this.topUpCreditIfNeeded();
        } else {
            this.checkIfPendingStopCanComplete();
        }
    }

    private boolean checkIfPendingStopCanComplete() {
        if (this.isStopping() && this.pendingSettles == 0 && this.receiver.getQueued() == 0 && this.receiver.getCredit() == 0) {
            this.state = ReceiverState.STOPPED;
            this.signalStoppedCallback(true);
            return true;
        }
        return false;
    }

    @Override
    public void onFlow(int credits, boolean drain) {
        if (this.isStopping()) {
            this.checkIfPendingStopCanComplete();
        } else {
            this.topUpCreditIfNeeded();
        }
    }

    private void handleAbortedDelivery(Delivery delivery) {
        Receiver receiver = (Receiver)delivery.getLink();
        this.closeCurrentReader();
        receiver.advance();
        delivery.settle();
        if (!receiver.getDrain() && this.isStarted()) {
            receiver.flow(1);
        } else {
            this.checkIfPendingStopCanComplete();
        }
    }

    private MessageReader getOrSelectMessageReader(Receiver receiver, Delivery delivery) {
        if (this.messageReader != null) {
            return this.messageReader;
        }
        MessageReader selected = this.trySelectMessageReader(receiver, delivery);
        if (selected != null) {
            this.messageReader = selected.open();
            return this.messageReader;
        }
        return null;
    }

    protected MessageReader trySelectMessageReader(Receiver receiver, Delivery delivery) {
        if (this.sessionSPI.getStorageManager() instanceof NullStorageManager) {
            return this.standardMessageReader;
        }
        if (delivery.isPartial()) {
            if (this.minLargeMessageSize > 0 && delivery.available() >= this.minLargeMessageSize) {
                return this.largeMessageReader;
            }
            return null;
        }
        if (this.minLargeMessageSize > 0 && delivery.available() >= this.minLargeMessageSize) {
            return this.largeMessageReader;
        }
        return this.standardMessageReader;
    }

    @Override
    public final void onMessage(Delivery delivery) throws ActiveMQAMQPException {
        this.connection.requireInHandler();
        if (this.receiver.current() != delivery) {
            return;
        }
        if (delivery.isAborted()) {
            this.handleAbortedDelivery(delivery);
            return;
        }
        try {
            MessageReader messageReader = this.getOrSelectMessageReader(this.receiver, delivery);
            if (messageReader == null) {
                return;
            }
            Message completeMessage = messageReader.readBytes(delivery);
            if (completeMessage != null) {
                this.onMessageComplete(delivery, completeMessage, messageReader.getDeliveryAnnotations());
            }
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw new ActiveMQAMQPInternalErrorException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessageComplete(Delivery delivery, Message message, DeliveryAnnotations deliveryAnnotations) {
        this.connection.requireInHandler();
        try {
            this.receiver.advance();
            Transaction tx = null;
            DeliveryState deliveryState = delivery.getRemoteState();
            if (deliveryState instanceof TransactionalState) {
                TransactionalState txState = (TransactionalState)deliveryState;
                try {
                    tx = this.sessionSPI.getTransaction(txState.getTxnId(), false);
                }
                catch (Exception e) {
                    this.onExceptionWhileReading(e);
                }
            }
            this.actualDelivery(message, delivery, deliveryAnnotations, this.receiver, tx);
        }
        finally {
            this.messageReader.close();
            this.messageReader = null;
        }
    }

    public void onExceptionWhileReading(Throwable e) {
        logger.warn(e.getMessage(), e);
        this.connection.runNow(() -> {
            this.connection.enableAutoRead();
            ErrorCondition ec = new ErrorCondition(AmqpError.INTERNAL_ERROR, e.getMessage());
            this.connection.close(ec);
            this.connection.flush();
        });
    }

    protected abstract SimpleString getAddressInUse();

    protected abstract void actualDelivery(Message var1, Delivery var2, DeliveryAnnotations var3, Receiver var4, Transaction var5);

    protected final void topUpCreditIfNeeded() {
        this.connection.requireInHandler();
        if (this.isStarted()) {
            this.connection.afterFlush(this.creditTopUpRunner);
        }
    }

    private void signalStoppedCallback(boolean stopped) {
        if (this.pendingStopTimeout != null) {
            this.pendingStopTimeout.cancel(false);
            this.pendingStopTimeout = null;
        }
        if (this.pendingStop != null) {
            try {
                this.pendingStop.accept(this, stopped);
            }
            catch (Exception e) {
                logger.trace("Suppressed error from pending stop callback: ", (Throwable)e);
            }
            finally {
                this.pendingStop = null;
            }
        }
    }

    protected void doCreditTopUpRun() {
        this.connection.requireInHandler();
        if (this.isStarted()) {
            this.sessionSPI.flow(this.getAddressInUse(), this.creditRunnable);
        }
    }

    public static boolean isBellowThreshold(int credit, int pending, int threshold) {
        return credit <= threshold - pending;
    }

    public static int calculatedUpdateRefill(int refill, int credits, int pending) {
        return refill - credits - pending;
    }

    protected static enum ReceiverState {
        STARTED,
        STOPPING,
        STOPPED,
        CLOSED;

    }

    protected static class FlowControlRunner
    implements Runnable {
        final int refill;
        final int threshold;
        final Receiver receiver;
        final AMQPConnectionContext connection;
        final ProtonAbstractReceiver context;

        FlowControlRunner(int refill, int threshold, Receiver receiver, AMQPConnectionContext connection, ProtonAbstractReceiver context) {
            Objects.requireNonNull(receiver, "Given proton receiver cannot be null");
            Objects.requireNonNull(connection, "Given connection context cannot be null");
            Objects.requireNonNull(context, "Given receiver context cannot be null");
            this.refill = refill;
            this.threshold = threshold;
            this.receiver = receiver;
            this.connection = connection;
            this.context = context;
        }

        @Override
        public void run() {
            if (this.connection.isHandler()) {
                this.connection.requireInHandler();
                if (this.context.isStarted() && !this.context.isBusy()) {
                    int topUp;
                    int pending = this.context.pendingSettles;
                    if (ProtonAbstractReceiver.isBellowThreshold(this.receiver.getCredit(), pending, this.threshold) && (topUp = ProtonAbstractReceiver.calculatedUpdateRefill(this.refill, this.receiver.getCredit(), pending)) > 0) {
                        this.receiver.flow(topUp);
                        this.connection.instantFlush();
                    }
                }
            } else {
                this.connection.runLater(this);
            }
        }
    }
}

