/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.client.impl.TopologyMemberImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.cluster.quorum.QuorumVoteHandler;
import org.apache.activemq.artemis.core.server.cluster.quorum.QuorumVoteServerConnect;
import org.apache.activemq.artemis.core.server.cluster.quorum.ServerConnectVote;
import org.apache.activemq.artemis.core.server.cluster.quorum.Vote;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;

public class ServerConnectVoteHandler
implements QuorumVoteHandler {
    private final ActiveMQServerImpl server;

    public ServerConnectVoteHandler(ActiveMQServerImpl server) {
        this.server = server;
    }

    @Override
    public Vote vote(Vote vote) {
        ServerConnectVote serverConnectVote = (ServerConnectVote)vote;
        String nodeid = serverConnectVote.getNodeId();
        try {
            TopologyMemberImpl member = this.server.getClusterManager().getDefaultConnection(null).getTopology().getMember(nodeid);
            if (member != null && member.getPrimary() != null) {
                ActiveMQServerLogger.LOGGER.nodeFoundInClusterTopology(nodeid);
                return new ServerConnectVote(nodeid, (Boolean)vote.getVote(), member.getPrimary().toString());
            }
            ActiveMQServerLogger.LOGGER.nodeNotFoundInClusterTopology(nodeid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ServerConnectVote(nodeid, (Boolean)vote.getVote() == false, null);
    }

    @Override
    public SimpleString getQuorumName() {
        return QuorumVoteServerConnect.PRIMARY_FAILOVER_VOTE;
    }

    @Override
    public Vote decode(ActiveMQBuffer voteBuffer) {
        ServerConnectVote vote = new ServerConnectVote();
        vote.decode(voteBuffer);
        return vote;
    }
}

