/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.jgroups.ClassLoaderThreadFactory;
import org.jboss.as.clustering.jgroups.JChannelFactory;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsExtension;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ThreadPoolConfiguration;
import org.jboss.as.clustering.jgroups.subsystem.ThreadPoolResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.capability.UnaryCapabilityNameResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.network.ClientMapping;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jgroups.protocols.TP;
import org.jgroups.stack.DiagnosticsHandler;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.ThreadPool;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolStackConfiguration;
import org.wildfly.clustering.jgroups.spi.TransportConfiguration;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.service.ServiceDependency;

public class TransportResourceDefinition<T extends TP>
extends AbstractProtocolResourceDefinition<T, TransportConfiguration<T>> {
    static final PathElement WILDCARD_PATH = TransportResourceDefinition.pathElement("*");
    static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of((UnaryServiceDescriptor)TransportConfiguration.SERVICE_DESCRIPTOR).setDynamicNameMapper((Function)UnaryCapabilityNameResolver.PARENT).build();

    public static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"transport", (String)name);
    }

    TransportResourceDefinition() {
        this(new SimpleResourceDefinition.Parameters(WILDCARD_PATH, (ResourceDescriptionResolver)JGroupsExtension.SUBSYSTEM_RESOLVER.createChildResolver(WILDCARD_PATH, ProtocolResourceDefinition.WILDCARD_PATH)), UnaryOperator.identity());
    }

    TransportResourceDefinition(String name) {
        this(TransportResourceDefinition.pathElement(name), UnaryOperator.identity());
    }

    TransportResourceDefinition(PathElement path, UnaryOperator<ResourceDescriptor> resourceConfigurator) {
        this(new SimpleResourceDefinition.Parameters(path, (ResourceDescriptionResolver)JGroupsExtension.SUBSYSTEM_RESOLVER.createChildResolver(path, WILDCARD_PATH, ProtocolResourceDefinition.WILDCARD_PATH)), resourceConfigurator);
    }

    private TransportResourceDefinition(SimpleResourceDefinition.Parameters parameters, UnaryOperator<ResourceDescriptor> resourceConfigurator) {
        super(parameters, CAPABILITY, new ResourceDescriptorConfigurator(resourceConfigurator), null);
    }

    @Override
    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = super.register(parent);
        if (registration.getPathAddress().getLastElement().isWildcard()) {
            for (ThreadPoolResourceDefinition pool : EnumSet.allOf(ThreadPoolResourceDefinition.class)) {
                pool.register(registration);
            }
        }
        return registration;
    }

    public Map.Entry<Function<ProtocolConfiguration<T>, TransportConfiguration<T>>, Consumer<RequirementServiceBuilder<?>>> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        final ServiceDependency threadPool = ServiceDependency.on((UnaryServiceDescriptor)ThreadPoolResourceDefinition.DEFAULT, (String)context.getCurrentAddress().getParent().getLastElement().getValue());
        final ServiceDependency binding = ServiceDependency.on((UnaryServiceDescriptor)SocketBinding.SERVICE_DESCRIPTOR, (String)Attribute.SOCKET_BINDING.resolveModelAttribute((ExpressionResolver)context, model).asString());
        String diagnosticsBindingName = Attribute.DIAGNOSTICS_SOCKET_BINDING.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        final ServiceDependency diagnostics = diagnosticsBindingName != null ? ServiceDependency.on((UnaryServiceDescriptor)SocketBinding.SERVICE_DESCRIPTOR, (String)diagnosticsBindingName) : ServiceDependency.of(null);
        final ModelNode machine = Attribute.MACHINE.resolveModelAttribute((ExpressionResolver)context, model);
        final ModelNode rack = Attribute.RACK.resolveModelAttribute((ExpressionResolver)context, model);
        final ModelNode site = Attribute.SITE.resolveModelAttribute((ExpressionResolver)context, model);
        final TransportConfiguration.Topology topology = site.isDefined() || rack.isDefined() || machine.isDefined() ? new TransportConfiguration.Topology(){

            public String getMachine() {
                return machine.asStringOrNull();
            }

            public String getRack() {
                return rack.asStringOrNull();
            }

            public String getSite() {
                return site.asStringOrNull();
            }
        } : null;
        return Map.entry(new Function<ProtocolConfiguration<T>, TransportConfiguration<T>>(){

            @Override
            public TransportConfiguration<T> apply(final ProtocolConfiguration<T> configuration) {
                return new TransportProtocolConfigurationDecorator<T>(configuration){

                    @Override
                    public T createProtocol(ProtocolStackConfiguration stackConfiguration) {
                        TP protocol = (TP)configuration.createProtocol(stackConfiguration);
                        SocketBinding binding = this.getSocketBinding();
                        InetSocketAddress socketAddress = binding.getSocketAddress();
                        protocol.setBindAddress(socketAddress.getAddress());
                        protocol.setBindPort(socketAddress.getPort());
                        List clientMappings = binding.getClientMappings();
                        if (!clientMappings.isEmpty()) {
                            ClientMapping mapping = (ClientMapping)clientMappings.get(0);
                            try {
                                protocol.setExternalAddr(InetAddress.getByName(mapping.getDestinationAddress()));
                                protocol.setExternalPort(mapping.getDestinationPort());
                            }
                            catch (UnknownHostException e) {
                                throw new IllegalArgumentException(e);
                            }
                        }
                        ThreadPoolConfiguration threadPoolConfiguration = (ThreadPoolConfiguration)threadPool.get();
                        ThreadPool threadPool = protocol.getThreadPool();
                        threadPool.setMinThreads(threadPoolConfiguration.getMinThreads());
                        threadPool.setMaxThreads(threadPoolConfiguration.getMaxThreads());
                        threadPool.setKeepAliveTime(threadPoolConfiguration.getKeepAliveTime());
                        threadPool.setRejectionPolicy("discard");
                        protocol.setThreadFactory((ThreadFactory)new ClassLoaderThreadFactory((ThreadFactory)new DefaultThreadFactory("jgroups", false, true).useVirtualThreads(protocol.useVirtualThreads()), JChannelFactory.class.getClassLoader()));
                        SocketBinding diagnosticsBinding = (SocketBinding)diagnostics.get();
                        if (diagnosticsBinding != null) {
                            DiagnosticsHandler handler = new DiagnosticsHandler(protocol.getLog(), protocol.getSocketFactory(), protocol.getThreadFactory());
                            InetSocketAddress address = diagnosticsBinding.getSocketAddress();
                            handler.setBindAddress(address.getAddress());
                            if (diagnosticsBinding.getMulticastAddress() != null) {
                                handler.setMcastAddress(diagnosticsBinding.getMulticastAddress());
                                handler.setPort(diagnosticsBinding.getMulticastPort());
                            } else {
                                handler.setPort(diagnosticsBinding.getPort());
                            }
                            try {
                                protocol.setDiagnosticsHandler(handler);
                            }
                            catch (Exception e) {
                                throw new IllegalStateException(e);
                            }
                        }
                        return protocol;
                    }

                    public TransportConfiguration.Topology getTopology() {
                        return topology;
                    }

                    public SocketBinding getSocketBinding() {
                        return (SocketBinding)binding.get();
                    }
                };
            }
        }, threadPool.andThen((Consumer)binding).andThen((Consumer)diagnostics));
    }

    static class ResourceDescriptorConfigurator
    implements UnaryOperator<ResourceDescriptor> {
        private final UnaryOperator<ResourceDescriptor> configurator;

        ResourceDescriptorConfigurator(UnaryOperator<ResourceDescriptor> configurator) {
            this.configurator = configurator;
        }

        @Override
        public ResourceDescriptor apply(ResourceDescriptor descriptor) {
            return ((ResourceDescriptor)this.configurator.apply(descriptor)).addAttributes(Attribute.class).addRequiredChildren(ThreadPoolResourceDefinition.class);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        SOCKET_BINDING("socket-binding", ModelType.STRING){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setAllowExpression(false)).setRequired(true)).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF})).setCapabilityReference((CapabilityReferenceRecorder)org.wildfly.subsystem.resource.capability.CapabilityReferenceRecorder.builder(CAPABILITY, (UnaryServiceDescriptor)SocketBinding.SERVICE_DESCRIPTOR).build());
            }
        }
        ,
        DIAGNOSTICS_SOCKET_BINDING("diagnostics-socket-binding", ModelType.STRING){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setAllowExpression(false)).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF})).setCapabilityReference((CapabilityReferenceRecorder)org.wildfly.subsystem.resource.capability.CapabilityReferenceRecorder.builder(CAPABILITY, (UnaryServiceDescriptor)SocketBinding.SERVICE_DESCRIPTOR).build());
            }
        }
        ,
        SITE("site", ModelType.STRING),
        RACK("rack", ModelType.STRING),
        MACHINE("machine", ModelType.STRING);

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type) {
            this.definition = this.apply((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
            return builder;
        }
    }

    static abstract class TransportConfigurationDecorator<T extends TP>
    extends TransportProtocolConfigurationDecorator<T> {
        private final TransportConfiguration<T> configuration;

        TransportConfigurationDecorator(TransportConfiguration<T> configuration) {
            super(configuration);
            this.configuration = configuration;
        }

        public TransportConfiguration.Topology getTopology() {
            return this.configuration.getTopology();
        }

        public SocketBinding getSocketBinding() {
            return this.configuration.getSocketBinding();
        }
    }

    static abstract class TransportProtocolConfigurationDecorator<T extends TP>
    extends AbstractProtocolResourceDefinition.ProtocolConfigurationDecorator<T>
    implements TransportConfiguration<T> {
        TransportProtocolConfigurationDecorator(ProtocolConfiguration<T> configuration) {
            super(configuration);
        }
    }
}

