/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.soteria.original;

import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.security.enterprise.identitystore.DatabaseIdentityStoreDefinition;
import jakarta.security.enterprise.identitystore.IdentityStore;
import jakarta.security.enterprise.identitystore.PasswordHash;
import org.wildfly.security.soteria.original.AnnotationELPProcessor;

public class DatabaseIdentityStoreDefinitionAnnotationLiteral
extends AnnotationLiteral<DatabaseIdentityStoreDefinition>
implements DatabaseIdentityStoreDefinition {
    private static final long serialVersionUID = 1L;
    private final String dataSourceLookup;
    private final String callerQuery;
    private final String groupsQuery;
    private final Class<? extends PasswordHash> hashAlgorithm;
    private final String[] hashAlgorithmParameters;
    private final int priority;
    private final String priorityExpression;
    private final IdentityStore.ValidationType[] useFor;
    private final String useForExpression;
    private boolean hasDeferredExpressions;

    public DatabaseIdentityStoreDefinitionAnnotationLiteral(String dataSourceLookup, String callerQuery, String groupsQuery, Class<? extends PasswordHash> hashAlgorithm, String[] hashAlgorithmParameters, int priority, String priorityExpression, IdentityStore.ValidationType[] useFor, String useForExpression) {
        this.dataSourceLookup = dataSourceLookup;
        this.callerQuery = callerQuery;
        this.groupsQuery = groupsQuery;
        this.hashAlgorithm = hashAlgorithm;
        this.hashAlgorithmParameters = hashAlgorithmParameters;
        this.priority = priority;
        this.priorityExpression = priorityExpression;
        this.useFor = useFor;
        this.useForExpression = useForExpression;
    }

    public static DatabaseIdentityStoreDefinition eval(DatabaseIdentityStoreDefinition in) {
        if (!DatabaseIdentityStoreDefinitionAnnotationLiteral.hasAnyELExpression(in)) {
            return in;
        }
        DatabaseIdentityStoreDefinitionAnnotationLiteral out = new DatabaseIdentityStoreDefinitionAnnotationLiteral(org.glassfish.soteria.cdi.AnnotationELPProcessor.evalImmediate((String)in.dataSourceLookup()), org.glassfish.soteria.cdi.AnnotationELPProcessor.evalImmediate((String)in.callerQuery()), org.glassfish.soteria.cdi.AnnotationELPProcessor.evalImmediate((String)in.groupsQuery()), in.hashAlgorithm(), in.hashAlgorithmParameters(), org.glassfish.soteria.cdi.AnnotationELPProcessor.evalImmediate((String)in.priorityExpression(), (int)in.priority()), org.glassfish.soteria.cdi.AnnotationELPProcessor.emptyIfImmediate((String)in.priorityExpression()), (IdentityStore.ValidationType[])org.glassfish.soteria.cdi.AnnotationELPProcessor.evalImmediate((String)in.useForExpression(), (Object)in.useFor()), org.glassfish.soteria.cdi.AnnotationELPProcessor.emptyIfImmediate((String)in.useForExpression()));
        out.setHasDeferredExpressions(DatabaseIdentityStoreDefinitionAnnotationLiteral.hasAnyELExpression(out));
        return out;
    }

    public static boolean hasAnyELExpression(DatabaseIdentityStoreDefinition in) {
        return AnnotationELPProcessor.hasAnyELExpression(in.dataSourceLookup(), in.callerQuery(), in.groupsQuery(), in.priorityExpression(), in.useForExpression());
    }

    public String dataSourceLookup() {
        return this.hasDeferredExpressions ? org.glassfish.soteria.cdi.AnnotationELPProcessor.evalELExpression((String)this.dataSourceLookup) : this.dataSourceLookup;
    }

    public String callerQuery() {
        return this.hasDeferredExpressions ? org.glassfish.soteria.cdi.AnnotationELPProcessor.evalELExpression((String)this.callerQuery) : this.callerQuery;
    }

    public String groupsQuery() {
        return this.hasDeferredExpressions ? org.glassfish.soteria.cdi.AnnotationELPProcessor.evalELExpression((String)this.groupsQuery) : this.groupsQuery;
    }

    public Class<? extends PasswordHash> hashAlgorithm() {
        return this.hashAlgorithm;
    }

    public String[] hashAlgorithmParameters() {
        return this.hashAlgorithmParameters;
    }

    public int priority() {
        return this.hasDeferredExpressions ? org.glassfish.soteria.cdi.AnnotationELPProcessor.evalELExpression((String)this.priorityExpression, (int)this.priority) : this.priority;
    }

    public String priorityExpression() {
        return this.priorityExpression;
    }

    public IdentityStore.ValidationType[] useFor() {
        return this.hasDeferredExpressions ? (IdentityStore.ValidationType[])org.glassfish.soteria.cdi.AnnotationELPProcessor.evalELExpression((String)this.useForExpression, (Object)this.useFor) : this.useFor;
    }

    public String useForExpression() {
        return this.useForExpression;
    }

    public boolean isHasDeferredExpressions() {
        return this.hasDeferredExpressions;
    }

    public void setHasDeferredExpressions(boolean hasDeferredExpressions) {
        this.hasDeferredExpressions = hasDeferredExpressions;
    }
}

