/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.singleton.service;

import java.util.Map;
import java.util.function.Consumer;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceActivatorContext;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.singleton.service.ServiceTargetFactory;
import org.wildfly.clustering.singleton.service.SingletonServiceActivatorContext;
import org.wildfly.clustering.singleton.service.SingletonServiceTarget;
import org.wildfly.clustering.singleton.service.SingletonServiceTargetFactory;
import org.wildfly.service.ServiceDependency;
import org.wildfly.service.ServiceInstaller;

public interface SingletonServiceActivator
extends ServiceActivator {
    default public void activate(final ServiceActivatorContext context) {
        Map.Entry resolved = ServiceTargetFactory.SERVICE_DESCRIPTOR.resolve(this.getSingletonPolicy());
        ServiceName baseName = ServiceName.parse((String)((String)resolved.getKey()));
        ServiceName name = ((String[])resolved.getValue()).length > 0 ? baseName.append((String[])resolved.getValue()) : baseName;
        final ServiceDependency singletonTargetFactory = ServiceDependency.on((ServiceName)name);
        ServiceInstaller installer = new ServiceInstaller(){

            public ServiceController<?> install(ServiceTarget target) {
                final SingletonServiceTarget singletonTarget = ((SingletonServiceTargetFactory)singletonTargetFactory.get()).createSingletonServiceTarget(target);
                SingletonServiceActivator.this.activate(new SingletonServiceActivatorContext(){

                    public ServiceRegistry getServiceRegistry() {
                        return context.getServiceRegistry();
                    }

                    @Override
                    public SingletonServiceTarget getServiceTarget() {
                        return singletonTarget;
                    }
                });
                return null;
            }
        };
        ((ServiceInstaller)((ServiceInstaller.Builder)ServiceInstaller.builder((ServiceInstaller)installer).requires((Consumer)singletonTargetFactory)).build()).install(context.getServiceTarget());
    }

    default public String getSingletonPolicy() {
        return null;
    }

    public void activate(SingletonServiceActivatorContext var1);
}

