/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.service;

import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.logging.NamingLogger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class BinderService
implements Service<ManagedReferenceFactory> {
    private final InjectedValue<ServiceBasedNamingStore> namingStoreValue = new InjectedValue();
    private final String name;
    private final InjectedValue<ManagedReferenceFactory> managedReferenceFactory = new InjectedValue();
    private volatile Object source;
    private final AtomicInteger refcnt;
    private volatile ServiceController<?> controller;

    public BinderService(String name, Object source, boolean shared) {
        this.name = name.startsWith("java:") ? name.substring(name.indexOf(47) + 1) : name;
        this.source = source;
        this.refcnt = shared ? new AtomicInteger(0) : null;
    }

    public BinderService(String name, Object source) {
        this(name, source, false);
    }

    public BinderService(String name) {
        this(name, null, false);
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public void acquire() {
        if (this.refcnt != null) {
            this.refcnt.incrementAndGet();
        }
    }

    public boolean release() {
        if (this.refcnt != null && this.refcnt.decrementAndGet() <= 0 && this.controller != null) {
            this.controller.setMode(ServiceController.Mode.REMOVE);
            return true;
        }
        return false;
    }

    public ServiceName getServiceName() {
        ServiceController<?> serviceController = this.controller;
        return serviceController != null ? serviceController.getName() : null;
    }

    public void start(StartContext context) throws StartException {
        ServiceBasedNamingStore namingStore = (ServiceBasedNamingStore)this.namingStoreValue.getValue();
        this.controller = context.getController();
        namingStore.add(this.controller.getName());
        NamingLogger.ROOT_LOGGER.tracef("Bound resource %s into naming store %s (service name %s)", this.name, namingStore, this.controller.getName());
    }

    public void stop(StopContext context) {
        ServiceBasedNamingStore namingStore = (ServiceBasedNamingStore)this.namingStoreValue.getValue();
        namingStore.remove(this.controller.getName());
        NamingLogger.ROOT_LOGGER.tracef("Unbound resource %s into naming store %s (service name %s)", this.name, namingStore, context.getController().getName());
    }

    public ManagedReferenceFactory getValue() throws IllegalStateException {
        return (ManagedReferenceFactory)this.managedReferenceFactory.getValue();
    }

    public InjectedValue<ManagedReferenceFactory> getManagedObjectInjector() {
        return this.managedReferenceFactory;
    }

    public InjectedValue<ServiceBasedNamingStore> getNamingStoreInjector() {
        return this.namingStoreValue;
    }

    public String toString() {
        return "BinderService[name=" + this.name + ", source=" + String.valueOf(this.source) + ", refcnt=" + String.valueOf(this.refcnt != null ? Integer.valueOf(this.refcnt.get()) : "n/a") + "]";
    }

    public String getName() {
        return this.name;
    }
}

