/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.instmgr.cli;

import java.nio.file.Path;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.cli.command.aesh.CLICommandInvocation;
import org.wildfly.core.instmgr.InstMgrCleanHandler;
import org.wildfly.core.instmgr.cli.AbstractInstMgrCommand;
import org.wildfly.core.instmgr.cli.InstMgrActivator;

@CommandDefinition(name="clean", description="Clean installation manager content.", activator=InstMgrActivator.class)
public class CleanCommand
extends AbstractInstMgrCommand {
    final Path lstUpdatesWorkDir;

    public CleanCommand() {
        this.lstUpdatesWorkDir = null;
    }

    public CleanCommand(Builder builder) {
        this.lstUpdatesWorkDir = builder.lstUpdatesWorkDir;
    }

    @Override
    protected Operation buildOperation() {
        ModelNode op = new ModelNode();
        op.get("operation").set(InstMgrCleanHandler.DEFINITION.getName());
        if (this.lstUpdatesWorkDir != null) {
            op.get("work-dir").set(this.lstUpdatesWorkDir.toString());
        }
        return OperationBuilder.create((ModelNode)op).build();
    }

    @Override
    public CommandResult execute(CLICommandInvocation commandInvocation) throws CommandException, InterruptedException {
        CommandContext ctx = commandInvocation.getCommandContext();
        ModelControllerClient client = ctx.getModelControllerClient();
        if (client == null) {
            ctx.printLine("You are disconnected at the moment. Type 'connect' to connect to the server or 'help' for the list of supported commands.");
            return CommandResult.FAILURE;
        }
        this.executeOp(commandInvocation.getCommandContext(), this.host);
        return CommandResult.SUCCESS;
    }

    public static class Builder {
        private Path lstUpdatesWorkDir;

        public Builder setLstUpdatesWorkDir(Path lstUpdatesWorkDir) {
            this.lstUpdatesWorkDir = lstUpdatesWorkDir;
            return this;
        }

        public CleanCommand createCleanCommand() {
            return new CleanCommand(this);
        }
    }
}

