/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron.oidc;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.version.Stability;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.elytron.oidc.ElytronOidcExtension;
import org.wildfly.extension.elytron.oidc.OidcConfigService;
import org.wildfly.extension.elytron.oidc.ProviderAttributeDefinitions;
import org.wildfly.extension.elytron.oidc.ProviderDefinition;
import org.wildfly.extension.elytron.oidc._private.ElytronOidcLogger;

class RealmDefinition
extends SimpleResourceDefinition {
    static final ResourceRegistration PATH = ResourceRegistration.of((PathElement)PathElement.pathElement((String)"realm"), (Stability)Stability.DEFAULT);

    RealmDefinition() {
        super(new SimpleResourceDefinition.Parameters(PATH, ElytronOidcExtension.getResourceDescriptionResolver("realm")).setAddHandler((OperationStepHandler)RealmAddHandler.INSTANCE).setRemoveHandler((OperationStepHandler)RealmRemoveHandler.INSTANCE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        for (SimpleAttributeDefinition attribute : ProviderAttributeDefinitions.ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute((AttributeDefinition)attribute, null, (OperationStepHandler)RealmWriteAttributeHandler.INSTANCE);
        }
    }

    static class RealmAddHandler
    extends AbstractAddStepHandler {
        public static RealmAddHandler INSTANCE = new RealmAddHandler();

        private RealmAddHandler() {
            super((AttributeDefinition[])ProviderAttributeDefinitions.ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.performRuntime(context, operation, model);
            boolean disableTrustManager = ProviderAttributeDefinitions.DISABLE_TRUST_MANAGER.resolveModelAttribute(context, model).asBoolean();
            if (disableTrustManager) {
                ElytronOidcLogger.ROOT_LOGGER.disableTrustManagerSetToTrue();
            }
            OidcConfigService oidcConfigService = OidcConfigService.getInstance();
            oidcConfigService.addRealm(context.getCurrentAddressValue(), context.resolveExpressions(model));
        }
    }

    static class RealmRemoveHandler
    extends AbstractRemoveStepHandler {
        public static ProviderDefinition.ProviderRemoveHandler INSTANCE = new ProviderDefinition.ProviderRemoveHandler();

        RealmRemoveHandler() {
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            OidcConfigService oidcConfigService = OidcConfigService.getInstance();
            oidcConfigService.removeRealm(context.getCurrentAddressValue());
        }
    }

    static class RealmWriteAttributeHandler
    extends AbstractWriteAttributeHandler<OidcConfigService> {
        public static final RealmWriteAttributeHandler INSTANCE = new RealmWriteAttributeHandler(new AttributeDefinition[0]);

        public RealmWriteAttributeHandler(AttributeDefinition ... definitions) {
            super((AttributeDefinition[])ProviderAttributeDefinitions.ATTRIBUTES);
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<OidcConfigService> handbackHolder) throws OperationFailedException {
            OidcConfigService oidcConfigService = OidcConfigService.getInstance();
            oidcConfigService.updateRealm(context.getCurrentAddressValue(), attributeName, resolvedValue);
            handbackHolder.setHandback((Object)oidcConfigService);
            return false;
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, OidcConfigService oidcConfigService) throws OperationFailedException {
            oidcConfigService.updateRealm(context.getCurrentAddressValue(), attributeName, valueToRestore);
        }
    }
}

