/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron.oidc;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.version.Stability;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.elytron.oidc.ElytronOidcExtension;
import org.wildfly.extension.elytron.oidc.OidcConfigService;

class RedirectRewriteRuleDefinition
extends SimpleResourceDefinition {
    static final ResourceRegistration PATH = ResourceRegistration.of((PathElement)PathElement.pathElement((String)"redirect-rewrite-rule"), (Stability)Stability.DEFAULT);
    protected static final SimpleAttributeDefinition REPLACEMENT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("replacement", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, true))).build();
    protected static final ObjectTypeAttributeDefinition REDIRECT_REWRITE_RULE = new ObjectTypeAttributeDefinition.Builder("redirect-rewrite-rule", new AttributeDefinition[]{REPLACEMENT}).build();

    RedirectRewriteRuleDefinition() {
        super(new SimpleResourceDefinition.Parameters(PATH, ElytronOidcExtension.getResourceDescriptionResolver("secure-deployment", "redirect-rewrite-rule")).setAddHandler((OperationStepHandler)RedirectRewriteRuleAddHandler.INSTANCE).setRemoveHandler((OperationStepHandler)RedirectRewriteRuleRemoveHandler.INSTANCE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)REPLACEMENT, null, (OperationStepHandler)RedirectRewriteRuleWriteHandler.INSTANCE);
    }

    static class RedirectRewriteRuleAddHandler
    extends AbstractAddStepHandler {
        public static RedirectRewriteRuleAddHandler INSTANCE = new RedirectRewriteRuleAddHandler();

        private RedirectRewriteRuleAddHandler() {
            super(new AttributeDefinition[]{REPLACEMENT});
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            OidcConfigService oidcConfigService = OidcConfigService.getInstance();
            oidcConfigService.addRedirectRewriteRule(context.getCurrentAddress().getParent().getLastElement().getValue(), context.getCurrentAddressValue(), context.resolveExpressions(model));
        }
    }

    static class RedirectRewriteRuleRemoveHandler
    extends AbstractRemoveStepHandler {
        public static RedirectRewriteRuleRemoveHandler INSTANCE = new RedirectRewriteRuleRemoveHandler();

        RedirectRewriteRuleRemoveHandler() {
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            OidcConfigService oidcConfigService = OidcConfigService.getInstance();
            oidcConfigService.removeRedirectRewriteRule(context.getCurrentAddress().getParent().getLastElement().getValue(), context.getCurrentAddressValue());
        }
    }

    static class RedirectRewriteRuleWriteHandler
    extends AbstractWriteAttributeHandler<OidcConfigService> {
        public static final RedirectRewriteRuleWriteHandler INSTANCE = new RedirectRewriteRuleWriteHandler();

        private RedirectRewriteRuleWriteHandler() {
            super(new AttributeDefinition[]{REPLACEMENT});
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<OidcConfigService> handbackHolder) throws OperationFailedException {
            OidcConfigService oidcConfigService = OidcConfigService.getInstance();
            oidcConfigService.updateRedirectRewriteRule(context.getCurrentAddress().getParent().getLastElement().getValue(), context.getCurrentAddressValue(), resolvedValue);
            handbackHolder.setHandback((Object)oidcConfigService);
            return false;
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, OidcConfigService oidcConfigService) throws OperationFailedException {
            oidcConfigService.updateRedirectRewriteRule(context.getCurrentAddress().getParent().getLastElement().getValue(), context.getCurrentAddressValue(), valueToRestore);
        }
    }
}

