/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassloadingUtil {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String INSTANTIATION_EXCEPTION_MESSAGE = "Your class must have a constructor without arguments. If it is an inner class, it must be static!";

    public static Object newInstanceFromClassLoader(String className, Class<?> expectedType) {
        return ClassloadingUtil.newInstanceFromClassLoader(ClassloadingUtil.class, className, expectedType);
    }

    public static Object newInstanceFromClassLoader(Class<?> classOwner, String className, Class<?> expectedType) {
        ClassLoader loader = classOwner.getClassLoader();
        try {
            return ClassloadingUtil.getInstanceWithTypeCheck(className, expectedType, loader);
        }
        catch (Throwable t) {
            if (t instanceof InstantiationException) {
                System.out.println(INSTANTIATION_EXCEPTION_MESSAGE);
            }
            if ((loader = Thread.currentThread().getContextClassLoader()) == null) {
                throw new RuntimeException("No local context classloader", t);
            }
            try {
                return ClassloadingUtil.getInstanceWithTypeCheck(className, expectedType, loader);
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Your class must have a constructor without arguments. If it is an inner class, it must be static! " + className, e);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static Object getInstanceWithTypeCheck(String className, Class<?> expectedType, ClassLoader loader) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> clazz = ClassloadingUtil.loadWithCheck(className, expectedType, loader);
        return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static Object getInstanceForParamsWithTypeCheck(String className, Class<?> expectedType, ClassLoader loader, Class<?>[] parameterTypes, Object ... params) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> clazz = ClassloadingUtil.loadWithCheck(className, expectedType, loader);
        return clazz.getDeclaredConstructor(parameterTypes).newInstance(params);
    }

    private static Class<?> loadWithCheck(String className, Class<?> expectedType, ClassLoader loader) throws ClassNotFoundException {
        Class<?> clazz = loader.loadClass(className);
        if (!expectedType.isAssignableFrom(clazz)) {
            throw new IllegalStateException("clazz [" + className + "] is not assignable from expected type: " + String.valueOf(expectedType));
        }
        return clazz;
    }

    public static URL findResource(String resourceName) {
        return ClassloadingUtil.findResource(ClassloadingUtil.class.getClassLoader(), resourceName);
    }

    public static URL findResource(ClassLoader loader, String resourceName) {
        try {
            URL resource = loader.getResource(resourceName);
            if (resource != null) {
                return resource;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            return null;
        }
        return loader.getResource(resourceName);
    }

    public static String loadProperty(ClassLoader loader, String propertiesFile, String name) {
        Properties properties = ClassloadingUtil.loadProperties(loader, propertiesFile);
        return (String)properties.get(name);
    }

    public static Properties loadProperties(String propertiesFile) {
        return ClassloadingUtil.loadProperties(ClassloadingUtil.class.getClassLoader(), propertiesFile);
    }

    public static Properties loadProperties(ClassLoader loader, String propertiesFile) {
        Properties properties = new Properties();
        try {
            URL url = ClassloadingUtil.findResource(loader, propertiesFile);
            if (url != null) {
                properties.load(url.openStream());
            }
        }
        catch (Throwable ignored) {
            logger.warn(ignored.getMessage(), ignored);
        }
        return properties;
    }
}

