/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.tool.help;

import java.util.Map;
import org.wildfly.security.tool.help.HelpSection;

public class CommandsSection
extends HelpSection {
    private final String sectionTitle;
    private final Map<String, String> sectionContent;

    public CommandsSection(Map<String, String> commands) {
        this.sectionTitle = "Commands";
        this.sectionContent = commands;
    }

    @Override
    public void printHelp() {
        this.formatAndPrintTitle(this.sectionTitle);
        if (this.sectionContent != null) {
            int longestCommand = 0;
            for (String string : this.sectionContent.keySet()) {
                if (string.length() <= longestCommand) continue;
                longestCommand = string.length();
            }
            for (Map.Entry entry : this.sectionContent.entrySet()) {
                this.formatAndPrintCommand((String)entry.getKey(), (CharSequence)entry.getValue(), longestCommand);
            }
        }
    }

    protected void formatAndPrintCommand(String commandName, CharSequence commandDescription, int longestCommand) {
        CharSequence descriptionText = commandDescription;
        StringBuilder stringBuilder = new StringBuilder();
        int minCommandAndDescGap = 4;
        int commandDescriptionStartingIndex = longestCommand + minCommandAndDescGap + 4;
        int commandDescriptionLength = 120 - commandDescriptionStartingIndex;
        this.appendGap(stringBuilder, 4);
        stringBuilder.append(commandName);
        int realGap = commandDescriptionStartingIndex - 4 - commandName.length();
        this.appendGap(stringBuilder, realGap);
        if (descriptionText.length() <= commandDescriptionLength) {
            stringBuilder.append(descriptionText);
            stringBuilder.append(System.lineSeparator());
        } else {
            int lineIndex = this.checkForWhitespaceIndex(descriptionText, commandDescriptionLength);
            stringBuilder.append(descriptionText.subSequence(0, lineIndex));
            descriptionText = descriptionText.subSequence(lineIndex + 1, descriptionText.length());
            stringBuilder.append(System.lineSeparator());
            while (0 < descriptionText.length()) {
                this.appendGap(stringBuilder, commandDescriptionStartingIndex);
                if (descriptionText.length() <= commandDescriptionLength) {
                    stringBuilder.append(descriptionText);
                    stringBuilder.append(System.lineSeparator());
                    break;
                }
                lineIndex = this.checkForWhitespaceIndex(descriptionText, commandDescriptionLength);
                stringBuilder.append(descriptionText.subSequence(0, lineIndex));
                descriptionText = descriptionText.subSequence(lineIndex + 1, descriptionText.length());
                stringBuilder.append(System.lineSeparator());
            }
        }
        this.printText(stringBuilder.toString());
    }
}

