/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.apache.activemq.artemis.cli.commands.tools.xml.XmlDataExporter;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.messaging.activemq.AbstractArtemisActionHandler;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq._private.MessagingLogger;

public class ExportJournalOperation
extends AbstractArtemisActionHandler {
    private static final String OPERATION_NAME = "export-journal";
    static final ExportJournalOperation INSTANCE = new ExportJournalOperation();
    private static final String FILE_NAME_FORMAT = "journal-%1$tY%<tm%<td-%<tH%<tM%<tS%<TL%<tz-dump.xml";

    private ExportJournalOperation() {
    }

    static void registerOperation(ManagementResourceRegistration registry, ResourceDescriptionResolver resourceDescriptionResolver) {
        registry.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder(OPERATION_NAME, resourceDescriptionResolver).setRuntimeOnly().setReplyValueType(ModelType.STRING).build(), (OperationStepHandler)INSTANCE);
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.getRunningMode() != RunningMode.ADMIN_ONLY) {
            throw MessagingLogger.ROOT_LOGGER.managementOperationAllowedOnlyInRunningMode(OPERATION_NAME, RunningMode.ADMIN_ONLY);
        }
        this.checkAllowedOnJournal(context, OPERATION_NAME);
        String journal = this.resolvePath(context, MessagingExtension.JOURNAL_DIRECTORY_PATH);
        String bindings = this.resolvePath(context, MessagingExtension.BINDINGS_DIRECTORY_PATH);
        String paging = this.resolvePath(context, MessagingExtension.PAGING_DIRECTORY_PATH);
        String largeMessages = this.resolvePath(context, MessagingExtension.LARGE_MESSAGES_DIRECTORY_PATH);
        XmlDataExporter exporter = new XmlDataExporter();
        String name = String.format(FILE_NAME_FORMAT, new Date());
        File dump = new File(new File(journal).getParent(), name);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(dump);
            exporter.process((OutputStream)fos, bindings, journal, paging, largeMessages);
            context.getResult().set(dump.getAbsolutePath());
        }
        catch (Exception e) {
            throw new OperationFailedException((Throwable)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

