/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms.cli;

import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.BatchModeCommandHandler;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.messaging.activemq._private.MessagingLogger;

class DeleteJMSResourceHandler
extends BatchModeCommandHandler {
    public DeleteJMSResourceHandler(CommandContext ctx) {
        super(ctx, "delete-jms-resource", true);
        this.addRequiredPath("/subsystem=messaging-activemq");
    }

    public ModelNode buildRequestWithoutHeaders(CommandContext ctx) throws OperationFormatException {
        String resource;
        try {
            if (!ctx.getParsedCommandLine().hasProperties()) {
                throw MessagingLogger.ROOT_LOGGER.missingArguments();
            }
        }
        catch (CommandFormatException e) {
            throw new OperationFormatException(e.getLocalizedMessage());
        }
        String jndiName = null;
        String serverName = "default";
        String[] args = ctx.getArgumentsString().split("\\s+");
        int i = 0;
        while (i < args.length) {
            String arg;
            if ((arg = args[i++]).equals("--target")) continue;
            jndiName = arg;
        }
        if (jndiName == null) {
            throw MessagingLogger.ROOT_LOGGER.missingName();
        }
        ModelControllerClient client = ctx.getModelControllerClient();
        if (Util.isTopic((ModelControllerClient)client, jndiName)) {
            resource = "jms-topic";
        } else if (Util.isQueue((ModelControllerClient)client, (String)jndiName)) {
            resource = "jms-queue";
        } else if (Util.isConnectionFactory((ModelControllerClient)client, (String)jndiName)) {
            resource = "connection-factory";
        } else {
            throw MessagingLogger.ROOT_LOGGER.jndiWasNotFound(jndiName);
        }
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.addNode("subsystem", "messaging");
        builder.addNode("server", serverName);
        builder.addNode(resource, jndiName);
        builder.setOperationName("remove");
        return builder.buildRequest();
    }
}

