/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.injection.deployment;

import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.JMSConnectionFactory;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSPasswordCredential;
import jakarta.jms.JMSSessionMode;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.io.Serializable;
import java.util.UUID;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.wildfly.extension.messaging.activemq.injection._private.MessagingLogger;
import org.wildfly.extension.messaging.activemq.injection.deployment.AbstractJMSContext;
import org.wildfly.extension.messaging.activemq.injection.deployment.JMSContextWrapper;
import org.wildfly.extension.messaging.activemq.injection.deployment.JMSInfo;
import org.wildfly.extension.messaging.activemq.injection.deployment.RequestedJMSContext;
import org.wildfly.extension.messaging.activemq.injection.deployment.TransactedJMSContext;

class InjectedJMSContext
extends JMSContextWrapper
implements Serializable {
    private static final String TRANSACTION_SYNCHRONIZATION_REGISTRY_LOOKUP = "java:comp/TransactionSynchronizationRegistry";
    private final JMSInfo info;
    private final RequestedJMSContext requestedJMSContext;
    private final String id = UUID.randomUUID().toString();
    private transient Instance<TransactedJMSContext> transactedJMSContext;
    private transient ConnectionFactory connectionFactory;
    private transient TransactionSynchronizationRegistry transactionSynchronizationRegistry;

    @Inject
    InjectedJMSContext(InjectionPoint ip, RequestedJMSContext requestedJMSContext, Instance<TransactedJMSContext> transactedJMSContext) {
        this.requestedJMSContext = requestedJMSContext;
        this.transactedJMSContext = transactedJMSContext;
        JMSConnectionFactory connectionFactory = (JMSConnectionFactory)ip.getAnnotated().getAnnotation(JMSConnectionFactory.class);
        JMSPasswordCredential credential = (JMSPasswordCredential)ip.getAnnotated().getAnnotation(JMSPasswordCredential.class);
        JMSSessionMode sessionMode = (JMSSessionMode)ip.getAnnotated().getAnnotation(JMSSessionMode.class);
        this.info = new JMSInfo(connectionFactory, credential, sessionMode);
    }

    @Override
    JMSContext getDelegate() {
        boolean inTx = this.isInTransaction();
        RequestedJMSContext jmsContext = inTx ? (AbstractJMSContext)this.transactedJMSContext.get() : this.requestedJMSContext;
        MessagingLogger.ROOT_LOGGER.debugf("using %s to create the injected JMSContext", jmsContext, this.id);
        ConnectionFactory connectionFactory = this.getConnectionFactory();
        JMSContext contextInstance = jmsContext.getContext(this.id, this.info, connectionFactory);
        if (inTx) {
            TransactedJMSContext transactedJMSContext = (TransactedJMSContext)((Object)jmsContext);
            transactedJMSContext.registerCleanUpListener(this.transactionSynchronizationRegistry, contextInstance);
        }
        return contextInstance;
    }

    private boolean isInTransaction() {
        TransactionSynchronizationRegistry tsr = this.getTransactionSynchronizationRegistry();
        boolean inTx = tsr.getTransactionStatus() == 0;
        return inTx;
    }

    private TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        TransactionSynchronizationRegistry cachedTSR = this.transactionSynchronizationRegistry;
        if (cachedTSR == null) {
            this.transactionSynchronizationRegistry = cachedTSR = (TransactionSynchronizationRegistry)this.lookup(TRANSACTION_SYNCHRONIZATION_REGISTRY_LOOKUP);
        }
        return cachedTSR;
    }

    private ConnectionFactory getConnectionFactory() {
        ConnectionFactory cachedCF = this.connectionFactory;
        if (cachedCF == null) {
            this.connectionFactory = cachedCF = (ConnectionFactory)this.lookup(this.info.getConnectionFactoryLookup());
        }
        return cachedCF;
    }

    private Object lookup(String name) {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            Object object = ctx.lookup(name);
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException namingException) {}
            }
        }
    }
}

