/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.embedded;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.client.LocalModelControllerClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.DelegatingModelControllerClient;
import org.wildfly.core.embedded.EmbeddedManagedProcess;
import org.wildfly.core.embedded.EmbeddedProcessStartException;
import org.wildfly.core.embedded.SecurityActions;
import org.wildfly.core.embedded.logging.EmbeddedLogger;
import org.wildfly.core.embedded.spi.BootstrappedEmbeddedProcess;
import org.wildfly.core.embedded.spi.EmbeddedModelControllerClientFactory;
import org.wildfly.core.embedded.spi.EmbeddedProcessBootstrap;
import org.wildfly.core.embedded.spi.EmbeddedProcessBootstrapConfiguration;
import org.wildfly.core.embedded.spi.EmbeddedProcessState;
import org.wildfly.core.embedded.spi.ProcessStateNotifier;

abstract class AbstractEmbeddedManagedProcess
implements EmbeddedManagedProcess {
    private final EmbeddedProcessBootstrap.Type type;
    private final PropertyChangeListener processStateListener;
    private final String[] cmdargs;
    private final ClassLoader embeddedModuleCL;
    private BootstrappedEmbeddedProcess embeddedProcess;
    private ModelControllerClient modelControllerClient;
    private ExecutorService executorService;

    AbstractEmbeddedManagedProcess(EmbeddedProcessBootstrap.Type type, String[] cmdargs, ClassLoader embeddedModuleCL) {
        this.type = type;
        this.cmdargs = cmdargs;
        this.embeddedModuleCL = embeddedModuleCL;
        this.processStateListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AbstractEmbeddedManagedProcess.this.establishModelControllerClient();
            }
        };
    }

    @Override
    public final synchronized ModelControllerClient getModelControllerClient() {
        return this.modelControllerClient == null ? null : new DelegatingModelControllerClient(this::getActiveModelControllerClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start() throws EmbeddedProcessStartException {
        EmbeddedProcessBootstrapConfiguration bootstrapConfiguration = this.getBootstrapConfiguration();
        ClassLoader tccl = SecurityActions.getTccl();
        try {
            block8: {
                SecurityActions.setTccl(this.embeddedModuleCL);
                EmbeddedProcessBootstrap bootstrap = this.loadEmbeddedProcessBootstrap();
                this.embeddedProcess = bootstrap.startup(bootstrapConfiguration);
                if (this.embeddedProcess != null) break block8;
                return;
            }
            try {
                this.executorService = Executors.newCachedThreadPool();
                ProcessStateNotifier processStateNotifier = this.embeddedProcess.getProcessStateNotifier();
                processStateNotifier.addProcessStateListener(this.processStateListener);
                this.establishModelControllerClient();
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception ex) {
                throw EmbeddedLogger.ROOT_LOGGER.cannotStartEmbeddedServer(ex);
            }
        }
        finally {
            SecurityActions.setTccl(tccl);
        }
    }

    @Override
    public final void stop() {
        ClassLoader tccl = SecurityActions.getTccl();
        try {
            SecurityActions.setTccl(this.embeddedModuleCL);
            this.exit();
        }
        finally {
            SecurityActions.setTccl(tccl);
        }
    }

    @Override
    public String getProcessState() {
        if (this.embeddedProcess == null) {
            return null;
        }
        return this.embeddedProcess.getProcessStateNotifier().getEmbeddedProcessState().toString();
    }

    @Override
    public boolean canQueryProcessState() {
        return true;
    }

    EmbeddedProcessBootstrapConfiguration getBootstrapConfiguration() {
        return new EmbeddedProcessBootstrapConfiguration(this.cmdargs, status -> this.exit());
    }

    private EmbeddedProcessBootstrap loadEmbeddedProcessBootstrap() {
        ServiceLoader<EmbeddedProcessBootstrap> loader = ServiceLoader.load(EmbeddedProcessBootstrap.class, this.embeddedModuleCL);
        for (EmbeddedProcessBootstrap epb : loader) {
            if (this.type != epb.getType()) continue;
            return epb;
        }
        throw new IllegalStateException();
    }

    private synchronized void establishModelControllerClient() {
        EmbeddedModelControllerClientFactory clientFactory;
        assert (this.embeddedProcess != null);
        EmbeddedProcessState eps = this.embeddedProcess.getProcessStateNotifier().getEmbeddedProcessState();
        LocalModelControllerClient newClient = null;
        if (eps != EmbeddedProcessState.STOPPING && eps != EmbeddedProcessState.STOPPED && (clientFactory = this.embeddedProcess.getModelControllerClientFactory()) != null) {
            newClient = clientFactory.createEmbeddedClient(this.executorService);
        }
        this.modelControllerClient = newClient;
    }

    private synchronized ModelControllerClient getActiveModelControllerClient() {
        assert (this.embeddedProcess != null);
        switch (this.embeddedProcess.getProcessStateNotifier().getEmbeddedProcessState()) {
            case STOPPING: {
                throw EmbeddedLogger.ROOT_LOGGER.processIsStopping();
            }
            case STOPPED: {
                throw EmbeddedLogger.ROOT_LOGGER.processIsStopped();
            }
            case STARTING: 
            case RUNNING: {
                if (this.modelControllerClient != null) break;
                this.establishModelControllerClient();
                if (this.modelControllerClient != null) break;
                throw EmbeddedLogger.ROOT_LOGGER.processIsReloading();
            }
        }
        return this.modelControllerClient;
    }

    private void exit() {
        if (this.embeddedProcess != null) {
            try {
                this.embeddedProcess.getServiceContainer().shutdown();
                this.embeddedProcess.getServiceContainer().awaitTermination();
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (InterruptedException ite) {
                this.logExitError(ite);
                Thread.currentThread().interrupt();
            }
            catch (Exception ex) {
                this.logExitError(ex);
            }
            this.embeddedProcess.getProcessStateNotifier().removeProcessStateListener(this.processStateListener);
            this.embeddedProcess = null;
        }
        if (this.executorService != null) {
            try {
                this.executorService.shutdown();
                this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (InterruptedException ite) {
                this.logExitError(ite);
                Thread.currentThread().interrupt();
            }
            catch (Exception ex) {
                this.logExitError(ex);
            }
        }
        if (this.embeddedProcess != null) {
            this.embeddedProcess.close();
            this.embeddedProcess = null;
        }
    }

    private void logExitError(Exception ex) {
        EmbeddedLogger.ROOT_LOGGER.errorExitingEmbeddedProcess(ex, this.type.getLogForm(), ex.getLocalizedMessage());
    }
}

