/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.LeafReaderContext;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.TopDocsDataCollectorExecutionContext;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.Values;
import org.hibernate.search.backend.lucene.search.common.impl.AbstractLuceneValueFieldSearchQueryElementFactory;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldTypeContext;
import org.hibernate.search.backend.lucene.search.highlighter.impl.LuceneAbstractSearchHighlighter;
import org.hibernate.search.backend.lucene.search.projection.impl.AbstractNestingAwareAccumulatingValues;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionTransformContext;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.dsl.spi.HighlightProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.ProjectionAccumulator;

public class LuceneFieldHighlightProjection<T>
implements LuceneSearchProjection<T> {
    private final Set<String> indexNames;
    private final Analyzer analyzer;
    private final String absoluteFieldPath;
    private final String highlighterName;
    private final String nestedDocumentPath;
    private final LuceneSearchIndexValueFieldTypeContext<?> typeContext;
    private final ProjectionAccumulator.Provider<String, T> accumulatorProvider;

    private LuceneFieldHighlightProjection(Builder builder, ProjectionAccumulator.Provider<String, T> accumulatorProvider) {
        this(builder.scope, builder.field, builder.highlighterName(), accumulatorProvider);
    }

    LuceneFieldHighlightProjection(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<?> field, String highlighterName, ProjectionAccumulator.Provider<String, T> accumulatorProvider) {
        this.indexNames = scope.hibernateSearchIndexNames();
        this.analyzer = field.type().searchAnalyzerOrNormalizer();
        this.absoluteFieldPath = field.absolutePath();
        this.highlighterName = highlighterName;
        this.nestedDocumentPath = field.nestedDocumentPath();
        this.typeContext = field.type();
        this.accumulatorProvider = accumulatorProvider;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[absoluteFieldPath=" + this.absoluteFieldPath + "highlighterName=" + this.highlighterName + "]";
    }

    @Override
    public Set<String> indexNames() {
        return this.indexNames;
    }

    @Override
    public LuceneSearchProjection.Extractor<?, T> request(ProjectionRequestContext context) {
        if (context.absoluteCurrentFieldPath() != null) {
            throw log.cannotHighlightInNestedContext(context.absoluteCurrentFieldPath(), EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
        }
        context.checkValidField(this.absoluteFieldPath);
        LuceneAbstractSearchHighlighter highlighter = context.highlighter(this.highlighterName);
        if (!this.typeContext.highlighterTypeSupported(highlighter.type())) {
            throw log.highlighterTypeNotSupported(highlighter.type(), this.absoluteFieldPath);
        }
        highlighter.request(context, this.absoluteFieldPath);
        if (!highlighter.isCompatible(this.accumulatorProvider)) {
            throw log.highlighterIncompatibleCardinality();
        }
        return new FieldHighlightExtractor(context.absoluteCurrentNestedFieldPath(), highlighter, this.accumulatorProvider.get());
    }

    public static class Builder
    extends HighlightProjectionBuilder {
        private final LuceneSearchIndexScope<?> scope;
        private final LuceneSearchIndexValueFieldContext<?> field;

        public Builder(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<?> field) {
            super(field.absolutePath());
            this.scope = scope;
            this.field = field;
        }

        protected String highlighterName() {
            return this.highlighterName;
        }

        public <V> SearchProjection<V> build(ProjectionAccumulator.Provider<String, V> accumulatorProvider) {
            return new LuceneFieldHighlightProjection<V>(this, accumulatorProvider);
        }
    }

    private class FieldHighlightExtractor<A>
    implements LuceneSearchProjection.Extractor<A, T> {
        private final String parentDocumentPath;
        private final LuceneAbstractSearchHighlighter highlighter;
        private final ProjectionAccumulator<String, String, A, T> accumulator;

        private FieldHighlightExtractor(String parentDocumentPath, LuceneAbstractSearchHighlighter highlighter, ProjectionAccumulator<String, String, A, T> accumulator) {
            this.parentDocumentPath = parentDocumentPath;
            this.highlighter = highlighter;
            this.accumulator = accumulator;
        }

        @Override
        public Values<A> values(ProjectionExtractContext context) {
            return this.highlighter.createValues(this.parentDocumentPath, LuceneFieldHighlightProjection.this.nestedDocumentPath, LuceneFieldHighlightProjection.this.absoluteFieldPath, LuceneFieldHighlightProjection.this.analyzer, context, this.accumulator);
        }

        @Override
        public T transform(LoadingResult<?> loadingResult, A extractedData, ProjectionTransformContext context) {
            return this.accumulator.finish(extractedData);
        }
    }

    public static class Factory<F>
    extends AbstractLuceneValueFieldSearchQueryElementFactory<HighlightProjectionBuilder, F> {
        @Override
        public HighlightProjectionBuilder create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            if (field.nestedDocumentPath() != null) {
                throw LuceneSearchProjection.log.cannotHighlightFieldFromNestedObjectStructure(EventContexts.fromIndexFieldAbsolutePath((String)field.absolutePath()));
            }
            return new Builder(scope, field);
        }
    }

    public static abstract class HighlighterValues<A, T>
    extends AbstractNestingAwareAccumulatingValues<String, A> {
        protected LeafReaderContext leafReaderContext;

        protected HighlighterValues(String parentDocumentPath, String nestedDocumentPath, TopDocsDataCollectorExecutionContext context, ProjectionAccumulator<String, ?, A, T> accumulator) {
            super(parentDocumentPath, nestedDocumentPath, accumulator, context);
        }

        @Override
        public void context(LeafReaderContext context) throws IOException {
            super.context(context);
            this.leafReaderContext = context;
        }

        @Override
        protected A accumulate(A accumulated, int docId) throws IOException {
            return (A)this.accumulator.accumulateAll(accumulated, this.highlight(docId));
        }

        protected abstract List<String> highlight(int var1) throws IOException;
    }
}

