/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.sort.impl;

import java.lang.invoke.MethodHandles;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.SloppyMath;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.MultiValueMode;
import org.hibernate.search.backend.lucene.search.common.impl.AbstractLuceneValueFieldSearchQueryElementFactory;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.types.sort.comparatorsource.impl.LuceneFieldComparatorSource;
import org.hibernate.search.backend.lucene.types.sort.comparatorsource.impl.LuceneGeoPointDistanceComparatorSource;
import org.hibernate.search.backend.lucene.types.sort.impl.AbstractLuceneDocumentValueSort;
import org.hibernate.search.backend.lucene.types.sort.impl.SortMissingValue;
import org.hibernate.search.engine.search.common.SortMode;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.engine.search.sort.dsl.SortOrder;
import org.hibernate.search.engine.search.sort.spi.DistanceSortBuilder;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneGeoPointDistanceSort
extends AbstractLuceneDocumentValueSort {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final double effectiveMissingValue;
    private final GeoPoint center;

    private LuceneGeoPointDistanceSort(Builder builder) {
        super(builder);
        this.effectiveMissingValue = builder.getEffectiveMissingValue();
        this.center = builder.center;
    }

    @Override
    protected LuceneFieldComparatorSource doCreateFieldComparatorSource(String nestedDocumentPath, MultiValueMode multiValueMode, Query nestedFilter) {
        return new LuceneGeoPointDistanceComparatorSource(nestedDocumentPath, this.center, this.effectiveMissingValue, multiValueMode, nestedFilter);
    }

    private static class Builder
    extends AbstractLuceneDocumentValueSort.AbstractBuilder
    implements DistanceSortBuilder {
        private GeoPoint center;
        private Object missingValue;

        private Builder(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<GeoPoint> field) {
            super(scope, field);
        }

        public void center(GeoPoint center) {
            this.center = center;
        }

        public void missingFirst() {
            this.missingValue = SortMissingValue.MISSING_FIRST;
        }

        public void missingLast() {
            this.missingValue = SortMissingValue.MISSING_LAST;
        }

        public void missingHighest() {
            this.missingValue = SortMissingValue.MISSING_HIGHEST;
        }

        public void missingLowest() {
            this.missingValue = SortMissingValue.MISSING_LOWEST;
        }

        public void missingAs(GeoPoint value) {
            this.missingValue = value;
        }

        @Override
        public void mode(SortMode mode) {
            switch (mode) {
                case MIN: 
                case MAX: 
                case AVG: 
                case MEDIAN: {
                    super.mode(mode);
                    break;
                }
                default: {
                    throw log.invalidSortModeForDistanceSort(mode, this.getEventContext());
                }
            }
        }

        public SearchSort build() {
            return new LuceneGeoPointDistanceSort(this);
        }

        private double getEffectiveMissingValue() {
            if (this.missingValue == null) {
                return Double.POSITIVE_INFINITY;
            }
            if (this.missingValue == SortMissingValue.MISSING_FIRST) {
                return this.order == SortOrder.DESC ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            }
            if (this.missingValue == SortMissingValue.MISSING_LAST) {
                return this.order == SortOrder.DESC ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if (this.missingValue == SortMissingValue.MISSING_LOWEST) {
                return Double.NEGATIVE_INFINITY;
            }
            if (this.missingValue == SortMissingValue.MISSING_HIGHEST) {
                return Double.POSITIVE_INFINITY;
            }
            if (this.missingValue instanceof GeoPoint) {
                GeoPoint geoPointMissingValue = (GeoPoint)this.missingValue;
                return SloppyMath.haversinMeters((double)geoPointMissingValue.latitude(), (double)geoPointMissingValue.longitude(), (double)this.center.latitude(), (double)this.center.longitude());
            }
            throw new AssertionFailure("Unexpected missing value: " + String.valueOf(this.missingValue));
        }
    }

    public static class Factory
    extends AbstractLuceneValueFieldSearchQueryElementFactory<DistanceSortBuilder, GeoPoint> {
        @Override
        public DistanceSortBuilder create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<GeoPoint> field) {
            return new Builder(scope, field);
        }
    }
}

