/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.rxjava2.propagation;

import io.reactivex.Flowable;
import io.reactivex.functions.BiFunction;
import java.util.concurrent.Executor;
import org.jboss.resteasy.concurrent.ContextualExecutors;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class ContextPropagatorOnFlowableCreateAction
implements BiFunction<Flowable, Subscriber, Subscriber> {
    ContextPropagatorOnFlowableCreateAction() {
    }

    public Subscriber apply(Flowable flowable, Subscriber observer) throws Exception {
        return new ContextCapturerFlowable(flowable, observer, ContextualExecutors.executor());
    }

    private static class ContextCapturerFlowable<T>
    implements Subscriber<T> {
        private final Subscriber<T> source;
        private final Executor contextExecutor;

        private ContextCapturerFlowable(Flowable<T> observable, Subscriber<T> observer, Executor contextExecutor) {
            this.source = observer;
            this.contextExecutor = contextExecutor;
        }

        public void onComplete() {
            this.contextExecutor.execute(() -> this.source.onComplete());
        }

        public void onError(Throwable t) {
            this.contextExecutor.execute(() -> this.source.onError(t));
        }

        public void onNext(T v) {
            this.contextExecutor.execute(() -> this.source.onNext(v));
        }

        public void onSubscribe(Subscription s) {
            this.contextExecutor.execute(() -> this.source.onSubscribe(s));
        }
    }
}

