/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent.resource.definition;

import java.util.function.Consumer;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.concurrent.WildFlyContextService;
import org.jboss.as.ee.concurrent.WildFlyManagedThreadFactory;
import org.jboss.as.ee.concurrent.service.ManagedThreadFactoryService;
import org.jboss.as.ee.resource.definition.ResourceDefinitionInjectionSource;
import org.jboss.as.ee.subsystem.ManagedThreadFactoryResourceDefinition;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.msc.Service;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

public class ManagedThreadFactoryDefinitionInjectionSource
extends ResourceDefinitionInjectionSource {
    public static final String CONTEXT_PROP = "context";
    public static final String PRIORITY_PROP = "priority";
    private String contextServiceRef;
    private int priority = 5;

    public ManagedThreadFactoryDefinitionInjectionSource(String jndiName) {
        super(jndiName);
    }

    public void getResourceValue(InjectionSource.ResolutionContext context, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, final Injector<ManagedReferenceFactory> injector) throws DeploymentUnitProcessingException {
        String resourceName = this.uniqueName(context);
        String resourceJndiName = "java:jboss/ee/concurrency/definition/managedScheduledExecutor/" + resourceName;
        try {
            ServiceName resourceServiceName = ManagedThreadFactoryResourceDefinition.CAPABILITY.getCapabilityServiceName(new String[]{resourceName});
            ServiceBuilder resourceServiceBuilder = phaseContext.getServiceTarget().addService(resourceServiceName);
            Consumer consumer = resourceServiceBuilder.provides(new ServiceName[]{resourceServiceName});
            final ManagedThreadFactoryService resourceService = new ManagedThreadFactoryService(consumer, null, resourceName, resourceJndiName, this.priority);
            Injector<ManagedReferenceFactory> contextServiceLookupInjector = new Injector<ManagedReferenceFactory>(){

                public void inject(ManagedReferenceFactory value) throws InjectionException {
                    resourceService.getContextServiceSupplier().set(() -> (WildFlyContextService)value.getReference().getInstance());
                }

                public void uninject() {
                    resourceService.getContextServiceSupplier().set(() -> null);
                }
            };
            String contextServiceRef = this.contextServiceRef == null || this.contextServiceRef.isEmpty() ? "java:comp/DefaultContextService" : this.contextServiceRef;
            ContextNames.BindInfo contextServiceBindInfo = ContextNames.bindInfoForEnvEntry((String)context.getApplicationName(), (String)context.getModuleName(), (String)context.getComponentName(), (!context.isCompUsesModule() ? 1 : 0) != 0, (String)contextServiceRef);
            contextServiceBindInfo.setupLookupInjection(resourceServiceBuilder, (Injector)contextServiceLookupInjector, phaseContext.getDeploymentUnit(), false);
            resourceServiceBuilder.setInstance((Service)resourceService);
            resourceServiceBuilder.install();
            serviceBuilder.addDependency(resourceServiceName, WildFlyManagedThreadFactory.class, (Injector)new Injector<WildFlyManagedThreadFactory>(){

                public void inject(final WildFlyManagedThreadFactory resource) throws InjectionException {
                    injector.inject(() -> new ManagedReference(){

                        public void release() {
                        }

                        public Object getInstance() {
                            return resource;
                        }
                    });
                }

                public void uninject() {
                    injector.uninject();
                }
            });
        }
        catch (Exception e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
    }

    public String getContextServiceRef() {
        return this.contextServiceRef;
    }

    public void setContextServiceRef(String contextServiceRef) {
        this.contextServiceRef = contextServiceRef;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }
}

