/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl;

import java.io.StringWriter;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.infinispan.protostream.Message;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.TagReader;
import org.infinispan.protostream.annotations.ProtoSchemaBuilderException;
import org.infinispan.protostream.annotations.impl.BaseProtoSchemaGenerator;
import org.infinispan.protostream.annotations.impl.IndentWriter;
import org.infinispan.protostream.annotations.impl.ProtoEnumTypeMetadata;
import org.infinispan.protostream.annotations.impl.ProtoEnumValueMetadata;
import org.infinispan.protostream.annotations.impl.ProtoFieldMetadata;
import org.infinispan.protostream.annotations.impl.ProtoMapMetadata;
import org.infinispan.protostream.annotations.impl.ProtoMessageTypeMetadata;
import org.infinispan.protostream.annotations.impl.ProtoTypeMetadata;
import org.infinispan.protostream.annotations.impl.types.XClass;
import org.infinispan.protostream.annotations.impl.types.XConstructor;
import org.infinispan.protostream.annotations.impl.types.XExecutable;
import org.infinispan.protostream.annotations.impl.types.XTypeFactory;
import org.infinispan.protostream.descriptors.JavaType;
import org.infinispan.protostream.descriptors.Type;
import org.infinispan.protostream.descriptors.WireType;
import org.infinispan.protostream.impl.TagWriterImpl;

public abstract class AbstractMarshallerCodeGenerator {
    private static final String PROTOSTREAM_PACKAGE = SerializationContext.class.getPackage().getName();
    protected static final String ADAPTER_FIELD_NAME = "__a$";
    private final XTypeFactory typeFactory;
    private final boolean noDefaults = false;
    private final String protobufSchemaPackage;
    private final boolean useGenerics = false;

    protected AbstractMarshallerCodeGenerator(XTypeFactory typeFactory, String protobufSchemaPackage) {
        this.typeFactory = typeFactory;
        this.protobufSchemaPackage = protobufSchemaPackage;
    }

    protected String generateEnumDecodeMethodBody(ProtoEnumTypeMetadata enumTypeMetadata) {
        StringWriter sw = new StringWriter();
        IndentWriter iw = new IndentWriter(sw);
        iw.println("{");
        iw.inc();
        iw.println("switch ($1) {");
        iw.inc();
        for (ProtoEnumValueMetadata value : enumTypeMetadata.getMembers().values()) {
            iw.printf("case %d: return %s;\n", value.getNumber(), value.getJavaEnumName());
        }
        iw.println("default: return null;");
        iw.dec();
        iw.println("}");
        iw.dec();
        iw.println("}");
        return sw.toString();
    }

    protected String generateEnumEncodeMethodBody(ProtoEnumTypeMetadata enumTypeMetadata) {
        StringWriter sw = new StringWriter();
        IndentWriter iw = new IndentWriter(sw);
        iw.println("{");
        iw.inc();
        iw.println("switch ($1.ordinal()) {");
        iw.inc();
        for (ProtoEnumValueMetadata value : enumTypeMetadata.getMembers().values()) {
            iw.printf("case %d: return %d;\n", value.getJavaEnumOrdinal(), value.getNumber());
        }
        iw.printf("default: throw new IllegalArgumentException(\"Unexpected %s enum value : \" + $1.name());\n", enumTypeMetadata.getJavaClassName());
        iw.dec();
        iw.println("}");
        iw.dec();
        iw.println("}");
        return sw.toString();
    }

    protected String makeQualifiedTypeName(String fullName) {
        if (this.protobufSchemaPackage != null) {
            return this.protobufSchemaPackage + "." + fullName;
        }
        return fullName;
    }

    private String makeTestFieldWasNotSet(Collection<ProtoFieldMetadata> fields, Map<String, Integer> trackedFields) {
        HashMap<Integer, Long> masks = new HashMap<Integer, Long>();
        for (ProtoFieldMetadata field : fields) {
            int fieldBitIndex = trackedFields.get(field.getName());
            masks.merge(fieldBitIndex >> 6, 1L << fieldBitIndex, (a, b) -> a | b);
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        Iterator iterator = masks.keySet().iterator();
        while (iterator.hasNext()) {
            int set = (Integer)iterator.next();
            if (first) {
                first = false;
            } else {
                sb.append(" || ");
            }
            long mask = (Long)masks.get(set);
            sb.append("(__bits$").append(set).append(" & ").append(mask).append("L) != ").append(mask).append('L');
        }
        return sb.toString();
    }

    private String makeTestFieldWasNotSet(ProtoFieldMetadata field, Map<String, Integer> trackedFields) {
        int fieldBitIndex = trackedFields.get(field.getName());
        return "((__bits$" + (fieldBitIndex >> 6) + " & " + (1L << fieldBitIndex) + "L) == 0)";
    }

    private String makeFieldWasSet(ProtoFieldMetadata field, Map<String, Integer> trackedFields) {
        int fieldBitIndex = trackedFields.get(field.getName());
        return "__bits$" + (fieldBitIndex >> 6) + " |= " + (1L << fieldBitIndex) + "L";
    }

    private String makeFieldLocalVar(ProtoFieldMetadata field) {
        return "__v$" + field.getNumber();
    }

    private String makeCollectionLocalVar(ProtoFieldMetadata field) {
        return "__c$" + field.getNumber();
    }

    private String makeArrayLocalVar(ProtoFieldMetadata field) {
        return ADAPTER_FIELD_NAME + field.getNumber();
    }

    protected String makeMarshallerDelegateFieldName(ProtoFieldMetadata field) {
        return "__md$" + field.getNumber() + (field.getJavaType().isEnum() ? "e" : "");
    }

    protected void generateReadMethodBody(IndentWriter iw, ProtoMessageTypeMetadata messageTypeMetadata) {
        String val;
        boolean noFactory;
        Object getUnknownFieldSetFieldStatement = null;
        Object setUnknownFieldSetFieldStatement = null;
        if (messageTypeMetadata.getUnknownFieldSetField() != null) {
            getUnknownFieldSetFieldStatement = "o." + messageTypeMetadata.getUnknownFieldSetField().getName();
            setUnknownFieldSetFieldStatement = "o." + messageTypeMetadata.getUnknownFieldSetField().getName() + " = u";
        } else if (messageTypeMetadata.getUnknownFieldSetGetter() != null) {
            getUnknownFieldSetFieldStatement = "o." + messageTypeMetadata.getUnknownFieldSetGetter().getName() + "()";
            setUnknownFieldSetFieldStatement = "o." + messageTypeMetadata.getUnknownFieldSetSetter().getName() + "(u)";
        } else if (messageTypeMetadata.getJavaClass().isAssignableTo(Message.class)) {
            getUnknownFieldSetFieldStatement = "o.getUnknownFieldSet()";
            setUnknownFieldSetFieldStatement = "o.setUnknownFieldSet(u)";
        }
        iw.printf("final %s $in = $1.getReader();\n", TagReader.class.getName());
        if (messageTypeMetadata.isContainer()) {
            iw.printf("Object __v$sizeParam = $1.getParam(\"%s\");\n", "containerSize");
            iw.println("int __v$size = ((java.lang.Integer) __v$sizeParam).intValue();");
        }
        boolean bl = noFactory = messageTypeMetadata.getFactory() == null;
        if (noFactory) {
            iw.printf("final %s o = new %s();\n", messageTypeMetadata.getJavaClassName(), messageTypeMetadata.getJavaClassName());
        }
        int mandatoryFields = 0;
        LinkedHashMap<String, Integer> trackedFields = new LinkedHashMap<String, Integer>();
        for (ProtoFieldMetadata fieldMetadata : messageTypeMetadata.getFields().values()) {
            if (fieldMetadata.isRequired() && fieldMetadata.getDefaultValue() == null) {
                ++mandatoryFields;
            }
            if (!fieldMetadata.isRequired() && (fieldMetadata.getDefaultValue() == null || !noFactory && !fieldMetadata.isRepeated() && fieldMetadata.getProtobufType() != Type.BYTES)) continue;
            int trackedFieldsSize = trackedFields.size();
            if (trackedFieldsSize % 64 == 0) {
                iw.printf("long __bits$%s = 0;\n", trackedFieldsSize >> 6);
            }
            trackedFields.put(fieldMetadata.getName(), trackedFieldsSize);
        }
        for (ProtoFieldMetadata fieldMetadata : messageTypeMetadata.getFields().values()) {
            if (fieldMetadata.isRepeated()) {
                iw.printf("%s %s = ", fieldMetadata.getRepeatedImplementation().getCanonicalName(), this.makeCollectionLocalVar(fieldMetadata));
                if (fieldMetadata.isArray()) {
                    iw.print("null");
                } else if (fieldMetadata.isMap()) {
                    iw.printf("new %s()", fieldMetadata.getRepeatedImplementation().getCanonicalName());
                } else {
                    iw.printf("new %s()", fieldMetadata.getRepeatedImplementation().getCanonicalName());
                }
                iw.println(";");
                if (noFactory || !fieldMetadata.isArray()) continue;
                iw.printf("%s[] %s = ", fieldMetadata.getJavaTypeName(), this.makeArrayLocalVar(fieldMetadata));
                iw.printf("new %s[0]", fieldMetadata.getJavaTypeName());
                iw.println(";");
                continue;
            }
            if (noFactory) continue;
            iw.printf("%s %s", fieldMetadata.getJavaTypeName(), this.makeFieldLocalVar(fieldMetadata));
            Object defaultValue = fieldMetadata.getDefaultValue();
            if (defaultValue != null && fieldMetadata.getProtobufType() != Type.BYTES) {
                val = this.toJavaLiteral(defaultValue, fieldMetadata.getJavaType());
                iw.printf(" = %s", this.box(val, fieldMetadata.getJavaType()));
            } else if (fieldMetadata.isBoxedPrimitive() || fieldMetadata.getProtobufType() == Type.BYTES || fieldMetadata.getProtobufType().getJavaType() == JavaType.STRING || fieldMetadata.getProtobufType().getJavaType() == JavaType.BYTE_STRING || fieldMetadata.getProtobufType().getJavaType() == JavaType.ENUM || fieldMetadata.getProtobufType().getJavaType() == JavaType.MESSAGE || fieldMetadata.getJavaType().getCanonicalName().equals(Date.class.getCanonicalName()) || fieldMetadata.getJavaType().getCanonicalName().equals(Instant.class.getCanonicalName())) {
                iw.print(" = null");
            } else if (fieldMetadata.isPrimitive()) {
                if (fieldMetadata.getProtobufType() == Type.BOOL) {
                    iw.print(" = false");
                } else {
                    iw.print(" = 0");
                }
            }
            iw.println(";");
        }
        iw.println("boolean done = false;");
        iw.println("while (!done) {");
        iw.inc();
        iw.println("final int tag = $in.readTag();");
        iw.println("switch (tag) {");
        iw.inc();
        iw.println("case 0: {");
        iw.inc();
        iw.println("done = true;");
        iw.println("break;");
        iw.dec();
        iw.println("}");
        for (ProtoFieldMetadata fieldMetadata : messageTypeMetadata.getFields().values()) {
            this.generateFieldReadMethod(messageTypeMetadata, fieldMetadata, iw, noFactory, trackedFields, (String)getUnknownFieldSetFieldStatement, (String)setUnknownFieldSetFieldStatement);
        }
        iw.println("default: {");
        iw.inc();
        if (getUnknownFieldSetFieldStatement != null) {
            iw.printf("%s.UnknownFieldSet u = %s;\n", PROTOSTREAM_PACKAGE, getUnknownFieldSetFieldStatement);
            iw.printf("if (u == null) u = new %s.impl.UnknownFieldSetImpl();\n", PROTOSTREAM_PACKAGE);
            iw.println("if (!u.readSingleField(tag, $in)) done = true;");
            iw.printf("if (!u.isEmpty()) %s;\n", setUnknownFieldSetFieldStatement);
        } else {
            iw.println("if (!$in.skipField(tag)) done = true;");
        }
        iw.dec().println("}");
        iw.dec().println("}");
        iw.dec().println("}");
        if (BaseProtoSchemaGenerator.generateMarshallerDebugComments) {
            iw.println();
            iw.println("// default values");
            iw.println();
        }
        for (ProtoFieldMetadata fieldMetadata : messageTypeMetadata.getFields().values()) {
            Object defaultValue = fieldMetadata.getDefaultValue();
            if (defaultValue == null || !noFactory && !fieldMetadata.isRepeated() && fieldMetadata.getProtobufType() != Type.BYTES) continue;
            iw.printf("if %s {\n", this.makeTestFieldWasNotSet(fieldMetadata, trackedFields));
            iw.inc();
            val = this.toJavaLiteral(defaultValue, fieldMetadata.getJavaType());
            if (fieldMetadata.isRepeated()) {
                String c = this.makeCollectionLocalVar(fieldMetadata);
                if (fieldMetadata.isArray()) {
                    iw.printf("if (%s == null) %s = new %s();\n", c, c, fieldMetadata.getRepeatedImplementation().getCanonicalName());
                }
                iw.printf("%s.add(%s);\n", c, this.box(val, this.typeFactory.fromClass(defaultValue.getClass())));
            } else if (noFactory) {
                iw.printf("%s;\n", this.createSetPropExpr(messageTypeMetadata, fieldMetadata, "o", this.box(val, fieldMetadata.getJavaType())));
            } else {
                iw.printf("%s = %s;\n", this.makeFieldLocalVar(fieldMetadata), this.box(val, fieldMetadata.getJavaType()));
            }
            iw.dec();
            iw.println("}");
        }
        for (ProtoFieldMetadata fieldMetadata : messageTypeMetadata.getFields().values()) {
            if (!fieldMetadata.isRepeated()) continue;
            Object c = this.makeCollectionLocalVar(fieldMetadata);
            if (fieldMetadata.isArray()) {
                if (fieldMetadata.getDefaultValue() == null) {
                    iw.printf("if (%s != null)", c);
                }
                iw.println("{");
                iw.inc();
                String a = this.makeArrayLocalVar(fieldMetadata);
                if (fieldMetadata.getJavaType().isPrimitive()) {
                    if (noFactory) {
                        iw.printf("%s[] ", fieldMetadata.getJavaTypeName());
                    }
                    iw.printf("%s = new %s[%s.size()];\n", a, fieldMetadata.getJavaTypeName(), c);
                    XClass boxedType = this.box(fieldMetadata.getJavaType());
                    iw.println("int _j =0;");
                    iw.printf("for (java.util.Iterator _it = %s.iterator(); _it.hasNext();) %s[_j++] = %s;\n", c, a, this.unbox("((" + boxedType.getName() + ") _it.next())", boxedType));
                    c = a;
                } else {
                    c = "(" + fieldMetadata.getJavaTypeName() + "[])" + (String)c + ".toArray(new " + fieldMetadata.getJavaTypeName() + "[0])";
                }
            }
            if (noFactory) {
                iw.append(this.createSetPropExpr(messageTypeMetadata, fieldMetadata, "o", (String)c)).append(";\n");
            } else if (fieldMetadata.isArray() && !fieldMetadata.getJavaType().isPrimitive()) {
                iw.append(this.makeArrayLocalVar(fieldMetadata)).append(" = ").append((CharSequence)c).append(";\n");
            }
            if (fieldMetadata.isArray()) {
                iw.dec().append('}');
                if (fieldMetadata.getDefaultValue() == null) {
                    c = "new " + fieldMetadata.getJavaTypeName() + "[0]";
                    iw.println(" else {");
                    iw.inc();
                    if (noFactory) {
                        iw.printf("%s;\n", this.createSetPropExpr(messageTypeMetadata, fieldMetadata, "o", (String)c));
                    } else {
                        iw.printf("%s = %s;\n", this.makeArrayLocalVar(fieldMetadata), c);
                    }
                    iw.dec().println("}");
                }
            }
            iw.println();
        }
        if (mandatoryFields > 0) {
            List<ProtoFieldMetadata> mandatory = messageTypeMetadata.getFields().values().stream().filter(f -> f.isRequired() && f.getDefaultValue() == null).collect(Collectors.toList());
            iw.append("if (").append(this.makeTestFieldWasNotSet(mandatory, trackedFields)).append(") {\n");
            iw.inc();
            iw.append("final StringBuilder missing = new StringBuilder();\n");
            boolean first = true;
            for (ProtoFieldMetadata fieldMetadata : messageTypeMetadata.getFields().values()) {
                if (!fieldMetadata.isRequired()) continue;
                iw.append("if ").append(this.makeTestFieldWasNotSet(fieldMetadata, trackedFields)).append(" {\n");
                iw.inc();
                if (first) {
                    first = false;
                } else {
                    iw.append("if (missing.length() > 0) missing.append(\", \");\n");
                }
                iw.append("missing.append(\"").append(fieldMetadata.getName()).append("\");\n");
                iw.dec();
                iw.append("}\n");
            }
            iw.println("throw new java.io.IOException(\"Required field(s) missing from input stream : \" + missing);");
            iw.dec();
            iw.println("}");
        }
        if (noFactory) {
            iw.println("return o;");
        } else {
            iw.print("return ");
            XExecutable factory = messageTypeMetadata.getFactory();
            if (factory instanceof XConstructor) {
                iw.printf("new %s", messageTypeMetadata.getJavaClassName());
            } else if (factory.isStatic()) {
                iw.printf("%s.%s", messageTypeMetadata.getAnnotatedClassName(), factory.getName());
            } else {
                iw.printf("%s.%s", ADAPTER_FIELD_NAME, factory.getName());
            }
            iw.print('(');
            boolean first = true;
            for (String paramName : factory.getParameterNames()) {
                if (first) {
                    first = false;
                    if (messageTypeMetadata.isContainer()) {
                        iw.print("__v$size");
                        continue;
                    }
                } else {
                    iw.append(", ");
                }
                boolean found = false;
                for (ProtoFieldMetadata fieldMetadata : messageTypeMetadata.getFields().values()) {
                    if (!fieldMetadata.getPropertyName().equals(paramName)) continue;
                    String var = fieldMetadata.isRepeated() ? (fieldMetadata.isArray() ? this.makeArrayLocalVar(fieldMetadata) : this.makeCollectionLocalVar(fieldMetadata)) : this.makeFieldLocalVar(fieldMetadata);
                    iw.append(var);
                    found = true;
                    break;
                }
                if (found) continue;
                throw new ProtoSchemaBuilderException("Parameter '" + paramName + "' of factory " + factory + " does not map to any Protobuf field");
            }
            iw.println(");");
        }
    }

    private void generateFieldReadMethod(ProtoMessageTypeMetadata messageTypeMetadata, ProtoFieldMetadata fieldMetadata, IndentWriter iw, boolean noFactory, Map<String, Integer> trackedFields, String getUnknownFieldSetFieldStatement, String setUnknownFieldSetFieldStatement) {
        String v = this.makeFieldLocalVar(fieldMetadata);
        iw.printf("case %s: {\n", AbstractMarshallerCodeGenerator.makeFieldTag(fieldMetadata.getNumber(), fieldMetadata.getProtobufType().getWireType()));
        iw.inc();
        if (BaseProtoSchemaGenerator.generateMarshallerDebugComments) {
            iw.printf("// type = %s, name = %s\n", new Object[]{fieldMetadata.getProtobufType(), fieldMetadata.getName()});
        }
        switch (fieldMetadata.getProtobufType()) {
            case DOUBLE: 
            case FLOAT: 
            case INT64: 
            case UINT64: 
            case INT32: 
            case FIXED64: 
            case FIXED32: 
            case BOOL: 
            case STRING: 
            case BYTES: 
            case UINT32: 
            case SFIXED32: 
            case SFIXED64: 
            case SINT32: 
            case SINT64: {
                if (noFactory || fieldMetadata.isRepeated()) {
                    iw.printf("%s ", fieldMetadata.getJavaTypeName());
                }
                iw.printf("%s = %s;\n", v, this.box(this.convert("$in." + this.makeStreamIOMethodName(fieldMetadata, false) + "()", fieldMetadata), fieldMetadata.getJavaType()));
                this.genSetField(iw, fieldMetadata, trackedFields, messageTypeMetadata);
                break;
            }
            case GROUP: {
                String mdField = this.initMarshallerDelegateField(iw, fieldMetadata);
                if (noFactory || fieldMetadata.isRepeated()) {
                    iw.printf("%s ", fieldMetadata.getJavaTypeName());
                }
                iw.printf("%s = (%s) readMessage(%s, $1);\n", v, fieldMetadata.getJavaTypeName(), mdField);
                iw.printf("$in.checkLastTagWas(%s);\n", AbstractMarshallerCodeGenerator.makeFieldTag(fieldMetadata.getNumber(), WireType.END_GROUP));
                this.genSetField(iw, fieldMetadata, trackedFields, messageTypeMetadata);
                break;
            }
            case MESSAGE: {
                String mdField = this.initMarshallerDelegateField(iw, fieldMetadata);
                iw.println("int length = $in.readUInt32();");
                iw.println("int oldLimit = $in.pushLimit(length);");
                if (noFactory || fieldMetadata.isRepeated()) {
                    iw.printf("%s ", fieldMetadata.getJavaTypeName());
                }
                iw.printf("%s = (%s) readMessage(%s, $1);\n", v, fieldMetadata.getJavaTypeName(), mdField);
                iw.println("$in.checkLastTagWas(0);");
                iw.println("$in.popLimit(oldLimit);");
                this.genSetField(iw, fieldMetadata, trackedFields, messageTypeMetadata);
                break;
            }
            case ENUM: {
                String mdField = this.initMarshallerDelegateField(iw, fieldMetadata);
                iw.println("int enumVal = $in.readEnum();");
                if (noFactory || fieldMetadata.isRepeated()) {
                    iw.printf("%s ", fieldMetadata.getJavaTypeName());
                }
                iw.printf("%s = (%s) %s.getMarshaller().decode(enumVal);\n", v, fieldMetadata.getJavaTypeName(), mdField);
                iw.printf("if (%s == null) {\n", v);
                if (getUnknownFieldSetFieldStatement != null) {
                    iw.inc();
                    iw.printf("%s.UnknownFieldSet u = %s;\n", PROTOSTREAM_PACKAGE, getUnknownFieldSetFieldStatement);
                    iw.printf("if (u == null) { u = new %s.impl.UnknownFieldSetImpl(); %s; }\n", PROTOSTREAM_PACKAGE, setUnknownFieldSetFieldStatement);
                    iw.printf("u.putVarintField(%d, enumVal);\n", fieldMetadata.getNumber());
                    iw.dec();
                }
                iw.println("} else {");
                iw.inc();
                this.genSetField(iw, fieldMetadata, trackedFields, messageTypeMetadata);
                iw.dec().println("}");
                break;
            }
            case MAP: {
                ProtoMapMetadata mapMetadata = (ProtoMapMetadata)fieldMetadata;
                iw.println("int $len = $in.readUInt32();");
                iw.println("int $limit = $in.pushLimit($len);");
                iw.println("int $t = $in.readTag();");
                String key = this.generateMapFieldReadMethod(mapMetadata.getKey(), iw, true);
                String value = this.generateMapFieldReadMethod(mapMetadata.getValue(), iw, false);
                iw.printf("%s.put(%s, %s);\n", this.makeCollectionLocalVar(mapMetadata), key, value);
                iw.println("$in.checkLastTagWas(0);");
                iw.println("$in.popLimit($limit);");
                break;
            }
            default: {
                throw new IllegalStateException("Unknown field type : " + fieldMetadata.getProtobufType());
            }
        }
        iw.println("break;");
        iw.dec().println("}");
    }

    private String generateMapFieldReadMethod(ProtoFieldMetadata fieldMetadata, IndentWriter iw, boolean readNext) {
        String v = "__mv$" + fieldMetadata.getNumber();
        iw.printf("%s %s = %s;\n", fieldMetadata.getJavaTypeName(), v, fieldMetadata.getProtobufType().getJavaType().defaultValueAsString());
        iw.printf("if ($t == %s) {\n", AbstractMarshallerCodeGenerator.makeFieldTag(fieldMetadata.getNumber(), fieldMetadata.getProtobufType().getWireType()));
        iw.inc();
        if (BaseProtoSchemaGenerator.generateMarshallerDebugComments) {
            iw.printf("// type = %s, name = %s\n", new Object[]{fieldMetadata.getProtobufType(), fieldMetadata.getName()});
        }
        switch (fieldMetadata.getProtobufType()) {
            case DOUBLE: 
            case FLOAT: 
            case INT64: 
            case UINT64: 
            case INT32: 
            case FIXED64: 
            case FIXED32: 
            case BOOL: 
            case STRING: 
            case BYTES: 
            case UINT32: 
            case SFIXED32: 
            case SFIXED64: 
            case SINT32: 
            case SINT64: {
                iw.printf("%s = %s;\n", v, this.box(this.convert("$in." + this.makeStreamIOMethodName(fieldMetadata, false) + "()", fieldMetadata), fieldMetadata.getJavaType()));
                break;
            }
            case MESSAGE: {
                String mdField = this.initMarshallerDelegateField(iw, fieldMetadata);
                iw.println("int length = $in.readUInt32();");
                iw.println("int oldLimit = $in.pushLimit(length);");
                iw.printf("%s = (%s) readMessage(%s, $1);\n", v, fieldMetadata.getJavaTypeName(), mdField);
                iw.println("$in.checkLastTagWas(0);");
                iw.println("$in.popLimit(oldLimit);");
                break;
            }
            case ENUM: {
                String mdField = this.initMarshallerDelegateField(iw, fieldMetadata);
                iw.println("int enumVal = $in.readEnum();");
                iw.printf("%s = (%s) %s.getMarshaller().decode(enumVal);\n", v, fieldMetadata.getJavaTypeName(), mdField);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown field type : " + fieldMetadata.getProtobufType());
            }
        }
        if (readNext) {
            iw.println("$t = $in.readTag();");
        }
        iw.dec().println("}");
        return v;
    }

    private static String makeFieldTag(int fieldNumber, WireType wireType) {
        return "(" + fieldNumber + " << " + PROTOSTREAM_PACKAGE + ".descriptors.WireType.TAG_TYPE_NUM_BITS | " + PROTOSTREAM_PACKAGE + ".descriptors.WireType.WIRETYPE_" + wireType.name() + ")";
    }

    private String toJavaLiteral(Object value, XClass javaType) {
        Object v;
        if (javaType.isAssignableTo(Date.class)) {
            v = value + "L";
        } else if (javaType.isAssignableTo(Instant.class)) {
            v = value + "L";
        } else if (value instanceof ProtoEnumValueMetadata) {
            v = ((ProtoEnumValueMetadata)value).getJavaEnumName();
        } else if (value instanceof Long) {
            v = value + "L";
        } else if (value instanceof Double) {
            v = value + "D";
        } else if (value instanceof Float) {
            v = value + "F";
        } else if (value instanceof Character) {
            v = "'" + value + "'";
        } else if (value instanceof String) {
            v = "\"" + value + "\"";
        } else if (value instanceof Short) {
            v = "(short) " + value;
        } else if (value instanceof Byte) {
            v = "(byte) " + value;
        } else if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            StringBuilder sb = new StringBuilder();
            sb.append("new byte[] {");
            for (int i = 0; i < bytes.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(bytes[i]);
            }
            sb.append('}');
            v = sb.toString();
        } else {
            v = value.toString();
        }
        return v;
    }

    private void genSetField(IndentWriter iw, ProtoFieldMetadata fieldMetadata, Map<String, Integer> trackedFields, ProtoMessageTypeMetadata messageTypeMetadata) {
        String v = this.makeFieldLocalVar(fieldMetadata);
        if (fieldMetadata.isRepeated()) {
            if (!fieldMetadata.isMap()) {
                String c = this.makeCollectionLocalVar(fieldMetadata);
                if (fieldMetadata.isArray()) {
                    iw.append("if (").append(c).append(" == null) ").append(c).append(" = new ").append(fieldMetadata.getRepeatedImplementation().getCanonicalName()).append("();\n");
                }
                iw.append(c).append(".add(").append(this.box(v, this.box(fieldMetadata.getJavaType()))).append(");\n");
            }
        } else if (messageTypeMetadata.getFactory() == null) {
            iw.append(this.createSetPropExpr(messageTypeMetadata, fieldMetadata, "o", v)).append(";\n");
        }
        if (trackedFields.containsKey(fieldMetadata.getName())) {
            iw.append(this.makeFieldWasSet(fieldMetadata, trackedFields)).append(";\n");
        }
    }

    protected void generateWriteMethodBody(IndentWriter iw, ProtoMessageTypeMetadata messageTypeMetadata) {
        Object getUnknownFieldSetFieldStatement = null;
        if (messageTypeMetadata.getUnknownFieldSetField() != null) {
            getUnknownFieldSetFieldStatement = "o." + messageTypeMetadata.getUnknownFieldSetField().getName();
        } else if (messageTypeMetadata.getUnknownFieldSetGetter() != null) {
            getUnknownFieldSetFieldStatement = "o." + messageTypeMetadata.getUnknownFieldSetGetter().getName() + "()";
        } else if (messageTypeMetadata.getJavaClass().isAssignableTo(Message.class)) {
            getUnknownFieldSetFieldStatement = "o.getUnknownFieldSet()";
        }
        if (!messageTypeMetadata.getFields().isEmpty() || getUnknownFieldSetFieldStatement != null) {
            iw.printf("%s $out = (%s) $1.getWriter();\n", TagWriterImpl.class.getName(), TagWriterImpl.class.getName());
            iw.printf("final %s o = (%s) $2;\n", messageTypeMetadata.getJavaClassName(), messageTypeMetadata.getJavaClassName());
            for (ProtoFieldMetadata fieldMetadata : messageTypeMetadata.getFields().values()) {
                iw.println("{");
                iw.inc();
                if (BaseProtoSchemaGenerator.generateMarshallerDebugComments) {
                    iw.printf("// type = %s, name = %s\n", new Object[]{fieldMetadata.getProtobufType(), fieldMetadata.getName()});
                }
                String v = this.makeFieldLocalVar(fieldMetadata);
                String f = fieldMetadata.isRepeated() ? (fieldMetadata.isArray() ? this.makeArrayLocalVar(fieldMetadata) : this.makeCollectionLocalVar(fieldMetadata)) : v;
                iw.print("final ");
                if (fieldMetadata.isRepeated()) {
                    if (fieldMetadata.isArray()) {
                        iw.printf("%s[]", fieldMetadata.getJavaTypeName());
                    } else if (fieldMetadata.isMap()) {
                        ProtoMapMetadata mapFieldMetadata = (ProtoMapMetadata)fieldMetadata;
                        iw.printf("java.util.Map<%s, %s>", mapFieldMetadata.getKey().getJavaTypeName(), mapFieldMetadata.getValue().getJavaTypeName());
                    } else {
                        iw.printf("java.util.Collection", new Object[0]);
                    }
                } else {
                    iw.print(fieldMetadata.getJavaTypeName());
                }
                iw.printf(" %s = %s;\n", f, this.createGetPropExpr(messageTypeMetadata, fieldMetadata, "o"));
                if (fieldMetadata.isRequired()) {
                    boolean couldBeNull;
                    boolean bl = couldBeNull = fieldMetadata.isRepeated() || fieldMetadata.isBoxedPrimitive() || fieldMetadata.getProtobufType() == Type.BYTES || fieldMetadata.getProtobufType().getJavaType() == JavaType.STRING || fieldMetadata.getProtobufType().getJavaType() == JavaType.BYTE_STRING || fieldMetadata.getProtobufType().getJavaType() == JavaType.ENUM || fieldMetadata.getProtobufType().getJavaType() == JavaType.MESSAGE;
                    if (couldBeNull) {
                        iw.append("if (").append(f).append(" == null) throw new IllegalStateException(\"Required field must not be null : ").append(fieldMetadata.getName()).append("\");\n");
                    }
                } else if (fieldMetadata.isRepeated() || !fieldMetadata.getJavaType().isPrimitive()) {
                    iw.append("if (").append(f).append(" != null) ");
                }
                if (fieldMetadata.isRepeated()) {
                    iw.append('\n');
                    iw.inc();
                    if (fieldMetadata.isArray()) {
                        iw.printf("for (int i = 0; i < %s.length; i++) {\n", f);
                        iw.inc();
                        iw.printf("final %s %s = %s[i];\n", fieldMetadata.getJavaTypeName(), v, f);
                    } else if (fieldMetadata.isMap()) {
                        ProtoMapMetadata mapFieldMetadata = (ProtoMapMetadata)fieldMetadata;
                        iw.printf("for (java.util.Iterator<java.util.Map.Entry<%s, %s>> it = %s.entrySet().iterator(); it.hasNext(); ) {\n", mapFieldMetadata.getKey().getJavaTypeName(), mapFieldMetadata.getValue().getJavaTypeName(), f);
                        iw.inc();
                        iw.printf("final java.util.Map.Entry<%s, %s> %s = it.next();\n", mapFieldMetadata.getKey().getJavaTypeName(), mapFieldMetadata.getValue().getJavaTypeName(), v);
                        iw.printf("try (NestedWriter $n = new NestedWriter($1, %d)) {\n", fieldMetadata.getNumber());
                        iw.inc();
                        iw.println("$out = $n.getWriter();");
                        this.writeFieldValue(mapFieldMetadata.getKey(), iw, v + ".getKey()", "$out");
                        this.writeFieldValue(mapFieldMetadata.getValue(), iw, v + ".getValue()", "$out");
                        iw.dec();
                        iw.println("}");
                        iw.printf("$out = (%s) $1.getWriter();\n", TagWriterImpl.class.getName());
                    } else {
                        iw.printf("for (java.util.Iterator it = %s.iterator(); it.hasNext(); ) {\n", f);
                        iw.inc();
                        iw.printf("final %s %s = (%s) it.next();\n", fieldMetadata.getJavaTypeName(), v, fieldMetadata.getJavaTypeName());
                    }
                }
                if (!fieldMetadata.isMap()) {
                    this.writeFieldValue(fieldMetadata, iw, v);
                }
                if (fieldMetadata.isRepeated()) {
                    iw.dec().println("}");
                    iw.dec();
                }
                iw.dec().println("}");
            }
            if (getUnknownFieldSetFieldStatement != null) {
                iw.println("{");
                iw.inc();
                iw.printf("%s.UnknownFieldSet u = %s;\n", PROTOSTREAM_PACKAGE, getUnknownFieldSetFieldStatement);
                iw.println("if (u != null && !u.isEmpty()) u.writeTo($out);");
                iw.dec().println("}");
            }
        }
    }

    private void writeFieldValue(ProtoFieldMetadata fieldMetadata, IndentWriter iw, String v) {
        this.writeFieldValue(fieldMetadata, iw, v, "$out");
    }

    private void writeFieldValue(ProtoFieldMetadata fieldMetadata, IndentWriter iw, String v, String out) {
        switch (fieldMetadata.getProtobufType()) {
            case DOUBLE: 
            case FLOAT: 
            case INT64: 
            case UINT64: 
            case INT32: 
            case FIXED64: 
            case FIXED32: 
            case BOOL: 
            case STRING: 
            case BYTES: 
            case UINT32: 
            case SFIXED32: 
            case SFIXED64: 
            case SINT32: 
            case SINT64: {
                iw.printf("%s.%s(%d, %s);\n", out, this.makeStreamIOMethodName(fieldMetadata, true), fieldMetadata.getNumber(), this.unbox(v, fieldMetadata.getJavaType()));
                break;
            }
            case GROUP: {
                iw.println("{");
                iw.inc();
                String mdField = this.initMarshallerDelegateField(iw, fieldMetadata);
                iw.printf("%s.writeTag(%d, %s.impl.WireFormat.WIRETYPE_START_GROUP);\n", out, fieldMetadata.getNumber(), PROTOSTREAM_PACKAGE);
                iw.printf("writeMessage(%s, %s, %s);\n", mdField, out, v);
                iw.printf("%s.writeTag(%d, %s.impl.WireFormat.WIRETYPE_END_GROUP);\n", out, fieldMetadata.getNumber(), PROTOSTREAM_PACKAGE);
                iw.dec();
                iw.println("}");
                break;
            }
            case MESSAGE: {
                iw.println("{");
                iw.inc();
                String mdField = this.initMarshallerDelegateField(iw, fieldMetadata);
                iw.printf("writeNestedMessage(%s, %s, %d, %s);\n", mdField, out, fieldMetadata.getNumber(), v);
                iw.dec();
                iw.println("}");
                break;
            }
            case ENUM: {
                iw.println("{");
                iw.inc();
                String mdField = this.initMarshallerDelegateField(iw, fieldMetadata);
                iw.printf("%s.writeEnum(%d, %s.getMarshaller().encode(%s));\n", out, fieldMetadata.getNumber(), mdField, v);
                iw.dec();
                iw.println("}");
                break;
            }
            default: {
                throw new IllegalStateException("Unknown field type : " + fieldMetadata.getProtobufType());
            }
        }
    }

    private String initMarshallerDelegateField(IndentWriter iw, ProtoFieldMetadata fieldMetadata) {
        String fieldName = this.makeMarshallerDelegateFieldName(fieldMetadata);
        iw.printf("if (%s == null) %s = ", fieldName, fieldName);
        if (fieldMetadata.getJavaType().isEnum()) {
            iw.printf("(%s.impl.EnumMarshallerDelegate)", PROTOSTREAM_PACKAGE);
        }
        iw.printf("((%s.impl.SerializationContextImpl) $1.getSerializationContext()).getMarshallerDelegate(%s.class);\n", PROTOSTREAM_PACKAGE, fieldMetadata.getJavaTypeName());
        return fieldName;
    }

    private String makeStreamIOMethodName(ProtoFieldMetadata fieldMetadata, boolean isWrite) {
        String suffix = switch (fieldMetadata.getProtobufType()) {
            default -> throw new IncompatibleClassChangeError();
            case Type.DOUBLE -> "Double";
            case Type.FLOAT -> "Float";
            case Type.INT64 -> "Int64";
            case Type.UINT64 -> "UInt64";
            case Type.INT32 -> "Int32";
            case Type.FIXED64 -> "Fixed64";
            case Type.FIXED32 -> "Fixed32";
            case Type.BOOL -> "Bool";
            case Type.STRING -> "String";
            case Type.GROUP -> "Group";
            case Type.MESSAGE -> "Message";
            case Type.MAP -> "Map";
            case Type.BYTES -> {
                if (isWrite) {
                    yield "Bytes";
                }
                yield "ByteArray";
            }
            case Type.UINT32 -> "UInt32";
            case Type.ENUM -> "Enum";
            case Type.SFIXED32 -> "SFixed32";
            case Type.SFIXED64 -> "SFixed64";
            case Type.SINT32 -> "SInt32";
            case Type.SINT64 -> "SInt64";
        };
        return (isWrite ? "write" : "read") + suffix;
    }

    private String convert(String v, ProtoFieldMetadata fieldMetadata) {
        if (fieldMetadata.getJavaType() == this.typeFactory.fromClass(Character.class) || fieldMetadata.getJavaType() == this.typeFactory.fromClass(Character.TYPE)) {
            return "(char) " + v;
        }
        if (fieldMetadata.getJavaType() == this.typeFactory.fromClass(Short.class) || fieldMetadata.getJavaType() == this.typeFactory.fromClass(Short.TYPE)) {
            return "(short) " + v;
        }
        if (fieldMetadata.getJavaType() == this.typeFactory.fromClass(Byte.class) || fieldMetadata.getJavaType() == this.typeFactory.fromClass(Byte.TYPE)) {
            return "(byte) " + v;
        }
        return v;
    }

    private XClass box(XClass clazz) {
        if (clazz == this.typeFactory.fromClass(Float.TYPE)) {
            return this.typeFactory.fromClass(Float.class);
        }
        if (clazz == this.typeFactory.fromClass(Double.TYPE)) {
            return this.typeFactory.fromClass(Double.class);
        }
        if (clazz == this.typeFactory.fromClass(Boolean.TYPE)) {
            return this.typeFactory.fromClass(Boolean.class);
        }
        if (clazz == this.typeFactory.fromClass(Long.TYPE)) {
            return this.typeFactory.fromClass(Long.class);
        }
        if (clazz == this.typeFactory.fromClass(Integer.TYPE)) {
            return this.typeFactory.fromClass(Integer.class);
        }
        if (clazz == this.typeFactory.fromClass(Short.TYPE)) {
            return this.typeFactory.fromClass(Short.class);
        }
        if (clazz == this.typeFactory.fromClass(Byte.TYPE)) {
            return this.typeFactory.fromClass(Byte.class);
        }
        if (clazz == this.typeFactory.fromClass(Character.TYPE)) {
            return this.typeFactory.fromClass(Character.class);
        }
        return null;
    }

    private String box(String v, XClass clazz) {
        if (clazz != null) {
            if (clazz.isAssignableTo(Date.class)) {
                XConstructor ctor = clazz.getDeclaredConstructor(this.typeFactory.fromClass(Long.TYPE));
                if (ctor == null || !ctor.isPublic()) {
                    throw new ProtoSchemaBuilderException("Type " + clazz.getCanonicalName() + " is not a valid Date type because it does not have an accessible constructor that accepts a 'long' timestamp parameter");
                }
                return "new " + clazz.getName() + "(" + v + ")";
            }
            if (clazz.isAssignableTo(Instant.class)) {
                return "java.time.Instant.ofEpochMilli(" + v + ")";
            }
            if (clazz == this.typeFactory.fromClass(Float.class)) {
                return "java.lang.Float.valueOf(" + v + ")";
            }
            if (clazz == this.typeFactory.fromClass(Double.class)) {
                return "java.lang.Double.valueOf(" + v + ")";
            }
            if (clazz == this.typeFactory.fromClass(Boolean.class)) {
                return "java.lang.Boolean.valueOf(" + v + ")";
            }
            if (clazz == this.typeFactory.fromClass(Long.class)) {
                return "java.lang.Long.valueOf(" + v + ")";
            }
            if (clazz == this.typeFactory.fromClass(Integer.class)) {
                return "java.lang.Integer.valueOf(" + v + ")";
            }
            if (clazz == this.typeFactory.fromClass(Short.class)) {
                return "java.lang.Short.valueOf(" + v + ")";
            }
            if (clazz == this.typeFactory.fromClass(Byte.class)) {
                return "java.lang.Byte.valueOf(" + v + ")";
            }
            if (clazz == this.typeFactory.fromClass(Character.class)) {
                return "java.lang.Character.valueOf(" + v + ")";
            }
        }
        return v;
    }

    private String unbox(String v, XClass clazz) {
        if (clazz.isAssignableTo(Date.class)) {
            return v + ".getTime()";
        }
        if (clazz.isAssignableTo(Instant.class)) {
            return v + ".toEpochMilli()";
        }
        if (clazz == this.typeFactory.fromClass(Float.class)) {
            return v + ".floatValue()";
        }
        if (clazz == this.typeFactory.fromClass(Double.class)) {
            return v + ".doubleValue()";
        }
        if (clazz == this.typeFactory.fromClass(Boolean.class)) {
            return v + ".booleanValue()";
        }
        if (clazz == this.typeFactory.fromClass(Long.class)) {
            return v + ".longValue()";
        }
        if (clazz == this.typeFactory.fromClass(Integer.class)) {
            return v + ".intValue()";
        }
        if (clazz == this.typeFactory.fromClass(Short.class)) {
            return v + ".shortValue()";
        }
        if (clazz == this.typeFactory.fromClass(Byte.class)) {
            return v + ".byteValue()";
        }
        if (clazz == this.typeFactory.fromClass(Character.class)) {
            return v + ".charValue()";
        }
        return v;
    }

    private String createGetPropExpr(ProtoMessageTypeMetadata messageTypeMetadata, ProtoFieldMetadata fieldMetadata, String obj) {
        boolean isJUOptional;
        String thisArg;
        String thisTarget;
        if (messageTypeMetadata.isAdapter()) {
            thisTarget = ADAPTER_FIELD_NAME;
            thisArg = obj;
        } else {
            thisTarget = obj;
            thisArg = "";
        }
        StringBuilder readPropExpr = new StringBuilder();
        boolean bl = isJUOptional = fieldMetadata.getGetter() != null && fieldMetadata.getGetter().getReturnType() == this.typeFactory.fromClass(Optional.class);
        if (!(!isJUOptional && fieldMetadata.getProtobufType().getJavaType() != JavaType.MESSAGE && fieldMetadata.getProtobufType().getJavaType() != JavaType.ENUM || !fieldMetadata.isArray() && fieldMetadata.isRepeated())) {
            readPropExpr.append("(").append(fieldMetadata.getJavaTypeName());
            if (fieldMetadata.isArray()) {
                readPropExpr.append("[]");
            }
            readPropExpr.append(") ");
        }
        if (fieldMetadata.getField() != null) {
            readPropExpr.append(thisTarget).append('.').append(fieldMetadata.getField().getName());
        } else {
            if (isJUOptional) {
                readPropExpr.append('(');
            }
            readPropExpr.append(thisTarget).append('.').append(fieldMetadata.getGetter().getName()).append('(').append(thisArg).append(')');
            if (isJUOptional) {
                readPropExpr.append(".isPresent() ? ").append(thisTarget).append('.').append(fieldMetadata.getGetter().getName()).append('(').append(thisArg).append(").get() : null)");
            }
        }
        return readPropExpr.toString();
    }

    private String createSetPropExpr(ProtoMessageTypeMetadata messageTypeMetadata, ProtoFieldMetadata fieldMetadata, String obj, String value) {
        StringBuilder setPropExpr = new StringBuilder();
        setPropExpr.append(messageTypeMetadata.isAdapter() ? ADAPTER_FIELD_NAME : obj).append('.');
        if (fieldMetadata.getField() != null) {
            setPropExpr.append(fieldMetadata.getField().getName()).append(" = ").append(value);
        } else if (fieldMetadata.getSetter() != null) {
            setPropExpr.append(fieldMetadata.getSetter().getName()).append('(');
            if (messageTypeMetadata.isAdapter()) {
                setPropExpr.append(obj).append(", ");
            }
            setPropExpr.append(value).append(')');
        } else {
            setPropExpr.append("FIXME");
        }
        return setPropExpr.toString();
    }

    public abstract void generateMarshaller(SerializationContext var1, ProtoTypeMetadata var2) throws Exception;
}

