/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet.deployment;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jberet.creation.AbstractArtifactFactory;
import org.jberet.spi.ArtifactFactory;
import org.jboss.msc.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.context.RequestContext;
import org.jboss.weld.context.unbound.UnboundLiteral;
import org.jboss.weld.manager.BeanManagerImpl;
import org.wildfly.extension.batch.jberet._private.BatchLogger;
import org.wildfly.extension.batch.jberet.deployment.ContextHandle;
import org.wildfly.extension.batch.jberet.deployment.WildFlyArtifactFactory;

public class ArtifactFactoryService
extends AbstractArtifactFactory
implements Service,
WildFlyArtifactFactory {
    private final Consumer<ArtifactFactory> artifactFactoryConsumer;
    private final Supplier<BeanManager> beanManagerSupplier;
    private final Map<Object, Holder> contexts = Collections.synchronizedMap(new HashMap());
    private volatile BeanManager beanManager;

    public ArtifactFactoryService(Consumer<ArtifactFactory> artifactFactoryConsumer, Supplier<BeanManager> beanManagerSupplier) {
        this.artifactFactoryConsumer = artifactFactoryConsumer;
        this.beanManagerSupplier = beanManagerSupplier;
    }

    public void destroy(Object instance) {
        Holder holder = this.contexts.remove(instance);
        if (holder == null) {
            super.destroy(instance);
        } else if (holder.isDependent()) {
            holder.context.release();
        }
    }

    public Class<?> getArtifactClass(String ref, ClassLoader classLoader) {
        Bean<?> bean = ArtifactFactoryService.getBean(ref, (BeanManager)this.getBeanManager(), classLoader);
        return bean == null ? null : bean.getBeanClass();
    }

    public Object create(String ref, Class<?> cls, ClassLoader classLoader) throws Exception {
        BeanManagerImpl beanManager = this.getBeanManager();
        Bean<?> bean = ArtifactFactoryService.getBean(ref, (BeanManager)beanManager, classLoader);
        if (bean == null) {
            return null;
        }
        CreationalContext context = beanManager.createCreationalContext(bean);
        Object result = beanManager.getReference(bean, (Type)bean.getBeanClass(), context);
        this.contexts.put(result, new Holder(bean, context));
        return result;
    }

    public void start(StartContext context) throws StartException {
        this.beanManager = this.beanManagerSupplier != null ? this.beanManagerSupplier.get() : null;
        this.artifactFactoryConsumer.accept(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(StopContext context) {
        this.artifactFactoryConsumer.accept(null);
        this.beanManager = null;
        Map<Object, Holder> map = this.contexts;
        synchronized (map) {
            for (Holder holder : this.contexts.values()) {
                if (!holder.isDependent()) continue;
                holder.context.release();
            }
            this.contexts.clear();
        }
    }

    @Override
    public ContextHandle createContextHandle() {
        BeanManagerImpl beanManager = this.getBeanManager();
        return () -> {
            if (beanManager == null || beanManager.isContextActive(RequestScoped.class)) {
                return () -> {};
            }
            RequestContext requestContext = (RequestContext)beanManager.instance().select(RequestContext.class, new Annotation[]{UnboundLiteral.INSTANCE}).get();
            requestContext.activate();
            return () -> {
                requestContext.invalidate();
                requestContext.deactivate();
            };
        };
    }

    private BeanManagerImpl getBeanManager() {
        BeanManager beanManager = this.beanManager;
        return beanManager == null ? null : BeanManagerProxy.unwrap((BeanManager)beanManager);
    }

    private static Bean<?> getBean(String ref, BeanManager beanManager, ClassLoader classLoader) {
        Bean result = beanManager == null ? null : AbstractArtifactFactory.findBean((String)ref, (BeanManager)beanManager, (ClassLoader)classLoader);
        BatchLogger.LOGGER.tracef("Found bean: %s for ref: %s", result, ref);
        return result;
    }

    private static class Holder {
        final Bean<?> bean;
        final CreationalContext<?> context;

        private Holder(Bean<?> bean, CreationalContext<?> context) {
            this.bean = bean;
            this.context = context;
        }

        boolean isDependent() {
            return Dependent.class.equals((Object)this.bean.getScope());
        }
    }
}

