/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.parsing;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.xml.XMLCardinality;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.dmr.ValueExpression;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.projectodd.vdx.core.ErrorType;
import org.projectodd.vdx.core.ValidationError;
import org.projectodd.vdx.core.XMLStreamValidationException;

public final class ParseUtils {
    private ParseUtils() {
    }

    public static Element nextElement(XMLExtendedStreamReader reader) throws XMLStreamException {
        if (reader.nextTag() == 2) {
            return null;
        }
        return Element.forName(reader.getLocalName());
    }

    public static Element nextElement(XMLExtendedStreamReader reader, String expectedNamespaceUri) throws XMLStreamException {
        Element element = ParseUtils.nextElement(reader);
        if (element == null) {
            return null;
        }
        if (element != Element.UNKNOWN && expectedNamespaceUri.equals(reader.getNamespaceURI())) {
            return element;
        }
        throw ParseUtils.unexpectedElement(reader);
    }

    public static XMLStreamException unexpectedElement(XMLExtendedStreamReader reader) {
        XMLStreamException ex = ControllerLogger.ROOT_LOGGER.unexpectedElement(reader.getName(), reader.getLocation());
        return new XMLStreamValidationException(ex.getMessage(), ValidationError.from((XMLStreamException)ex, (ErrorType)ErrorType.UNEXPECTED_ELEMENT).element(reader.getName()), (Throwable)ex);
    }

    public static XMLStreamException unexpectedElement(XMLExtendedStreamReader reader, Set<?> possible) {
        XMLStreamException ex = ControllerLogger.ROOT_LOGGER.unexpectedElement(reader.getName(), ParseUtils.asStringList(possible), reader.getLocation());
        return new XMLStreamValidationException(ex.getMessage(), ValidationError.from((XMLStreamException)ex, (ErrorType)ErrorType.UNEXPECTED_ELEMENT).element(reader.getName()).alternatives(possible.stream().map(Object::toString).collect(Collectors.toSet())), (Throwable)ex);
    }

    public static XMLStreamException unsupportedNamespace(XMLExtendedStreamReader reader) {
        XMLStreamException ex = ControllerLogger.ROOT_LOGGER.unsupportedNamespace(reader.getName(), reader.getLocation());
        return new XMLStreamValidationException(ex.getMessage(), ValidationError.from((XMLStreamException)ex, (ErrorType)ErrorType.UNSUPPORTED_ELEMENT).element(reader.getName()), (Throwable)ex);
    }

    public static XMLStreamException unexpectedEndElement(XMLExtendedStreamReader reader) {
        return ControllerLogger.ROOT_LOGGER.unexpectedEndElement(reader.getName(), reader.getLocation());
    }

    public static XMLStreamException unexpectedAttribute(XMLExtendedStreamReader reader, int index) {
        XMLStreamException ex = ControllerLogger.ROOT_LOGGER.unexpectedAttribute(reader.getAttributeName(index), reader.getLocation());
        return new XMLStreamValidationException(ex.getMessage(), ValidationError.from((XMLStreamException)ex, (ErrorType)ErrorType.UNEXPECTED_ATTRIBUTE).element(reader.getName()).attribute(reader.getAttributeName(index)), (Throwable)ex);
    }

    public static XMLStreamException unexpectedAttribute(XMLExtendedStreamReader reader, int index, Set<?> possibleAttributes) {
        XMLStreamException ex = ControllerLogger.ROOT_LOGGER.unexpectedAttribute(reader.getAttributeName(index), ParseUtils.asStringList(possibleAttributes), reader.getLocation());
        return new XMLStreamValidationException(ex.getMessage(), ValidationError.from((XMLStreamException)ex, (ErrorType)ErrorType.UNEXPECTED_ATTRIBUTE).element(reader.getName()).attribute(reader.getAttributeName(index)).alternatives(possibleAttributes.stream().map(Object::toString).collect(Collectors.toSet())), (Throwable)ex);
    }

    private static StringBuilder asStringList(Set<?> attributes) {
        StringBuilder b = new StringBuilder();
        Iterator<?> iterator = attributes.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            b.append(o.toString());
            if (!iterator.hasNext()) continue;
            b.append(", ");
        }
        return b;
    }

    public static XMLStreamException invalidAttributeValue(XMLExtendedStreamReader reader, int index) {
        XMLStreamException ex = ControllerLogger.ROOT_LOGGER.invalidAttributeValue(reader.getAttributeValue(index), reader.getAttributeName(index), reader.getLocation());
        return new XMLStreamValidationException(ex.getMessage(), ValidationError.from((XMLStreamException)ex, (ErrorType)ErrorType.INVALID_ATTRIBUTE_VALUE).element(reader.getName()).attribute(reader.getAttributeName(index)).attributeValue(reader.getAttributeValue(index)), (Throwable)ex);
    }

    private static XMLStreamException wrapMissingRequiredAttribute(XMLStreamException ex, XMLStreamReader reader, Set<String> required) {
        return new XMLStreamValidationException(ex.getMessage(), ValidationError.from((XMLStreamException)ex, (ErrorType)ErrorType.REQUIRED_ATTRIBUTE_MISSING).element(reader.getName()).alternatives(required), (Throwable)ex);
    }

    public static XMLStreamException missingRequired(XMLExtendedStreamReader reader, Set<?> required) {
        HashSet<String> set = new HashSet<String>();
        for (Object o : required) {
            String toString = o.toString();
            set.add(toString);
        }
        return ParseUtils.wrapMissingRequiredAttribute(ControllerLogger.ROOT_LOGGER.missingRequiredAttributes(ParseUtils.asStringList(required), reader.getLocation()), (XMLStreamReader)reader, set);
    }

    public static XMLStreamException missingRequired(XMLExtendedStreamReader reader, String ... required) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < required.length; ++i) {
            String o = required[i];
            b.append(o);
            if (required.length <= i + 1) continue;
            b.append(", ");
        }
        return ParseUtils.wrapMissingRequiredAttribute(ControllerLogger.ROOT_LOGGER.missingRequiredAttributes(b, reader.getLocation()), (XMLStreamReader)reader, new HashSet<String>(Arrays.asList(required)));
    }

    public static XMLStreamException missingRequiredElement(XMLExtendedStreamReader reader, Set<?> required) {
        StringBuilder b = new StringBuilder();
        Iterator<?> iterator = required.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            b.append(o.toString());
            if (!iterator.hasNext()) continue;
            b.append(", ");
        }
        XMLStreamException ex = ControllerLogger.ROOT_LOGGER.missingRequiredElements(b, reader.getLocation());
        HashSet<String> set = new HashSet<String>();
        for (Object o : required) {
            String toString = o.toString();
            set.add(toString);
        }
        return new XMLStreamValidationException(ex.getMessage(), ValidationError.from((XMLStreamException)ex, (ErrorType)ErrorType.REQUIRED_ELEMENTS_MISSING).element(reader.getName()).alternatives(set), (Throwable)ex);
    }

    public static XMLStreamException missingOneOf(XMLExtendedStreamReader reader, Set<?> required) {
        StringBuilder b = new StringBuilder();
        Iterator<?> iterator = required.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            b.append(o.toString());
            if (!iterator.hasNext()) continue;
            b.append(", ");
        }
        XMLStreamException ex = ControllerLogger.ROOT_LOGGER.missingOneOf(b, reader.getLocation());
        HashSet<String> set = new HashSet<String>();
        for (Object o : required) {
            String toString = o.toString();
            set.add(toString);
        }
        return new XMLStreamValidationException(ex.getMessage(), ValidationError.from((XMLStreamException)ex, (ErrorType)ErrorType.REQUIRED_ELEMENT_MISSING).element(reader.getName()).alternatives(set), (Throwable)ex);
    }

    public static void requireNoAttributes(XMLExtendedStreamReader reader) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute(reader, 0);
        }
    }

    public static void requireNoContent(XMLExtendedStreamReader reader) throws XMLStreamException {
        if (reader.hasNext() && reader.nextTag() != 2) {
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    public static void requireNamespace(XMLExtendedStreamReader reader, String requiredNs) throws XMLStreamException {
        String actualNs = reader.getNamespaceURI();
        if (!actualNs.equals(requiredNs)) {
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    public static XMLStreamException duplicateAttribute(XMLExtendedStreamReader reader, String name) {
        XMLStreamException ex = ControllerLogger.ROOT_LOGGER.duplicateAttribute(name, reader.getLocation());
        return new XMLStreamValidationException(ex.getMessage(), ValidationError.from((XMLStreamException)ex, (ErrorType)ErrorType.DUPLICATE_ATTRIBUTE).element(reader.getName()).attribute(new QName(name)), (Throwable)ex);
    }

    public static XMLStreamException duplicateNamedElement(XMLExtendedStreamReader reader, String name) {
        XMLStreamException ex = ControllerLogger.ROOT_LOGGER.duplicateNamedElement(name, reader.getLocation());
        return new XMLStreamValidationException(ex.getMessage(), ValidationError.from((XMLStreamException)ex, (ErrorType)ErrorType.DUPLICATE_ELEMENT).element(reader.getName()).attribute(QName.valueOf("name")).attributeValue(name), (Throwable)ex);
    }

    public static boolean readBooleanAttributeElement(XMLExtendedStreamReader reader, String attributeName) throws XMLStreamException {
        ParseUtils.requireSingleAttribute(reader, attributeName);
        boolean value = Boolean.parseBoolean(reader.getAttributeValue(0));
        ParseUtils.requireNoContent(reader);
        return value;
    }

    public static String readStringAttributeElement(XMLExtendedStreamReader reader, String attributeName) throws XMLStreamException {
        ParseUtils.requireSingleAttribute(reader, attributeName);
        String value = reader.getAttributeValue(0);
        ParseUtils.requireNoContent(reader);
        return value;
    }

    public static <T> List<T> readListAttributeElement(XMLExtendedStreamReader reader, String attributeName, Class<T> type) throws XMLStreamException {
        ParseUtils.requireSingleAttribute(reader, attributeName);
        List value = reader.getListAttributeValue(0, type);
        ParseUtils.requireNoContent(reader);
        return value;
    }

    public static Property readProperty(XMLExtendedStreamReader reader) throws XMLStreamException {
        return ParseUtils.readProperty(reader, false);
    }

    public static Property readProperty(XMLExtendedStreamReader reader, boolean supportsExpressions) throws XMLStreamException {
        int cnt = reader.getAttributeCount();
        String name = null;
        ModelNode value = null;
        for (int i = 0; i < cnt; ++i) {
            String uri = reader.getAttributeNamespace(i);
            if (uri != null && !uri.equals("")) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            String localName = reader.getAttributeLocalName(i);
            if (localName.equals("name")) {
                name = reader.getAttributeValue(i);
                continue;
            }
            if (localName.equals("value")) {
                if (supportsExpressions) {
                    value = ParseUtils.parsePossibleExpression(reader.getAttributeValue(i));
                    continue;
                }
                value = new ModelNode(reader.getAttributeValue(i));
                continue;
            }
            throw ParseUtils.unexpectedAttribute(reader, i);
        }
        if (name == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton("name"));
        }
        if (reader.next() != 2) {
            throw ParseUtils.unexpectedElement(reader);
        }
        return new Property(name, new ModelNode().set(value == null ? new ModelNode() : value));
    }

    public static <T> T[] readArrayAttributeElement(XMLExtendedStreamReader reader, String attributeName, Class<T> type) throws XMLStreamException {
        List<Object> list = ParseUtils.readListAttributeElement(reader, attributeName, type);
        return list.toArray((Object[])Array.newInstance(type, list.size()));
    }

    public static void requireSingleAttribute(XMLExtendedStreamReader reader, String attributeName) throws XMLStreamException {
        int count = reader.getAttributeCount();
        if (count == 0) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(attributeName));
        }
        ParseUtils.requireNoNamespaceAttribute(reader, 0);
        if (!attributeName.equals(reader.getAttributeLocalName(0))) {
            throw ParseUtils.unexpectedAttribute(reader, 0);
        }
        if (count > 1) {
            throw ParseUtils.unexpectedAttribute(reader, 1);
        }
    }

    public static String[] requireAttributes(XMLExtendedStreamReader reader, String ... attributeNames) throws XMLStreamException {
        int length = attributeNames.length;
        String[] result = new String[length];
        for (int i = 0; i < length; ++i) {
            String name = attributeNames[i];
            String value = reader.getAttributeValue(null, name);
            if (value == null) {
                throw ParseUtils.missingRequired(reader, Collections.singleton(name));
            }
            result[i] = value;
        }
        return result;
    }

    public static boolean isXmlNamespaceAttribute(XMLExtendedStreamReader reader, int index) {
        String namespace = reader.getAttributeNamespace(index);
        return "http://www.w3.org/2001/XMLSchema-instance".equals(namespace);
    }

    public static boolean isNoNamespaceAttribute(XMLExtendedStreamReader reader, int index) {
        String namespace = reader.getAttributeNamespace(index);
        return namespace == null || "".equals(namespace);
    }

    public static void requireNoNamespaceAttribute(XMLExtendedStreamReader reader, int index) throws XMLStreamException {
        if (!ParseUtils.isNoNamespaceAttribute(reader, index)) {
            throw ParseUtils.unexpectedAttribute(reader, index);
        }
    }

    public static ModelNode parseAttributeValue(String value, boolean isExpressionAllowed, ModelType attributeType) {
        ModelNode node;
        String trimmed;
        String string = trimmed = value == null ? null : value.trim();
        if (trimmed != null) {
            node = isExpressionAllowed && ParseUtils.isExpression(value) ? (attributeType == ModelType.STRING || attributeType == ModelType.PROPERTY ? new ModelNode(new ValueExpression(value)) : new ModelNode(new ValueExpression(trimmed))) : (attributeType == ModelType.STRING || attributeType == ModelType.PROPERTY ? new ModelNode().set(value) : new ModelNode().set(trimmed));
            if (node.getType() != ModelType.EXPRESSION) {
                try {
                    switch (attributeType) {
                        case BIG_DECIMAL: {
                            node.set(node.asBigDecimal());
                            break;
                        }
                        case BIG_INTEGER: {
                            node.set(node.asBigInteger());
                            break;
                        }
                        case BOOLEAN: {
                            node.set(node.asBoolean());
                            break;
                        }
                        case BYTES: {
                            node.set(node.asBytes());
                            break;
                        }
                        case DOUBLE: {
                            node.set(node.asDouble());
                            break;
                        }
                        case INT: {
                            node.set(node.asInt());
                            break;
                        }
                        case LONG: {
                            node.set(node.asLong());
                        }
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        } else {
            node = new ModelNode();
        }
        return node;
    }

    public static boolean isExpression(String value) {
        int openIdx = value.indexOf("${");
        return openIdx > -1 && value.lastIndexOf(125) > openIdx;
    }

    public static ModelNode parsePossibleExpression(String value) {
        ModelNode result = new ModelNode();
        if (ParseUtils.isExpression(value)) {
            result.set(new ValueExpression(value));
        } else {
            result.set(value);
        }
        return result;
    }

    public static XMLStreamException unsupportedElement(XMLExtendedStreamReader reader, String supportedElement) {
        XMLStreamException ex = ControllerLogger.ROOT_LOGGER.unsupportedElement(new QName(reader.getNamespaceURI(), reader.getLocalName(), reader.getPrefix()), reader.getLocation(), supportedElement);
        return new XMLStreamValidationException(ex.getMessage(), ValidationError.from((XMLStreamException)ex, (ErrorType)ErrorType.UNSUPPORTED_ELEMENT).element(reader.getName()).alternatives(Set.of(supportedElement)), (Throwable)ex);
    }

    public static XMLStreamException minOccursNotReached(XMLExtendedStreamReader reader, Collection<QName> names, XMLCardinality cardinality) {
        XMLStreamException e = new XMLStreamException(ControllerLogger.ROOT_LOGGER.minOccursNotReached(names, cardinality.getMinOccurs()), reader.getLocation());
        return ParseUtils.createValidationException(e, ErrorType.REQUIRED_ELEMENT_MISSING, names);
    }

    public static XMLStreamException maxOccursExceeded(XMLExtendedStreamReader reader, Collection<QName> names, XMLCardinality cardinality) {
        XMLStreamException e = new XMLStreamException(ControllerLogger.ROOT_LOGGER.maxOccursExceeded(names, cardinality.getMaxOccurs().orElse(Integer.MAX_VALUE)), reader.getLocation());
        return ParseUtils.createValidationException(e, ErrorType.DUPLICATE_ELEMENT, names);
    }

    private static XMLStreamValidationException createValidationException(XMLStreamException e, ErrorType type, Collection<QName> elements) {
        ValidationError error = ValidationError.from((XMLStreamException)e, (ErrorType)type);
        Iterator<QName> names = elements.iterator();
        if (names.hasNext()) {
            error.element(names.next());
        }
        if (names.hasNext()) {
            TreeSet<String> alternatives = new TreeSet<String>();
            do {
                alternatives.add(names.next().getLocalPart());
            } while (names.hasNext());
            error.alternatives(alternatives);
        }
        return new XMLStreamValidationException(e.getMessage(), error, (Throwable)e);
    }
}

