/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.persistence;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.persistence.AbstractConfigurationPersister;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ExposedByteArrayOutputStream;
import org.jboss.dmr.ModelNode;
import org.xnio.IoUtils;

class FilePersistenceUtils {
    static final int[] ILLEGAL_CHARS = new int[]{34, 60, 62, 124, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 58, 42, 63, 92, 47};

    FilePersistenceUtils() {
    }

    static String sanitizeFileName(String name) {
        if (name == null || name.isEmpty()) {
            return "";
        }
        StringBuilder cleanName = new StringBuilder();
        int len = name.codePointCount(0, name.length());
        for (int i = 0; i < len; ++i) {
            int c = name.codePointAt(i);
            if (Arrays.binarySearch(ILLEGAL_CHARS, c) >= 0) continue;
            cleanName.appendCodePoint(c);
        }
        try {
            return new File(cleanName.toString()).getCanonicalFile().getName();
        }
        catch (IOException ex) {
            return "";
        }
    }

    static File createTempFile(File fileName) {
        return FilePersistenceUtils.createTempFile(fileName.getParentFile(), fileName.getName());
    }

    static File createTempFile(File fileFolder, String fileName) {
        return new File(fileFolder, fileName + ".tmp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ExposedByteArrayOutputStream marshalXml(AbstractConfigurationPersister persister, ModelNode model) throws ConfigurationPersistenceException {
        ExposedByteArrayOutputStream marshalled = new ExposedByteArrayOutputStream(8192);
        try {
            try {
                BufferedOutputStream output = new BufferedOutputStream(marshalled);
                persister.marshallAsXml(model, output);
                output.close();
                marshalled.close();
            }
            finally {
                IoUtils.safeClose((Closeable)marshalled);
            }
        }
        catch (Exception e) {
            throw ControllerLogger.ROOT_LOGGER.failedToMarshalConfiguration(e);
        }
        return marshalled;
    }

    static void copyFile(File file, File backup) throws IOException {
        Files.copy(file.toPath(), backup.toPath(), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
    }

    static void moveTempFileToMain(File tempFileName, File fileName) throws ConfigurationPersistenceException {
        try {
            Files.move(tempFileName.toPath(), fileName.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            throw ControllerLogger.ROOT_LOGGER.failedToRenameTempFile(e, tempFileName, fileName);
        }
    }

    static void deleteFile(File file) {
        if (file.exists() && !file.delete() && file.exists()) {
            file.deleteOnExit();
            throw new IllegalStateException(ControllerLogger.ROOT_LOGGER.couldNotDeleteFile(file));
        }
    }

    static File writeToTempFile(InputStream is, File tempFileName, File fileName) throws IOException {
        Path targetPath = tempFileName.toPath();
        FilePersistenceUtils.deleteFile(tempFileName);
        try {
            FilePersistenceUtils.createTempFileWithAttributes(targetPath, fileName);
        }
        catch (IOException ioex) {
            ControllerLogger.ROOT_LOGGER.error(ioex.getLocalizedMessage(), ioex);
        }
        Files.copy(is, targetPath, StandardCopyOption.REPLACE_EXISTING);
        return tempFileName;
    }

    static Path createTempFileWithAttributes(Path tempFilePath, File fileName) throws IOException {
        Path exisitingFilePath = fileName.toPath();
        ArrayList<FileAttribute<Collection<Object>>> attributes = new ArrayList<FileAttribute<Collection<Object>>>(2);
        attributes.addAll(FilePersistenceUtils.getPosixAttributes(exisitingFilePath));
        attributes.addAll(FilePersistenceUtils.getAclAttributes(exisitingFilePath));
        if (!attributes.isEmpty()) {
            try {
                return Files.createFile(tempFilePath, attributes.toArray(new FileAttribute[attributes.size()]));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return Files.createFile(tempFilePath, new FileAttribute[0]);
    }

    private static List<FileAttribute<Set<PosixFilePermission>>> getPosixAttributes(Path file) throws IOException {
        PosixFileAttributeView posixView;
        if (Files.exists(file, new LinkOption[0]) && FilePersistenceUtils.supportsFileOwnerAttributeView(file, PosixFileAttributeView.class) && (posixView = Files.getFileAttributeView(file, PosixFileAttributeView.class, new LinkOption[0])) != null) {
            return Collections.singletonList(PosixFilePermissions.asFileAttribute(posixView.readAttributes().permissions()));
        }
        return Collections.emptyList();
    }

    private static List<FileAttribute<List<AclEntry>>> getAclAttributes(Path file) throws IOException {
        AclFileAttributeView aclView;
        if (Files.exists(file, new LinkOption[0]) && FilePersistenceUtils.supportsFileOwnerAttributeView(file, AclFileAttributeView.class) && (aclView = Files.getFileAttributeView(file, AclFileAttributeView.class, new LinkOption[0])) != null) {
            final List<AclEntry> entries = aclView.getAcl();
            return Collections.singletonList(new FileAttribute<List<AclEntry>>(){

                @Override
                public List<AclEntry> value() {
                    return entries;
                }

                @Override
                public String name() {
                    return "acl:acl";
                }
            });
        }
        return Collections.emptyList();
    }

    private static boolean supportsFileOwnerAttributeView(Path path, Class<? extends FileOwnerAttributeView> view) {
        FileStore store;
        try {
            store = Files.getFileStore(path);
        }
        catch (IOException e) {
            return false;
        }
        return store.supportsFileAttributeView(view);
    }

    static boolean isParentFolderWritable(File file) {
        if (!file.exists() || file.getParentFile() == null) {
            return false;
        }
        return Files.isWritable(file.getParentFile().toPath());
    }

    static {
        Arrays.sort(ILLEGAL_CHARS);
    }
}

