/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.persistence.xml;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.FeatureRegistry;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.xml.AttributeDefinitionXMLConfiguration;
import org.jboss.as.controller.persistence.xml.MappedIterable;
import org.jboss.as.controller.xml.QNameResolver;
import org.jboss.as.controller.xml.XMLContainer;
import org.jboss.as.controller.xml.XMLContent;
import org.jboss.as.controller.xml.XMLContentWriter;
import org.jboss.as.controller.xml.XMLElementReader;
import org.jboss.as.version.Stability;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public interface ResourceXMLContainer
extends XMLContainer<Map.Entry<PathAddress, Map<PathAddress, ModelNode>>, ModelNode> {
    public static final XMLElementReader<ModelNode> EMPTY_READER = new XMLElementReader<ModelNode>(){

        public void readElement(XMLExtendedStreamReader reader, ModelNode value) throws XMLStreamException {
            ParseUtils.requireNoAttributes(reader);
        }
    };
    public static final XMLContentWriter<ModelNode> EMPTY_WRITER = XMLContentWriter.empty();

    public static class ResourceAttributesXMLContentWriter
    implements XMLContentWriter<ModelNode>,
    Predicate<AttributeDefinition> {
        private final Collection<AttributeDefinition> attributes;
        private final AttributeDefinitionXMLConfiguration configuration;

        ResourceAttributesXMLContentWriter(Collection<AttributeDefinition> attributes, AttributeDefinitionXMLConfiguration configuration) {
            this.attributes = attributes;
            this.configuration = configuration;
        }

        @Override
        public boolean test(AttributeDefinition attribute) {
            return !this.configuration.getMarshaller(attribute).isMarshallableAsElement();
        }

        public void writeContent(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
            for (AttributeDefinition attribute : this.attributes) {
                if (!this.test(attribute)) continue;
                this.configuration.getMarshaller(attribute).marshallAsAttribute(attribute, model, true, (XMLStreamWriter)writer);
            }
        }

        @Override
        public boolean isEmpty(ModelNode model) {
            return this.attributes.stream().filter(this).map(AttributeDefinition::getName).noneMatch(arg_0 -> ((ModelNode)model).hasDefined(arg_0));
        }
    }

    public static class ResourceAttributesXMLContentReader
    implements XMLElementReader<ModelNode> {
        private final Set<QName> requiredAttributes;
        private final Map<QName, AttributeDefinition> attributes;
        private final AttributeDefinitionXMLConfiguration configuration;

        ResourceAttributesXMLContentReader(Collection<AttributeDefinition> attributes, AttributeDefinitionXMLConfiguration configuration) {
            this.attributes = attributes.isEmpty() ? Map.of() : new TreeMap(QNameResolver.COMPARATOR);
            this.requiredAttributes = attributes.isEmpty() ? Set.of() : new TreeSet<QName>(QNameResolver.COMPARATOR);
            this.configuration = configuration;
            for (AttributeDefinition attribute : attributes) {
                if (configuration.getParser(attribute).isParseAsElement()) continue;
                QName name = configuration.getName(attribute);
                this.attributes.put(name, attribute);
                if (!attribute.isRequired()) continue;
                this.requiredAttributes.add(name);
            }
        }

        public void readElement(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
            TreeSet<QName> distinctAttributes = new TreeSet<QName>(QNameResolver.COMPARATOR);
            for (int i = 0; i < reader.getAttributeCount(); ++i) {
                QName name = reader.getAttributeName(i);
                if (name.getNamespaceURI().equals("") && !reader.getName().getNamespaceURI().equals("")) {
                    name = new QName(reader.getName().getNamespaceURI(), name.getLocalPart());
                }
                if (!distinctAttributes.add(name)) {
                    throw ParseUtils.duplicateAttribute(reader, name.getLocalPart());
                }
                AttributeDefinition attribute = this.attributes.get(name);
                if (attribute == null) {
                    throw ParseUtils.unexpectedAttribute(reader, i, this.attributes.keySet());
                }
                this.configuration.getParser(attribute).parseAndSetParameter(attribute, reader.getAttributeValue(i), operation, (XMLStreamReader)reader);
            }
            if (!distinctAttributes.containsAll(this.requiredAttributes)) {
                TreeSet<QName> required = new TreeSet<QName>(QNameResolver.COMPARATOR);
                required.addAll(this.requiredAttributes);
                required.removeAll(distinctAttributes);
                throw ParseUtils.missingRequired(reader, required);
            }
        }
    }

    public static class ResourceXMLContainerReader
    implements XMLElementReader<Map.Entry<PathAddress, Map<PathAddress, ModelNode>>> {
        private final XMLElementReader<ModelNode> attributesReader;
        private final XMLContent<Map.Entry<PathAddress, Map<PathAddress, ModelNode>>, ModelNode> content;

        ResourceXMLContainerReader(XMLElementReader<ModelNode> attributesReader, XMLContent<Map.Entry<PathAddress, Map<PathAddress, ModelNode>>, ModelNode> content) {
            this.attributesReader = attributesReader;
            this.content = content;
        }

        public void readElement(XMLExtendedStreamReader reader, Map.Entry<PathAddress, Map<PathAddress, ModelNode>> context) throws XMLStreamException {
            PathAddress operationKey = context.getKey();
            Map<PathAddress, ModelNode> operations = context.getValue();
            ModelNode operation = operations.get(operationKey);
            this.attributesReader.readElement(reader, operation);
            this.content.readContent(reader, context);
        }
    }

    public static abstract class AbstractBuilder<T extends ResourceXMLContainer, B extends Builder<T, B>>
    extends XMLContainer.AbstractBuilder<Map.Entry<PathAddress, Map<PathAddress, ModelNode>>, ModelNode, T, B>
    implements Builder<T, B>,
    FeatureRegistry,
    QNameResolver {
        private static final AttributeParser IGNORED_PARSER = new AttributeParser(){

            @Override
            public void parseAndSetParameter(AttributeDefinition attribute, String value, ModelNode operation, XMLStreamReader reader) throws XMLStreamException {
                ControllerLogger.ROOT_LOGGER.attributeIgnored(reader.getName(), new QName(reader.getNamespaceURI(), attribute.getXmlName()));
            }
        };
        private static final AttributeMarshaller NO_OP_MARSHALLER = new AttributeMarshaller(){

            @Override
            public void marshallAsAttribute(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            }
        };
        private final FeatureRegistry registry;
        private final QNameResolver resolver;
        private final List<AttributeDefinition> attributes = new LinkedList<AttributeDefinition>();
        private volatile AttributeDefinitionXMLConfiguration configuration;

        static SimpleAttributeDefinitionBuilder ignoredAttributeDefinitionBuilder(String localName) {
            return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(localName, ModelType.STRING).setRequired(false)).setAttributeParser(IGNORED_PARSER)).setAttributeMarshaller(NO_OP_MARSHALLER);
        }

        protected AbstractBuilder(FeatureRegistry registry, QNameResolver resolver, AttributeDefinitionXMLConfiguration configuration) {
            this.registry = registry;
            this.resolver = resolver;
            this.configuration = configuration;
        }

        @Override
        public QName resolve(String localName) {
            return this.resolver.resolve(localName);
        }

        @Override
        public Stability getStability() {
            return this.registry.getStability();
        }

        @Override
        public B addAttributes(Iterable<? extends AttributeDefinition> attributes) {
            for (AttributeDefinition attributeDefinition : attributes) {
                this.addAttribute(attributeDefinition);
            }
            return (B)((Builder)this.builder());
        }

        @Override
        public B addAttribute(AttributeDefinition attribute) {
            if (this.enables(attribute)) {
                this.attributes.add(attribute);
            }
            return (B)((Builder)this.builder());
        }

        @Override
        public B ignoreAttributeLocalNames(Set<String> localNames) {
            return this.ignoreAttributes(localNames.stream());
        }

        @Override
        public B ignoreAttributeNames(Set<QName> names) {
            return this.ignoreAttributes(names.stream().map(QName::getLocalPart));
        }

        private B ignoreAttributes(Stream<String> localNames) {
            localNames.map(AbstractBuilder::ignoredAttributeDefinitionBuilder).map(SimpleAttributeDefinitionBuilder::build).forEach(this::addAttribute);
            return (B)((Builder)this.builder());
        }

        @Override
        public B withLocalNames(final Map<AttributeDefinition, String> localNames) {
            this.configuration = new AttributeDefinitionXMLConfiguration.DefaultAttributeDefinitionXMLConfiguration(this.configuration){

                @Override
                public QName getName(AttributeDefinition attribute) {
                    String localName = (String)localNames.get(attribute);
                    return localName != null ? this.resolve(localName) : super.getName(attribute);
                }
            };
            return (B)((Builder)this.builder());
        }

        @Override
        public B withNames(final Map<AttributeDefinition, QName> names) {
            this.configuration = new AttributeDefinitionXMLConfiguration.DefaultAttributeDefinitionXMLConfiguration(this.configuration){

                @Override
                public QName getName(AttributeDefinition attribute) {
                    QName name = (QName)names.get(attribute);
                    return name != null ? name : super.getName(attribute);
                }
            };
            return (B)((Builder)this.builder());
        }

        @Override
        public B withParsers(final Map<AttributeDefinition, AttributeParser> parsers) {
            this.configuration = new AttributeDefinitionXMLConfiguration.DefaultAttributeDefinitionXMLConfiguration(this.configuration){

                @Override
                public AttributeParser getParser(AttributeDefinition attribute) {
                    AttributeParser parser = (AttributeParser)parsers.get(attribute);
                    return parser != null ? parser : super.getParser(attribute);
                }
            };
            return (B)((Builder)this.builder());
        }

        @Override
        public B withMarshallers(final Map<AttributeDefinition, AttributeMarshaller> marshallers) {
            this.configuration = new AttributeDefinitionXMLConfiguration.DefaultAttributeDefinitionXMLConfiguration(this.configuration){

                @Override
                public AttributeMarshaller getMarshaller(AttributeDefinition attribute) {
                    AttributeMarshaller marshaller = (AttributeMarshaller)marshallers.get(attribute);
                    return marshaller != null ? marshaller : super.getMarshaller(attribute);
                }
            };
            return (B)((Builder)this.builder());
        }

        Collection<AttributeDefinition> getAttributes() {
            return this.attributes;
        }

        AttributeDefinitionXMLConfiguration getConfiguration() {
            return this.configuration;
        }
    }

    public static interface Builder<T extends ResourceXMLContainer, B extends Builder<T, B>>
    extends XMLContainer.Builder<Map.Entry<PathAddress, Map<PathAddress, ModelNode>>, ModelNode, T, B>,
    AttributeDefinitionXMLConfiguration.Configurator<B> {
        public B addAttribute(AttributeDefinition var1);

        public B addAttributes(Iterable<? extends AttributeDefinition> var1);

        default public B provideAttributes(Iterable<? extends Supplier<AttributeDefinition>> providers) {
            return this.addAttributes(new MappedIterable<Supplier, AttributeDefinition>(providers, Supplier::get));
        }

        public B ignoreAttributeLocalNames(Set<String> var1);

        public B ignoreAttributeNames(Set<QName> var1);
    }
}

