/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.security.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.impl.aesh.cmd.security.model.AuthFactorySpec;
import org.jboss.as.cli.impl.aesh.cmd.security.model.AuthMechanism;
import org.jboss.as.cli.impl.aesh.cmd.security.model.SecurityDomain;
import org.wildfly.common.Assert;

public class AuthFactory {
    private final String name;
    private final SecurityDomain domain;
    private final List<AuthMechanism> mechanisms = new ArrayList<AuthMechanism>();
    private final AuthFactorySpec spec;

    public AuthFactory(String name, SecurityDomain domain, AuthFactorySpec spec) {
        this.name = (String)Assert.checkNotNullParamWithNullPointerException((String)"name", (Object)name);
        this.domain = (SecurityDomain)Assert.checkNotNullParamWithNullPointerException((String)"domain", (Object)domain);
        this.spec = (AuthFactorySpec)Assert.checkNotNullParamWithNullPointerException((String)"spec", (Object)spec);
    }

    public AuthFactorySpec getSpec() {
        return this.spec;
    }

    public String getName() {
        return this.name;
    }

    public SecurityDomain getSecurityDomain() {
        return this.domain;
    }

    public void addMechanism(AuthMechanism mec) {
        Assert.checkNotNullParamWithNullPointerException((String)"mec", (Object)mec);
        this.mechanisms.add(mec);
    }

    public List<AuthMechanism> getMechanisms() {
        return Collections.unmodifiableList(this.mechanisms);
    }
}

