/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.security.model;

import java.io.IOException;
import java.util.List;
import org.aesh.command.CommandException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.impl.aesh.cmd.security.model.AuthFactory;
import org.jboss.as.cli.impl.aesh.cmd.security.model.AuthFactorySpec;
import org.jboss.as.cli.impl.aesh.cmd.security.model.AuthMechanism;
import org.jboss.as.cli.impl.aesh.cmd.security.model.DefaultResourceNames;
import org.jboss.as.cli.impl.aesh.cmd.security.model.ElytronUtil;
import org.jboss.as.cli.impl.aesh.cmd.security.model.KeyStoreConfiguration;
import org.jboss.as.cli.impl.aesh.cmd.security.model.PropertiesRealmConfiguration;
import org.jboss.as.cli.impl.aesh.cmd.security.model.Realm;
import org.jboss.as.cli.impl.aesh.cmd.security.model.SecurityDomain;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.dmr.ModelNode;
import org.wildfly.common.Assert;

public class AuthSecurityBuilder {
    private String newSecurityDomain;
    private String newFactoryName;
    private String newRealmName;
    private String activeFactoryName;
    private final ModelNode composite = new ModelNode();
    private final AuthMechanism mechanism;
    private AuthFactory authFactory;
    private final AuthFactory ootbFactory;
    private final List<String> order;
    private final AuthFactorySpec spec;
    private final String securityDomain;

    public AuthSecurityBuilder(AuthMechanism mechanism, AuthFactorySpec spec) throws CommandException {
        this.mechanism = (AuthMechanism)Assert.checkNotNullParamWithNullPointerException((String)"mechanism", (Object)mechanism);
        this.ootbFactory = null;
        this.order = null;
        this.securityDomain = null;
        this.spec = (AuthFactorySpec)Assert.checkNotNullParamWithNullPointerException((String)"spec", (Object)spec);
        this.init();
    }

    public AuthSecurityBuilder(AuthFactory ootbFactory) throws CommandException {
        this.mechanism = null;
        this.ootbFactory = (AuthFactory)Assert.checkNotNullParamWithNullPointerException((String)"ootbFactory", (Object)ootbFactory);
        this.order = null;
        this.securityDomain = null;
        this.spec = ootbFactory.getSpec();
        this.init();
    }

    public AuthSecurityBuilder(String securityDomain) throws CommandException {
        this.securityDomain = (String)Assert.checkNotNullParamWithNullPointerException((String)"securityDomain", (Object)securityDomain);
        this.order = null;
        this.mechanism = null;
        this.ootbFactory = null;
        this.spec = null;
        this.init();
    }

    public AuthSecurityBuilder(List<String> order) {
        this.order = (List)Assert.checkNotNullParamWithNullPointerException((String)"order", order);
        this.mechanism = null;
        this.ootbFactory = null;
        this.init();
        this.spec = AuthFactorySpec.SASL;
        this.securityDomain = null;
    }

    private void init() {
        this.composite.get("operation").set("composite");
        this.composite.get("address").setEmptyList();
    }

    public ModelNode getRequest() {
        return this.composite;
    }

    public ModelNode getSteps() {
        return this.composite.get("steps");
    }

    public AuthFactory getAuthFactory() {
        return this.ootbFactory == null ? this.authFactory : this.ootbFactory;
    }

    public String getReferencedSecurityDomain() {
        return this.securityDomain;
    }

    public AuthSecurityBuilder setNewRealmName(String newRealmName) {
        this.newRealmName = newRealmName;
        return this;
    }

    public AuthSecurityBuilder setSecurityDomainName(String securityDomain) {
        this.newSecurityDomain = securityDomain;
        return this;
    }

    public AuthSecurityBuilder setAuthFactoryName(String newFactoryName) {
        this.newFactoryName = newFactoryName;
        return this;
    }

    public AuthSecurityBuilder setActiveFactoryName(String activeFactoryName) {
        this.activeFactoryName = activeFactoryName;
        return this;
    }

    public boolean isFactoryAlreadySet() {
        return this.activeFactoryName != null;
    }

    public void buildRequest(CommandContext ctx) throws Exception {
        if (this.ootbFactory != null || this.securityDomain != null) {
            return;
        }
        if (this.order != null) {
            if (this.activeFactoryName == null) {
                throw new Exception("No SASL factory to re-order");
            }
            ModelNode request = ElytronUtil.reorderSASLFactory(ctx, this.order, this.activeFactoryName);
            this.getSteps().add(request);
            return;
        }
        Realm realm = this.buildRealm(ctx);
        if (realm != null && realm.getConfig().getRoles() != null) {
            String roleMapper = ElytronUtil.findMatchingConstantRoleMapper(realm.getConfig().getRoles(), ctx);
            if (roleMapper == null) {
                roleMapper = DefaultResourceNames.buildConstantRoleMapperName(realm, ctx);
                ModelNode request = ElytronUtil.buildConstantRoleMapper(realm.getConfig().getRoles(), roleMapper, ctx);
                this.getSteps().add(request);
            }
            realm.getConfig().setRoleMapper(roleMapper);
        }
        if (this.activeFactoryName == null) {
            if (this.newFactoryName == null) {
                this.authFactory = ElytronUtil.findMatchingAuthFactory(this.mechanism, this.spec, ctx);
            }
            if (this.authFactory == null) {
                SecurityDomain securityDomain = this.buildSecurityDomain(ctx, realm);
                this.authFactory = this.buildAuthFactory(ctx, securityDomain);
            } else {
                this.addRealm(ctx, this.authFactory.getSecurityDomain(), realm);
            }
        } else {
            this.authFactory = ElytronUtil.getAuthFactory(this.activeFactoryName, this.spec, ctx);
            if (this.authFactory == null) {
                throw new Exception("Impossible to create factory");
            }
            if (realm != null) {
                this.addRealm(ctx, this.authFactory.getSecurityDomain(), realm);
            }
        }
        if (this.authFactory == null) {
            throw new Exception("Impossible to create factory");
        }
        this.addAuthMechanism(ctx, this.authFactory, this.mechanism);
    }

    private Realm buildRealm(CommandContext ctx) throws Exception {
        String name;
        boolean existing = false;
        if (this.mechanism.getConfig() instanceof PropertiesRealmConfiguration) {
            PropertiesRealmConfiguration config = (PropertiesRealmConfiguration)this.mechanism.getConfig();
            String rName = null;
            if (this.newRealmName == null) {
                rName = ElytronUtil.findMatchingUsersPropertiesRealm(ctx, config);
            }
            if (rName == null) {
                if (this.newRealmName == null) {
                    this.newRealmName = DefaultResourceNames.buildUserPropertiesDefaultRealmName(ctx, config);
                }
                ModelNode request = ElytronUtil.addUsersPropertiesRealm(ctx, this.newRealmName, config);
                this.getSteps().add(request);
                name = this.newRealmName;
            } else {
                existing = true;
                name = rName;
            }
        } else if (this.mechanism.getConfig() instanceof KeyStoreConfiguration) {
            KeyStoreConfiguration tsConfig = (KeyStoreConfiguration)this.mechanism.getConfig();
            Object ksRealmName = null;
            if (this.newRealmName == null) {
                ksRealmName = ElytronUtil.findKeyStoreRealm(ctx, tsConfig.getTrustStore());
            }
            if (ksRealmName == null) {
                ksRealmName = this.newRealmName == null ? "ks-realm-" + tsConfig.getTrustStore() : this.newRealmName;
                ModelNode request = ElytronUtil.addKeyStoreRealm(ctx, (String)ksRealmName, tsConfig.getTrustStore());
                this.getSteps().add(request);
            } else {
                existing = true;
            }
            name = ksRealmName;
        } else {
            existing = true;
            name = this.mechanism.getConfig().getRealmName();
        }
        if (name == null) {
            return null;
        }
        String constantMapper = ElytronUtil.findConstantRealmMapper(ctx, name);
        if (constantMapper == null) {
            this.getSteps().add(ElytronUtil.addConstantRealmMapper(ctx, name));
            constantMapper = name;
        }
        this.mechanism.getConfig().setRealmMapperName(constantMapper);
        return new Realm(name, constantMapper, this.mechanism.getConfig(), existing);
    }

    private SecurityDomain buildSecurityDomain(CommandContext ctx, Realm realm) throws OperationFormatException, IOException {
        if (this.newSecurityDomain == null) {
            this.newSecurityDomain = DefaultResourceNames.buildDefaultSecurityDomainName(realm, ctx);
        }
        ModelNode request = ElytronUtil.addSecurityDomain(ctx, realm, this.newSecurityDomain);
        this.getSteps().add(request);
        SecurityDomain domain = new SecurityDomain(this.newSecurityDomain);
        if (realm != null) {
            domain.addRealm(realm);
        }
        return domain;
    }

    private AuthFactory buildAuthFactory(CommandContext ctx, SecurityDomain securityDomain) throws OperationFormatException, IOException {
        if (this.newFactoryName == null) {
            this.newFactoryName = DefaultResourceNames.buildDefaultAuthFactoryName(this.mechanism, this.spec, ctx);
        }
        ModelNode request = ElytronUtil.addAuthFactory(ctx, securityDomain, this.newFactoryName, this.spec);
        this.getSteps().add(request);
        AuthFactory factory = new AuthFactory(this.newFactoryName, securityDomain, this.spec);
        return factory;
    }

    private void addAuthMechanism(CommandContext ctx, AuthFactory authFactory, AuthMechanism mechanism) throws OperationFormatException {
        ElytronUtil.addAuthMechanism(ctx, authFactory, mechanism, this.getSteps());
    }

    private void addRealm(CommandContext ctx, SecurityDomain securityDomain, Realm realm) throws OperationFormatException {
        ElytronUtil.addRealm(ctx, securityDomain, realm, this.getSteps());
    }

    public boolean isEmpty() {
        return !this.getSteps().isDefined();
    }
}

