/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers;

import io.smallrye.mutiny.helpers.Subscriptions;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;

public class SubscriberWrapper<I, T>
implements Flow.Processor<T, T> {
    private final Flow.Subscriber<I> delegate;
    private final BiFunction<T, Throwable, CompletionStage<Void>> postAck;
    private final AtomicReference<Flow.Subscription> upstream = new AtomicReference();
    private final Function<T, I> mapper;

    public SubscriberWrapper(Flow.Subscriber<I> userSubscriber, Function<T, I> mapper, BiFunction<T, Throwable, CompletionStage<Void>> postAck) {
        this.delegate = Objects.requireNonNull(userSubscriber);
        this.mapper = Objects.requireNonNull(mapper);
        this.postAck = postAck;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> s) {
        s.onSubscribe(new Flow.Subscription(){

            @Override
            public void request(long n) {
            }

            @Override
            public void cancel() {
                Flow.Subscription subscription = SubscriberWrapper.this.upstream.getAndSet((Flow.Subscription)Subscriptions.CANCELLED);
                if (subscription != null) {
                    subscription.cancel();
                }
            }
        });
    }

    @Override
    public void onSubscribe(final Flow.Subscription s) {
        if (!this.upstream.compareAndSet(null, s)) {
            throw new IllegalStateException("We already received a subscription");
        }
        this.delegate.onSubscribe(new Flow.Subscription(){

            @Override
            public void request(long n) {
                s.request(n);
            }

            @Override
            public void cancel() {
                Flow.Subscription subscription = SubscriberWrapper.this.upstream.getAndSet((Flow.Subscription)Subscriptions.CANCELLED);
                if (subscription != null) {
                    subscription.cancel();
                }
            }
        });
    }

    @Override
    public void onNext(T item) {
        block3: {
            try {
                this.delegate.onNext(this.mapper.apply(item));
                if (this.postAck != null) {
                    this.postAck.apply(item, null);
                }
            }
            catch (Exception e) {
                if (this.postAck == null) break block3;
                this.postAck.apply(item, e);
            }
        }
    }

    @Override
    public void onError(Throwable error) {
        this.delegate.onError(error);
    }

    @Override
    public void onComplete() {
        this.delegate.onComplete();
    }
}

