/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.config.TransformerConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.transformer.Transformer;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpExpiredMessageTest
extends AmqpClientTestSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    @Timeout(value=60L)
    public void testSendMessageThatIsAlreadyExpiredUsingAbsoluteTime() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Assertions.assertNotNull((Object)queueView);
        AmqpMessage message = new AmqpMessage();
        message.setAbsoluteExpiryTime(System.currentTimeMillis() - 5000L);
        message.setText("Test-Message");
        sender.send(message);
        sender.close();
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(1);
        AmqpMessage received = receiver.receiveNoWait();
        Assertions.assertNull((Object)received);
        Wait.assertEquals((long)0L, () -> ((Queue)queueView).getMessageCount());
        Wait.assertEquals((long)1L, () -> ((Queue)queueView).getMessagesExpired());
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testExpiryThroughTTL() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Assertions.assertNotNull((Object)queueView);
        AmqpMessage message = new AmqpMessage();
        message.setTimeToLive(1L);
        message.setText("Test-Message");
        message.setDurable(true);
        message.setApplicationProperty("key1", "Value1");
        sender.send(message);
        sender.close();
        Thread.sleep(100L);
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(1);
        AmqpMessage received = receiver.receiveNoWait();
        Assertions.assertNull((Object)received);
        Wait.assertEquals((long)1L, () -> ((Queue)queueView).getMessagesExpired());
        connection.close();
        this.server.stop();
        this.server.start();
        Queue dlqView = this.getProxyToQueue(this.getDeadLetterAddress());
        Assertions.assertNotNull((Object)dlqView);
        Wait.assertEquals((long)1L, () -> ((Queue)dlqView).getMessageCount());
        client = this.createAmqpClient();
        connection = this.addConnection(client.connect());
        session = connection.createSession();
        AmqpReceiver receiverDLQ = session.createReceiver(this.getDeadLetterAddress());
        receiverDLQ.flow(1);
        received = receiverDLQ.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)received, (String)"Should have read message from DLQ");
        Assertions.assertEquals((long)0L, (long)received.getTimeToLive());
        Assertions.assertNotNull((Object)received);
        Assertions.assertEquals((Object)"Value1", (Object)received.getApplicationProperty("key1"));
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testRetryExpiry() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Assertions.assertNotNull((Object)queueView);
        AmqpMessage message = new AmqpMessage();
        message.setTimeToLive(1L);
        message.setText("Test-Message");
        message.setDurable(true);
        message.setApplicationProperty("key1", "Value1");
        sender.send(message);
        message = new AmqpMessage();
        message.setTimeToLive(1L);
        message.setBytes(new byte[512000]);
        sender.send(message);
        sender.close();
        Queue dlqView = this.getProxyToQueue(this.getDeadLetterAddress());
        Wait.assertEquals((long)2L, () -> ((Queue)dlqView).getMessageCount());
        Assertions.assertEquals((int)2, (int)dlqView.retryMessages(null));
        Wait.assertEquals((long)0L, () -> ((Queue)dlqView).getMessageCount());
        Wait.assertEquals((long)2L, () -> ((Queue)queueView).getMessageCount());
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(2);
        for (int i = 0; i < 2; ++i) {
            AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)received);
            received.accept();
        }
        connection.close();
        Wait.assertEquals((long)0L, () -> ((Queue)queueView).getMessageCount());
        Wait.assertEquals((long)0L, () -> ((Queue)dlqView).getMessageCount());
    }

    @Test
    @Timeout(value=60L)
    public void testExpiryThroughTTLValidateAnnotation() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Assertions.assertNotNull((Object)queueView);
        AmqpMessage message = new AmqpMessage();
        message.setTimeToLive(1L);
        message.setText("Test-Message");
        message.setDurable(true);
        message.setApplicationProperty("key1", "Value1");
        sender.send(message);
        sender.close();
        Thread.sleep(100L);
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(1);
        AmqpMessage received = receiver.receiveNoWait();
        Assertions.assertNull((Object)received);
        Wait.assertEquals((long)1L, () -> ((Queue)queueView).getMessagesExpired());
        connection.close();
        this.server.stop();
        this.server.start();
        Queue dlqView = this.getProxyToQueue(this.getDeadLetterAddress());
        Assertions.assertNotNull((Object)dlqView);
        Wait.assertEquals((long)1L, () -> ((Queue)dlqView).getMessageCount());
        client = this.createAmqpClient();
        connection = this.addConnection(client.connect());
        session = connection.createSession();
        AmqpReceiver receiverDLQ = session.createReceiver(this.getDeadLetterAddress(), "\"m.x-opt-ORIG-ADDRESS\"='" + this.getQueueName() + "'");
        receiverDLQ.flow(1);
        received = receiverDLQ.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)received);
        Assertions.assertEquals((Object)this.getQueueName(), (Object)received.getMessageAnnotation("x-opt-ORIG-ADDRESS"));
        receiverDLQ.close();
        receiverDLQ = session.createReceiver(this.getDeadLetterAddress(), "_AMQ_ORIG_ADDRESS='" + this.getQueueName() + "'");
        receiverDLQ.flow(1);
        received = receiverDLQ.receive(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)this.getQueueName(), (Object)received.getMessageAnnotation("x-opt-ORIG-ADDRESS"));
        Assertions.assertNotNull((Object)received);
        received.accept();
        Assertions.assertNotNull((Object)received, (String)"Should have read message from DLQ");
        Assertions.assertEquals((long)0L, (long)received.getTimeToLive());
        Assertions.assertNotNull((Object)received);
        Assertions.assertEquals((Object)"Value1", (Object)received.getApplicationProperty("key1"));
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testExpiryQpidJMS() throws Exception {
        ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", this.getBrokerAmqpConnectionURI().toString());
        try (Connection connection = factory.createConnection();){
            Session session = connection.createSession(false, 1);
            jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
            MessageProducer sender = session.createProducer((Destination)queue);
            Queue queueView = this.getProxyToQueue(this.getQueueName());
            Assertions.assertNotNull((Object)queueView);
            sender.setTimeToLive(1L);
            TextMessage message = session.createTextMessage("Test-Message");
            message.setStringProperty("key1", "Value1");
            sender.send((Message)message);
            sender.close();
            Wait.assertEquals((long)1L, () -> ((Queue)queueView).getMessagesExpired());
            Queue dlqView = this.getProxyToQueue(this.getDeadLetterAddress());
            Assertions.assertNotNull((Object)dlqView);
            Wait.assertEquals((long)1L, () -> ((Queue)dlqView).getMessageCount());
            connection.start();
            jakarta.jms.Queue queueDLQ = session.createQueue(this.getDeadLetterAddress());
            MessageConsumer receiverDLQ = session.createConsumer((Destination)queueDLQ, "\"m.x-opt-ORIG-ADDRESS\"='" + this.getQueueName() + "'");
            Message received = receiverDLQ.receive(5000L);
            Assertions.assertNotNull((Object)received);
            receiverDLQ.close();
        }
    }

    @Test
    @Timeout(value=60L)
    public void testSendMessageThatIsNotExpiredUsingAbsoluteTime() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Assertions.assertNotNull((Object)queueView);
        AmqpMessage message = new AmqpMessage();
        message.setAbsoluteExpiryTime(System.currentTimeMillis() + 5000L);
        message.setText("Test-Message");
        sender.send(message);
        sender.close();
        Wait.assertEquals((long)1L, () -> ((Queue)queueView).getMessageCount());
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(1);
        AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)received);
        Assertions.assertEquals((long)0L, (long)queueView.getMessagesExpired());
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testSendMessageThatIsExiredUsingAbsoluteTimeWithLongTTL() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Assertions.assertNotNull((Object)queueView);
        AmqpMessage message = new AmqpMessage();
        message.setAbsoluteExpiryTime(System.currentTimeMillis() - 5000L);
        message.setTimeToLive(60000L);
        message.setText("Test-Message");
        sender.send(message);
        sender.close();
        Wait.assertEquals((long)1L, () -> ((Queue)queueView).getMessageCount());
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(1);
        AmqpMessage received = receiver.receiveNoWait();
        Assertions.assertNull((Object)received);
        Wait.assertEquals((long)1L, () -> ((Queue)queueView).getMessagesExpired());
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testSendMessageThatIsExpiredUsingTTLWhenAbsoluteIsZero() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Assertions.assertNotNull((Object)queueView);
        AmqpMessage message = new AmqpMessage();
        message.setAbsoluteExpiryTime(0L);
        message.setTimeToLive(100L);
        message.setText("Test-Message");
        sender.send(message);
        sender.close();
        Wait.assertEquals((Long)1L, () -> ((Queue)queueView).getMessagesExpired(), (long)10000L, (long)10L);
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(1);
        AmqpMessage received = receiver.receiveNoWait();
        Assertions.assertNull((Object)received);
        Wait.assertEquals((long)1L, () -> ((Queue)queueView).getMessagesExpired());
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testSendMessageThatIsNotExpiredUsingAbsoluteTimeWithElspsedTTL() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Assertions.assertNotNull((Object)queueView);
        AmqpMessage message = new AmqpMessage();
        message.setAbsoluteExpiryTime(System.currentTimeMillis() + 5000L);
        message.setTimeToLive(10L);
        message.setText("Test-Message");
        sender.send(message);
        sender.close();
        Wait.assertEquals((long)1L, () -> ((Queue)queueView).getMessageCount());
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(1);
        AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)received);
        Wait.assertEquals((long)0L, () -> ((Queue)queueView).getMessagesExpired());
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testSendMessageThatIsNotExpiredUsingTimeToLive() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Assertions.assertNotNull((Object)queueView);
        AmqpMessage message = new AmqpMessage();
        message.setTimeToLive(5000L);
        message.setText("Test-Message");
        sender.send(message);
        sender.close();
        Wait.assertEquals((long)1L, () -> ((Queue)queueView).getMessageCount());
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(1);
        AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)received);
        Wait.assertEquals((long)0L, () -> ((Queue)queueView).getMessagesExpired());
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testSendMessageThatIsNotExpiredUsingTimeToLiveOfMaxUInt() throws Exception {
        this.doTestSendMessageThatIsNotExpiredUsingTimeToLive(UnsignedInteger.MAX_VALUE);
    }

    @Test
    @Timeout(value=60L)
    public void testSendMessageThatIsNotExpiredUsingTimeToLiveOfMaxIntValue() throws Exception {
        this.doTestSendMessageThatIsNotExpiredUsingTimeToLive(UnsignedInteger.valueOf((int)Integer.MAX_VALUE));
    }

    @Test
    @Timeout(value=60L)
    public void testSendMessageThatIsNotExpiredUsingTimeToLiveOfMinusOne() throws Exception {
        this.doTestSendMessageThatIsNotExpiredUsingTimeToLive(UnsignedInteger.valueOf((int)-1));
    }

    private void doTestSendMessageThatIsNotExpiredUsingTimeToLive(UnsignedInteger ttl) throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Assertions.assertNotNull((Object)queueView);
        AmqpMessage message = new AmqpMessage();
        message.setTimeToLive(ttl.longValue());
        message.setText("Test-Message");
        sender.send(message);
        sender.close();
        Wait.assertEquals((long)1L, () -> ((Queue)queueView).getMessageCount());
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(1);
        AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)received, (String)"Should have read message but it seems to have timed out.");
        Assertions.assertEquals((long)ttl.longValue(), (long)received.getTimeToLive());
        Wait.assertEquals((long)0L, () -> ((Queue)queueView).getMessagesExpired());
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testSendMessageThenAllowToExpiredUsingTimeToLive() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Assertions.assertNotNull((Object)queueView);
        AmqpMessage message = new AmqpMessage();
        message.setTimeToLive(10L);
        message.setText("Test-Message");
        sender.send(message);
        sender.close();
        Thread.sleep(50L);
        Wait.assertEquals((long)0L, () -> ((Queue)queueView).getMessageCount());
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(1);
        AmqpMessage received = receiver.receiveNoWait();
        Assertions.assertNull((Object)received);
        Wait.assertEquals((long)1L, () -> ((Queue)queueView).getMessagesExpired());
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testExpiredMessageLandsInDLQ() throws Throwable {
        this.internalSendExpiry(false);
    }

    @Test
    @Timeout(value=60L)
    public void testExpiredMessageLandsInDLQAndExistsAfterRestart() throws Throwable {
        this.internalSendExpiry(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalSendExpiry(boolean restartServer) throws Throwable {
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = client.connect();){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getQueueName());
            AmqpMessage message = new AmqpMessage();
            message.setDurable(true);
            message.setText("Test-Message");
            message.setDeliveryAnnotation("shouldDisappear", 1);
            message.setAbsoluteExpiryTime(System.currentTimeMillis() + 250L);
            sender.send(message);
            Queue dlq = this.getProxyToQueue(this.getDeadLetterAddress());
            Assertions.assertTrue((boolean)Wait.waitFor(() -> dlq.getMessageCount() > 0L, (long)7000L, (long)500L), (String)"Message not movied to DLQ");
            connection.close();
            if (restartServer) {
                this.server.stop();
                this.server.start();
            }
            connection = client.connect();
            session = connection.createSession();
            AmqpReceiver receiver = session.createReceiver(this.getDeadLetterAddress());
            receiver.flow(20);
            message = receiver.receive(5L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)message);
            Assertions.assertEquals((Object)this.getQueueName(), (Object)message.getMessageAnnotation("x-opt-ORIG-QUEUE"));
            Assertions.assertNull((Object)message.getDeliveryAnnotation("shouldDisappear"));
            Assertions.assertNull((Object)receiver.receiveNoWait());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testExpirationAfterDivert() throws Throwable {
        String FORWARDING_ADDRESS = RandomUtil.randomString();
        this.server.createQueue(QueueConfiguration.of((String)FORWARDING_ADDRESS).setRoutingType(RoutingType.ANYCAST));
        this.server.deployDivert(new DivertConfiguration().setName(RandomUtil.randomString()).setAddress(this.getQueueName()).setForwardingAddress(FORWARDING_ADDRESS).setTransformerConfiguration(new TransformerConfiguration(MyTransformer.class.getName())).setExclusive(true));
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = client.connect();){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getQueueName());
            AmqpMessage message = new AmqpMessage();
            message.setDurable(true);
            message.setText("Test-Message");
            message.setDeliveryAnnotation("shouldDisappear", 1);
            message.setMessageAnnotation("x-opt-routing-type", (byte)1);
            logger.debug("*******************************************************************************************************************************");
            logger.debug("message being sent {}", (Object)message);
            sender.send(message);
            logger.debug("*******************************************************************************************************************************");
            Queue forward = this.getProxyToQueue(FORWARDING_ADDRESS);
            Assertions.assertTrue((boolean)Wait.waitFor(() -> forward.getMessageCount() > 0L, (long)7000L, (long)500L), (String)"Message not diverted");
            Queue dlq = this.getProxyToQueue(this.getDeadLetterAddress());
            Assertions.assertTrue((boolean)Wait.waitFor(() -> dlq.getMessageCount() > 0L, (long)7000L, (long)500L), (String)"Message not moved to DLQ");
            connection.close();
            connection = client.connect();
            session = connection.createSession();
            AmqpReceiver receiver = session.createReceiver(this.getDeadLetterAddress());
            receiver.flow(20);
            message = receiver.receive(5L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)message);
            Assertions.assertEquals((Object)FORWARDING_ADDRESS, (Object)message.getMessageAnnotation("x-opt-ORIG-QUEUE"));
            Assertions.assertNull((Object)message.getDeliveryAnnotation("shouldDisappear"));
            Assertions.assertNull((Object)receiver.receiveNoWait());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testDLQdMessageCanBeRedeliveredMultipleTimes() throws Throwable {
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = client.connect();){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getQueueName());
            AmqpMessage message = new AmqpMessage();
            message.setDurable(true);
            message.setTimeToLive(250L);
            message.setText("Test-Message");
            message.setMessageId(UUID.randomUUID().toString());
            message.setApplicationProperty("key", "value");
            sender.send(message);
            Queue dlqView = this.getProxyToQueue(this.getDeadLetterAddress());
            Assertions.assertTrue((boolean)Wait.waitFor(() -> dlqView.getMessageCount() > 0L, (long)7000L, (long)200L), (String)"Message not movied to DLQ");
            AmqpReceiver receiver = session.createReceiver(this.getDeadLetterAddress());
            receiver.flow(20);
            message = receiver.receive(5L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)message);
            Assertions.assertEquals((long)0L, (long)message.getWrappedMessage().getDeliveryCount());
            message.modified(true, false);
            message = receiver.receive(5L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)message);
            Assertions.assertEquals((long)1L, (long)message.getWrappedMessage().getDeliveryCount());
            message.modified(true, false);
            message = receiver.receive(5L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)message);
            Assertions.assertEquals((long)2L, (long)message.getWrappedMessage().getDeliveryCount());
            message.modified(true, false);
            message = receiver.receive(5L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)message);
            Assertions.assertEquals((long)3L, (long)message.getWrappedMessage().getDeliveryCount());
        }
    }

    @Test
    @Timeout(value=60L)
    public void testExpireThorughAddressSettings() throws Exception {
        this.testExpireThorughAddressSettings(false);
    }

    @Test
    @Timeout(value=60L)
    public void testExpireThorughAddressSettingsRebootServer() throws Exception {
        this.testExpireThorughAddressSettings(true);
    }

    private void testExpireThorughAddressSettings(boolean reboot) throws Exception {
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        addressSettings.setAutoCreateQueues(Boolean.valueOf(this.isAutoCreateQueues()));
        addressSettings.setAutoCreateAddresses(Boolean.valueOf(this.isAutoCreateAddresses()));
        addressSettings.setDeadLetterAddress(SimpleString.of((String)this.getDeadLetterAddress()));
        addressSettings.setExpiryAddress(SimpleString.of((String)this.getDeadLetterAddress()));
        addressSettings.setExpiryDelay(Long.valueOf(1000L));
        this.server.getAddressSettingsRepository().clear();
        this.server.getAddressSettingsRepository().addMatch("#", (Object)addressSettings);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Assertions.assertNotNull((Object)queueView);
        AmqpMessage message = new AmqpMessage();
        message.setText("Test-Message");
        message.setDurable(true);
        message.setApplicationProperty("key1", "Value1");
        sender.send(message);
        message = new AmqpMessage();
        message.setBytes(new byte[512000]);
        message.setDurable(true);
        sender.send(message);
        sender.close();
        connection.close();
        if (reboot) {
            this.server.stop();
            this.server.getConfiguration().setMessageExpiryScanPeriod(100L);
            this.server.start();
        }
        Queue serverQueue = this.server.locateQueue(this.getQueueName());
        try (LinkedListIterator referenceIterator = serverQueue.iterator();){
            while (referenceIterator.hasNext()) {
                MessageReference ref = (MessageReference)referenceIterator.next();
                Assertions.assertEquals((long)ref.getMessage().getExpiration(), (long)ref.getMessage().toCore().getExpiration());
                Assertions.assertTrue((ref.getMessage().getExpiration() > 0L ? 1 : 0) != 0);
                Assertions.assertTrue((ref.getMessage().toCore().getExpiration() > 0L ? 1 : 0) != 0);
            }
        }
        Queue dlqView = this.getProxyToQueue(this.getDeadLetterAddress());
        Wait.assertEquals((long)2L, () -> ((Queue)dlqView).getMessageCount());
    }

    @Test
    public void testPreserveExpirationOnTTL() throws Exception {
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        addressSettings.setAutoCreateQueues(Boolean.valueOf(this.isAutoCreateQueues()));
        addressSettings.setAutoCreateAddresses(Boolean.valueOf(this.isAutoCreateAddresses()));
        addressSettings.setDeadLetterAddress(SimpleString.of((String)this.getDeadLetterAddress()));
        addressSettings.setExpiryAddress(SimpleString.of((String)this.getDeadLetterAddress()));
        addressSettings.setExpiryDelay(Long.valueOf(1000L));
        this.server.getAddressSettingsRepository().clear();
        this.server.getAddressSettingsRepository().addMatch("#", (Object)addressSettings);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Assertions.assertNotNull((Object)queueView);
        AmqpMessage message = new AmqpMessage();
        message.setText("Test-Message");
        message.setDurable(true);
        message.setTimeToLive(3600000L);
        message.setApplicationProperty("id", "0");
        sender.send(message);
        message = new AmqpMessage();
        message.setBytes(new byte[512000]);
        message.setDurable(true);
        message.setTimeToLive(3600000L);
        message.setApplicationProperty("id", "1");
        sender.send(message);
        Wait.assertEquals((long)2L, () -> ((Queue)queueView).getMessageCount());
        LinkedListIterator linkedListIterator = queueView.iterator();
        HashMap<String, Long> dataSet = new HashMap<String, Long>();
        int count = 0;
        while (linkedListIterator.hasNext()) {
            ++count;
            MessageReference ref = (MessageReference)linkedListIterator.next();
            String idUsed = ref.getMessage().getStringProperty("id");
            dataSet.put(idUsed, ref.getMessage().getExpiration());
        }
        Assertions.assertEquals((int)2, (int)count);
        linkedListIterator.close();
        this.server.stop();
        Thread.sleep(500L);
        this.server.getConfiguration().setMessageExpiryScanPeriod(100L);
        this.server.start();
        Queue queueViewAfterRestart = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((long)2L, () -> ((Queue)queueViewAfterRestart).getMessageCount());
        Wait.assertTrue(() -> ((ActiveMQServer)this.server).isActive());
        linkedListIterator = queueViewAfterRestart.iterator();
        count = 0;
        while (linkedListIterator.hasNext()) {
            ++count;
            MessageReference ref = (MessageReference)linkedListIterator.next();
            String idUsed = ref.getMessage().getStringProperty("id");
            long originalExpiration = (Long)dataSet.get(idUsed);
            logger.info("original Expiration = {} while this expiration = {}", (Object)originalExpiration, (Object)ref.getMessage().getExpiration());
            Assertions.assertEquals((long)originalExpiration, (long)ref.getMessage().getExpiration());
        }
        Assertions.assertEquals((int)2, (int)count);
        linkedListIterator.close();
    }

    public static class MyTransformer
    implements Transformer {
        public org.apache.activemq.artemis.api.core.Message transform(org.apache.activemq.artemis.api.core.Message message) {
            return message.setExpiration(System.currentTimeMillis() + 250L);
        }
    }
}

