/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.ResourceAllocationException;
import jakarta.jms.Session;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.AddressControl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class AmqpFlowControlTest
extends JMSClientTestSupport {
    private static final long MAX_SIZE_BYTES = 0x100000L;
    private static final long MAX_SIZE_BYTES_REJECT_THRESHOLD = 0x200000L;
    private String singleCreditAcceptorURI = new String("tcp://localhost:5680");
    private int messagesSent;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.messagesSent = 0;
    }

    @Override
    protected void addAdditionalAcceptors(ActiveMQServer server) throws Exception {
        server.getConfiguration().addAcceptorConfiguration("flow", this.singleCreditAcceptorURI + "?protocols=AMQP;useEpoll=false;amqpCredits=1;amqpLowCredits=1");
    }

    @Override
    protected void configureAddressPolicy(ActiveMQServer server) {
        AddressSettings addressSettings = (AddressSettings)server.getAddressSettingsRepository().getMatch("#");
        addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.BLOCK);
        addressSettings.setMaxSizeBytes(0x100000L);
        addressSettings.setMaxSizeBytesRejectThreshold(0x200000L);
        server.getAddressSettingsRepository().addMatch("#", (Object)addressSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testCreditsAreAllocatedOnceOnLinkCreated() throws Exception {
        AmqpClient client = this.createAmqpClient(new URI(this.singleCreditAcceptorURI));
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getQueueName());
            Assertions.assertEquals((int)1, (int)sender.getSender().getCredit(), (String)"Should only be issued one credit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testCreditIsNotGivenOnLinkCreationWhileBlockedAndIsGivenOnceThenUnblocked() throws Exception {
        AmqpClient client = this.createAmqpClient(new URI(this.singleCreditAcceptorURI));
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AddressControl addressControl = ManagementControlHelper.createAddressControl(SimpleString.of((String)this.getQueueName()), this.mBeanServer);
            addressControl.block();
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getQueueName());
            Assertions.assertTrue((boolean)Wait.waitFor(() -> 0 == sender.getSender().getCredit(), (long)5000L, (long)20L), (String)"Should get 0 credit");
            addressControl.unblock();
            Assertions.assertTrue((boolean)Wait.waitFor(() -> 1 == sender.getSender().getCredit(), (long)5000L, (long)20L), (String)"Should now get issued one credit");
            sender.close();
            AmqpSender sender2 = session.createSender(this.getQueueName());
            Assertions.assertEquals((int)1, (int)sender2.getSender().getCredit(), (String)"Should only be issued one credit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testCreditsAreNotAllocatedWhenAddressIsFull() throws Exception {
        AmqpClient client = this.createAmqpClient(new URI(this.singleCreditAcceptorURI));
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getQueueName());
            sender.setSendTimeout(-1L);
            this.sendUntilFull(sender);
            Assertions.assertTrue((sender.getSender().getCredit() == -1 ? 1 : 0) != 0);
            long addressSize = this.server.getPagingManager().getPageStore(SimpleString.of((String)this.getQueueName())).getAddressSize();
            Assertions.assertTrue((addressSize >= 0x100000L && addressSize <= 0x200000L ? 1 : 0) != 0);
        }
    }

    @Test
    @Timeout(value=60L)
    public void testAddressIsBlockedForOtherProducersWhenFull() throws Exception {
        Connection connection = this.createConnection();
        Session session = connection.createSession(false, 1);
        Queue d = session.createQueue(this.getQueueName());
        MessageProducer p = session.createProducer((Destination)d);
        this.fillAddress(this.getQueueName());
        ResourceAllocationException e = null;
        try {
            p.send((Message)session.createBytesMessage());
        }
        catch (ResourceAllocationException rae) {
            e = rae;
        }
        Assertions.assertTrue((boolean)(e instanceof ResourceAllocationException));
        Assertions.assertTrue((boolean)e.getMessage().contains("resource-limit-exceeded"));
        long addressSize = this.server.getPagingManager().getPageStore(SimpleString.of((String)this.getQueueName())).getAddressSize();
        Assertions.assertTrue((addressSize >= 0x200000L ? 1 : 0) != 0);
    }

    @Test
    @Timeout(value=60L)
    public void testSendBlocksWhenAddressBlockedAndCompletesAfterUnblocked() throws Exception {
        Connection connection = this.createConnection(new URI(this.singleCreditAcceptorURI.replace("tcp", "amqp")), null, null, null, true);
        Session session = connection.createSession(false, 1);
        Queue d = session.createQueue(this.getQueueName());
        MessageProducer p = session.createProducer((Destination)d);
        CountDownLatch running = new CountDownLatch(1);
        CountDownLatch done = new CountDownLatch(1);
        AddressControl addressControl = ManagementControlHelper.createAddressControl(SimpleString.of((String)this.getQueueName()), this.mBeanServer);
        Assertions.assertTrue((boolean)addressControl.block(), (String)"blocked ok");
        p.send((Message)session.createBytesMessage());
        new Thread(() -> {
            try {
                running.countDown();
                p.send((Message)session.createBytesMessage());
            }
            catch (JMSException jMSException) {
            }
            finally {
                done.countDown();
            }
        }).start();
        Assertions.assertTrue((boolean)running.await(5L, TimeUnit.SECONDS));
        Assertions.assertFalse((boolean)done.await(200L, TimeUnit.MILLISECONDS));
        addressControl.unblock();
        Assertions.assertTrue((boolean)done.await(5L, TimeUnit.SECONDS));
        p.send((Message)session.createBytesMessage());
        Assertions.assertEquals((long)3L, (long)addressControl.getMessageCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testCreditsAreRefreshedWhenAddressIsUnblocked() throws Exception {
        this.fillAddress(this.getQueueName());
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getQueueName());
            Thread.sleep(500L);
            Assertions.assertEquals((int)0, (int)sender.getSender().getCredit());
            AmqpReceiver receiver = session.createReceiver(this.getQueueName());
            receiver.flow(100);
            for (int i = 0; i < this.messagesSent - 1; ++i) {
                AmqpMessage m = receiver.receive(5000L, TimeUnit.MILLISECONDS);
                m.accept();
            }
            Thread.sleep(500L);
            Assertions.assertTrue((sender.getSender().getCredit() >= 0 ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testNewLinkAttachAreNotAllocatedCreditsWhenAddressIsBlocked() throws Exception {
        this.fillAddress(this.getQueueName());
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getQueueName());
            Thread.sleep(1000L);
            Assertions.assertEquals((int)0, (int)sender.getSender().getCredit());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testTxIsRolledBackOnRejectedPreSettledMessage() throws Throwable {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        sender.setPresettle(true);
        this.fillAddress(this.getQueueName());
        AmqpMessage message = new AmqpMessage();
        byte[] payload = new byte[51200];
        message.setBytes(payload);
        Exception expectedException = null;
        try {
            session.begin();
            sender.send(message);
            session.commit();
        }
        catch (Exception e) {
            expectedException = e;
        }
        finally {
            connection.close();
        }
        Assertions.assertNotNull((Object)expectedException);
        Assertions.assertTrue((boolean)expectedException.getMessage().contains("resource-limit-exceeded"));
        Assertions.assertTrue((boolean)expectedException.getMessage().contains("Address is full: " + this.getQueueName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillAddress(String address) throws Exception {
        AmqpClient client = this.createAmqpClient();
        Exception exception = null;
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(address);
            this.sendUntilFull(sender);
        }
        Assertions.assertNotNull((Object)exception);
        Assertions.assertTrue((boolean)exception.getMessage().contains("amqp:resource-limit-exceeded"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendUntilFull(AmqpSender sender) throws Exception {
        AmqpMessage message = new AmqpMessage();
        byte[] payload = new byte[51200];
        message.setBytes(payload);
        int maxMessages = 50;
        AtomicInteger sentMessages = new AtomicInteger(0);
        Exception[] errors = new Exception[1];
        CountDownLatch timeout = new CountDownLatch(1);
        Runnable sendMessages = () -> {
            try {
                for (int i = 0; i < 50; ++i) {
                    sender.send(message);
                    sentMessages.getAndIncrement();
                }
                timeout.countDown();
            }
            catch (IOException e) {
                errors[0] = e;
            }
        };
        Thread t = new Thread(sendMessages);
        try {
            t.start();
            timeout.await(1L, TimeUnit.SECONDS);
            this.messagesSent = sentMessages.get();
            if (errors[0] != null) {
                throw errors[0];
            }
        }
        finally {
            t.interrupt();
            t.join(1000L);
            Assertions.assertFalse((boolean)t.isAlive());
        }
    }
}

