/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ComponentConfigurationRoutingType;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.transformer.Transformer;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class AmqpMessageDivertsTest
extends AmqpClientTestSupport
implements Transformer {
    static final AtomicInteger divertCount = new AtomicInteger(0);
    String largeString = this.createLargeString();

    protected String createLargeString() {
        StringBuffer bufferLarge = new StringBuffer();
        for (int i = 0; i < 512000; ++i) {
            bufferLarge.append((char)(97 + i % 20));
        }
        String largeString = bufferLarge.toString();
        return largeString;
    }

    @Test
    @Timeout(value=60L)
    public void testQueueReceiverReadMessageWithDivert() throws Exception {
        this.runQueueReceiverReadMessageWithDivert(ComponentConfigurationRoutingType.ANYCAST.toString());
    }

    @Test
    @Timeout(value=60L)
    public void testQueueReceiverReadMessageWithDivertDefaultRouting() throws Exception {
        this.runQueueReceiverReadMessageWithDivert(ActiveMQDefaultConfiguration.getDefaultDivertRoutingType());
    }

    public void runQueueReceiverReadMessageWithDivert(String routingType) throws Exception {
        String forwardingAddress = this.getQueueName() + "Divert";
        SimpleString simpleForwardingAddress = SimpleString.of((String)forwardingAddress);
        this.server.createQueue(QueueConfiguration.of((SimpleString)simpleForwardingAddress).setRoutingType(RoutingType.ANYCAST));
        this.server.getActiveMQServerControl().createDivert("name", "routingName", this.getQueueName(), forwardingAddress, true, null, null, routingType);
        this.sendMessages(this.getQueueName(), 1);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(forwardingAddress);
        Queue queueView = this.getProxyToQueue(forwardingAddress);
        Assertions.assertEquals((long)1L, (long)queueView.getMessageCount());
        receiver.flow(1);
        Assertions.assertNotNull((Object)receiver.receive(5L, TimeUnit.SECONDS));
        receiver.close();
        Assertions.assertEquals((long)1L, (long)queueView.getMessageCount());
        connection.close();
    }

    @Test
    public void testDivertTransformerWithProperties() throws Exception {
        this.testDivertTransformerWithProperties(false);
    }

    @Test
    public void testDivertTransformerWithPropertiesRebootServer() throws Exception {
        this.testDivertTransformerWithProperties(true);
    }

    public void testDivertTransformerWithProperties(boolean rebootServer) throws Exception {
        divertCount.set(0);
        String forwardingAddress = this.getQueueName() + "Divert";
        SimpleString simpleForwardingAddress = SimpleString.of((String)forwardingAddress);
        this.server.createQueue(QueueConfiguration.of((SimpleString)simpleForwardingAddress).setRoutingType(RoutingType.ANYCAST));
        this.server.getActiveMQServerControl().createDivert("name", "routingName", this.getQueueName(), forwardingAddress, true, null, AmqpMessageDivertsTest.class.getName(), ComponentConfigurationRoutingType.ANYCAST.toString());
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        Queue queueView = this.getProxyToQueue(forwardingAddress);
        AmqpSender sender = session.createSender(this.getQueueName());
        AmqpMessage message = new AmqpMessage();
        message.setDurable(true);
        message.setApplicationProperty("addLarge", false);
        message.setApplicationProperty("always", "here");
        message.setBytes(new byte[10]);
        sender.send(message);
        Wait.assertEquals((long)1L, () -> ((Queue)queueView).getMessageCount());
        message = new AmqpMessage();
        message.setDurable(true);
        message.setApplicationProperty("addLarge", false);
        message.setApplicationProperty("always", "here");
        message.setBytes(new byte[307200]);
        sender.send(message);
        Wait.assertEquals((long)2L, () -> ((Queue)queueView).getMessageCount());
        if (rebootServer) {
            Wait.assertEquals((int)2, divertCount::get);
            connection.close();
            this.server.stop();
            this.server.start();
            client = this.createAmqpClient();
            connection = this.addConnection(client.connect());
            session = connection.createSession();
        } else {
            message = new AmqpMessage();
            message.setDurable(false);
            message.setBytes(new byte[307200]);
            message.setApplicationProperty("addLarge", true);
            message.setApplicationProperty("always", "here");
            sender.send(message);
            Wait.assertEquals((int)3, divertCount::get);
        }
        AmqpReceiver receiver = session.createReceiver(forwardingAddress);
        queueView = this.getProxyToQueue(forwardingAddress);
        Assertions.assertEquals((long)(rebootServer ? 2L : 3L), (long)queueView.getMessageCount());
        receiver.flow(2);
        for (int i = 0; i < 2; ++i) {
            AmqpMessage receivedMessage = receiver.receive(5L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)receivedMessage);
            Assertions.assertEquals((Object)"here", (Object)receivedMessage.getApplicationProperty("always"));
            Assertions.assertEquals((Object)"mundo", (Object)receivedMessage.getApplicationProperty("oi"));
            receivedMessage.accept();
        }
        if (!rebootServer) {
            receiver.flow(1);
            AmqpMessage receivedMessage = receiver.receive(5L, TimeUnit.SECONDS);
            receivedMessage.accept();
            Assertions.assertEquals((Object)"mundo", (Object)receivedMessage.getApplicationProperty("oi"));
            Assertions.assertEquals((Object)this.largeString, (Object)receivedMessage.getApplicationProperty("largeString"));
        }
        receiver.close();
        Wait.assertEquals((long)0L, () -> ((Queue)queueView).getMessageCount());
        connection.close();
    }

    public Message transform(Message message) {
        divertCount.incrementAndGet();
        if (message.getBooleanProperty("addLarge").booleanValue()) {
            message.putStringProperty("largeString", this.largeString);
        }
        message.putBooleanProperty("oi", true);
        message.putStringProperty("oi", "mundo");
        message.reencode();
        return message;
    }
}

