/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.management.impl.ActiveMQServerControlImpl;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class AmqpMessageRoutingTest
extends JMSClientTestSupport {
    @Override
    protected String getConfiguredProtocols() {
        return "AMQP,OPENWIRE,CORE";
    }

    @Override
    protected boolean isAutoCreateQueues() {
        return false;
    }

    @Override
    protected boolean isAutoCreateAddresses() {
        return false;
    }

    @Test
    @Timeout(value=60L)
    public void testAnycastMessageRoutingExclusivityUsingPrefix() throws Exception {
        String addressA = "addressA";
        String queueA = "queueA";
        String queueB = "queueB";
        String queueC = "queueC";
        ActiveMQServerControlImpl serverControl = this.server.getActiveMQServerControl();
        serverControl.createAddress("addressA", RoutingType.ANYCAST.toString() + "," + RoutingType.MULTICAST.toString());
        serverControl.createQueue(QueueConfiguration.of((String)"queueA").setAddress("addressA").setRoutingType(RoutingType.ANYCAST).toJSON());
        serverControl.createQueue(QueueConfiguration.of((String)"queueB").setAddress("addressA").setRoutingType(RoutingType.ANYCAST).toJSON());
        serverControl.createQueue(QueueConfiguration.of((String)"queueC").setAddress("addressA").setRoutingType(RoutingType.MULTICAST).toJSON());
        this.sendMessages("anycast://addressA", 1);
        Wait.assertEquals((long)1L, () -> this.server.locateQueue(SimpleString.of((String)"queueA")).getMessageCount() + this.server.locateQueue(SimpleString.of((String)"queueB")).getMessageCount());
        Wait.assertEquals((long)0L, () -> ((Queue)this.server.locateQueue(SimpleString.of((String)"queueC"))).getMessageCount());
    }

    @Test
    @Timeout(value=60L)
    public void testAnycastMessageRoutingExclusivityUsingProperty() throws Exception {
        String addressA = "addressA";
        String queueA = "queueA";
        String queueB = "queueB";
        String queueC = "queueC";
        ActiveMQServerControlImpl serverControl = this.server.getActiveMQServerControl();
        serverControl.createAddress("addressA", RoutingType.ANYCAST.toString() + "," + RoutingType.MULTICAST.toString());
        serverControl.createQueue(QueueConfiguration.of((String)"queueA").setAddress("addressA").setRoutingType(RoutingType.ANYCAST).toJSON());
        serverControl.createQueue(QueueConfiguration.of((String)"queueB").setAddress("addressA").setRoutingType(RoutingType.ANYCAST).toJSON());
        serverControl.createQueue(QueueConfiguration.of((String)"queueC").setAddress("addressA").setRoutingType(RoutingType.MULTICAST).toJSON());
        this.sendMessages("addressA", 1, RoutingType.ANYCAST);
        Wait.assertEquals((long)1L, () -> this.server.locateQueue(SimpleString.of((String)"queueA")).getMessageCount() + this.server.locateQueue(SimpleString.of((String)"queueB")).getMessageCount());
        Wait.assertEquals((long)0L, () -> ((Queue)this.server.locateQueue(SimpleString.of((String)"queueC"))).getMessageCount());
    }

    @Test
    @Timeout(value=60L)
    public void testMulticastMessageRoutingExclusivityUsingPrefix() throws Exception {
        String addressA = "addressA";
        String queueA = "queueA";
        String queueB = "queueB";
        String queueC = "queueC";
        ActiveMQServerControlImpl serverControl = this.server.getActiveMQServerControl();
        serverControl.createAddress("addressA", RoutingType.ANYCAST.toString() + "," + RoutingType.MULTICAST.toString());
        serverControl.createQueue(QueueConfiguration.of((String)"queueA").setAddress("addressA").setRoutingType(RoutingType.ANYCAST).toJSON());
        serverControl.createQueue(QueueConfiguration.of((String)"queueB").setAddress("addressA").setRoutingType(RoutingType.MULTICAST).toJSON());
        serverControl.createQueue(QueueConfiguration.of((String)"queueC").setAddress("addressA").setRoutingType(RoutingType.MULTICAST).toJSON());
        this.sendMessages("multicast://addressA", 1);
        Wait.assertEquals((long)0L, () -> ((Queue)this.server.locateQueue(SimpleString.of((String)"queueA"))).getMessageCount());
        Wait.assertEquals((long)2L, () -> this.server.locateQueue(SimpleString.of((String)"queueC")).getMessageCount() + this.server.locateQueue(SimpleString.of((String)"queueB")).getMessageCount());
    }

    @Test
    @Timeout(value=60L)
    public void testMulticastMessageRoutingExclusivityUsingProperty() throws Exception {
        String addressA = "addressA";
        String queueA = "queueA";
        String queueB = "queueB";
        String queueC = "queueC";
        ActiveMQServerControlImpl serverControl = this.server.getActiveMQServerControl();
        serverControl.createAddress("addressA", RoutingType.ANYCAST.toString() + "," + RoutingType.MULTICAST.toString());
        serverControl.createQueue(QueueConfiguration.of((String)"queueA").setAddress("addressA").setRoutingType(RoutingType.ANYCAST).toJSON());
        serverControl.createQueue(QueueConfiguration.of((String)"queueB").setAddress("addressA").setRoutingType(RoutingType.MULTICAST).toJSON());
        serverControl.createQueue(QueueConfiguration.of((String)"queueC").setAddress("addressA").setRoutingType(RoutingType.MULTICAST).toJSON());
        this.sendMessages("addressA", 1, RoutingType.MULTICAST);
        Wait.assertEquals((long)0L, () -> ((Queue)this.server.locateQueue(SimpleString.of((String)"queueA"))).getMessageCount());
        Wait.assertEquals((long)2L, () -> this.server.locateQueue(SimpleString.of((String)"queueC")).getMessageCount() + this.server.locateQueue(SimpleString.of((String)"queueB")).getMessageCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testRoutingExclusivity() throws Exception {
        String testAddress = "testRoutingExclusivity-mixed-mode";
        SimpleString ssTestAddress = SimpleString.of((String)testAddress);
        AddressInfo addressInfo = new AddressInfo(ssTestAddress);
        addressInfo.addRoutingType(RoutingType.MULTICAST);
        addressInfo.addRoutingType(RoutingType.ANYCAST);
        this.server.addAddressInfo(addressInfo);
        this.server.createQueue(QueueConfiguration.of((SimpleString)ssTestAddress).setRoutingType(RoutingType.ANYCAST));
        try (Connection connection = this.createConnection(UUIDGenerator.getInstance().generateStringUUID());){
            Session session = connection.createSession(false, 1);
            Topic topic = session.createTopic(testAddress);
            jakarta.jms.Queue queue = session.createQueue(testAddress);
            MessageProducer producer = session.createProducer((Destination)topic);
            MessageConsumer queueConsumer = session.createConsumer((Destination)queue);
            MessageConsumer topicConsumer = session.createConsumer((Destination)topic);
            producer.send((Message)session.createTextMessage("testMessage"));
            Assertions.assertNotNull((Object)topicConsumer.receive(1000L));
            Assertions.assertNull((Object)queueConsumer.receive(1000L));
        }
    }

    @Test
    @Timeout(value=60L)
    public void testAMQPRouteMessageToJMSOpenWire() throws Throwable {
        this.testAMQPRouteMessageToJMS(this.createOpenWireConnection());
    }

    @Test
    @Timeout(value=60L)
    public void testAMQPRouteMessageToJMSAMQP() throws Throwable {
        this.testAMQPRouteMessageToJMS(this.createConnection());
    }

    @Test
    @Timeout(value=60L)
    public void testAMQPRouteMessageToJMSCore() throws Throwable {
        this.testAMQPRouteMessageToJMS(this.createCoreConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAMQPRouteMessageToJMS(Connection connection) throws Exception {
        String addressA = "addressA";
        ActiveMQServerControlImpl serverControl = this.server.getActiveMQServerControl();
        serverControl.createAddress("addressA", RoutingType.ANYCAST.toString() + "," + RoutingType.MULTICAST.toString());
        serverControl.createQueue(QueueConfiguration.of((String)"addressA").setRoutingType(RoutingType.ANYCAST).toJSON());
        try {
            Session session = connection.createSession(false, 1);
            Topic topic = session.createTopic("addressA");
            jakarta.jms.Queue queue = session.createQueue("addressA");
            MessageConsumer queueConsumer = session.createConsumer((Destination)queue);
            MessageConsumer topicConsumer = session.createConsumer((Destination)topic);
            this.sendMessages("addressA", 1, RoutingType.MULTICAST);
            Message topicMessage = topicConsumer.receive(1000L);
            Assertions.assertNotNull((Object)topicMessage);
            Assertions.assertEquals((Object)"addressA", (Object)((Topic)topicMessage.getJMSDestination()).getTopicName());
            Assertions.assertNull((Object)queueConsumer.receiveNoWait());
            this.sendMessages("addressA", 1, RoutingType.ANYCAST);
            Message queueMessage = queueConsumer.receive(1000L);
            Assertions.assertNotNull((Object)queueMessage);
            Assertions.assertEquals((Object)"addressA", (Object)((jakarta.jms.Queue)queueMessage.getJMSDestination()).getQueueName());
            Assertions.assertNull((Object)topicConsumer.receiveNoWait());
            this.sendMessages("addressA", 1, null);
            Message queueMessage2 = queueConsumer.receive(1000L);
            Assertions.assertNotNull((Object)queueMessage2);
            Assertions.assertEquals((Object)"addressA", (Object)((jakarta.jms.Queue)queueMessage2.getJMSDestination()).getQueueName());
            Message topicMessage2 = topicConsumer.receive(1000L);
            Assertions.assertNotNull((Object)topicMessage2);
            Assertions.assertEquals((Object)"addressA", (Object)((Topic)topicMessage2.getJMSDestination()).getTopicName());
        }
        finally {
            connection.close();
        }
    }
}

