/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameter;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.activemq.transport.amqp.client.AmqpValidator;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Sender;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class AmqpSenderTest
extends AmqpClientTestSupport {
    @Parameter(index=0)
    public boolean persistCache;

    @Parameters(name="persistentCache={0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({true}, {false});
    }

    @Override
    protected void addConfiguration(ActiveMQServer server) {
        server.getConfiguration().setPersistIDCache(this.persistCache);
    }

    @Override
    protected void addAdditionalAcceptors(ActiveMQServer server) throws Exception {
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testSenderSettlementModeSettledIsHonored() throws Exception {
        this.doTestSenderSettlementModeIsHonored(SenderSettleMode.SETTLED);
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testSenderSettlementModeUnsettledIsHonored() throws Exception {
        this.doTestSenderSettlementModeIsHonored(SenderSettleMode.UNSETTLED);
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testSenderSettlementModeMixedIsHonored() throws Exception {
        this.doTestSenderSettlementModeIsHonored(SenderSettleMode.MIXED);
    }

    public void doTestSenderSettlementModeIsHonored(SenderSettleMode settleMode) throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender("queue://" + this.getTestName(), settleMode, ReceiverSettleMode.FIRST);
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Assertions.assertNotNull((Object)queueView);
        Assertions.assertEquals((long)0L, (long)queueView.getMessageCount());
        Assertions.assertEquals((Object)settleMode, (Object)((Sender)sender.getEndpoint()).getRemoteSenderSettleMode());
        AmqpMessage message = new AmqpMessage();
        message.setText("Test-Message");
        sender.send(message);
        sender.close();
        connection.close();
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testReceiverSettlementModeSetToFirst() throws Exception {
        this.doTestReceiverSettlementModeForcedToFirst(ReceiverSettleMode.FIRST);
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testReceiverSettlementModeSetToSecond() throws Exception {
        this.doTestReceiverSettlementModeForcedToFirst(ReceiverSettleMode.SECOND);
    }

    private void doTestReceiverSettlementModeForcedToFirst(ReceiverSettleMode modeToUse) throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender("queue://" + this.getTestName(), SenderSettleMode.UNSETTLED, modeToUse);
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Assertions.assertNotNull((Object)queueView);
        Assertions.assertEquals((long)0L, (long)queueView.getMessageCount());
        Assertions.assertEquals((Object)ReceiverSettleMode.FIRST, (Object)((Sender)sender.getEndpoint()).getRemoteReceiverSettleMode());
        sender.close();
        connection.close();
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testUnsettledSender() throws Exception {
        int MSG_COUNT = 1000;
        final CountDownLatch settled = new CountDownLatch(1000);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        connection.setStateInspector(new AmqpValidator(){

            @Override
            public void inspectDeliveryUpdate(Sender sender, Delivery delivery) {
                if (delivery.remotelySettled()) {
                    settled.countDown();
                }
            }
        });
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName(), false);
        for (int i = 1; i <= 1000; ++i) {
            AmqpMessage message = new AmqpMessage();
            message.setText("Test-Message: " + i);
            sender.send(message);
        }
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Wait.assertTrue((String)"All messages should arrive", () -> queueView.getMessageCount() == 1000L);
        sender.close();
        Assertions.assertTrue((boolean)settled.await(5L, TimeUnit.MINUTES), (String)"Remote should have settled all deliveries");
        connection.close();
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testMixDurableAndNonDurable() throws Exception {
        int MSG_COUNT = 2000;
        ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", this.getBrokerAmqpConnectionURI().toString() + "?jms.forceAsyncSend=true");
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
        MessageProducer sender = session.createProducer((Destination)queue);
        boolean durable = false;
        for (int i = 1; i <= 2000; ++i) {
            Message message = session.createMessage();
            message.setIntProperty("i", i);
            sender.setDeliveryMode(durable ? 2 : 1);
            durable = !durable;
            sender.send(message);
        }
        connection.start();
        MessageConsumer receiver = session.createConsumer((Destination)queue);
        for (int i = 1; i <= 2000; ++i) {
            Message message = receiver.receive(10000L);
            Assertions.assertNotNull((Object)message);
            Assertions.assertEquals((int)i, (int)message.getIntProperty("i"));
        }
        Assertions.assertNull((Object)receiver.receiveNoWait());
        connection.close();
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testPresettledSender() throws Exception {
        int MSG_COUNT = 1000;
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName(), true);
        for (int i = 1; i <= 1000; ++i) {
            AmqpMessage message = new AmqpMessage();
            message.setText("Test-Message: " + i);
            sender.send(message);
        }
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Wait.assertTrue((String)"All messages should arrive", () -> queueView.getMessageCount() == 1000L);
        sender.close();
        connection.close();
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testDuplicateDetection() throws Exception {
        int MSG_COUNT = 10;
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName(), true);
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.setPresettle(true);
        receiver.flow(10);
        Assertions.assertNull((Object)receiver.receiveNoWait(), (String)"somehow the queue had messages from a previous test");
        for (int i = 1; i <= 10; ++i) {
            AmqpMessage message = new AmqpMessage();
            message.setApplicationProperty(org.apache.activemq.artemis.api.core.Message.HDR_DUPLICATE_DETECTION_ID.toString(), "123");
            sender.send(message);
        }
        AmqpMessage message = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNull((Object)receiver.receiveNoWait());
        sender.close();
        connection.close();
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testDuplicateDetectionRollback() throws Exception {
        ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
        try (Connection connection = factory.createConnection();
             Session session = connection.createSession(true, 0);){
            jakarta.jms.Queue producerQueue = session.createQueue(this.getQueueName());
            MessageProducer producer = session.createProducer((Destination)producerQueue);
            TextMessage message = session.createTextMessage("test");
            message.setStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_DUPLICATE_DETECTION_ID.toString(), "123");
            producer.send((Message)message);
            session.rollback();
            producer.send((Message)message);
            session.commit();
            connection.start();
            MessageConsumer consumer = session.createConsumer((Destination)producerQueue);
            Assertions.assertNotNull((Object)consumer.receive(5000L));
            Assertions.assertNull((Object)consumer.receiveNoWait());
            session.commit();
            Queue serverQueue = this.server.locateQueue(this.getQueueName());
            Wait.assertEquals((long)0L, () -> ((Queue)serverQueue).getMessageCount());
            message = session.createTextMessage("test");
            message.setStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_DUPLICATE_DETECTION_ID.toString(), "123");
            producer.send((Message)message);
            boolean error = false;
            try {
                session.commit();
            }
            catch (Exception e) {
                error = true;
            }
            Assertions.assertTrue((boolean)error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    @Timeout(value=60L)
    public void testSenderCreditReplenishment() throws Exception {
        final AtomicInteger counter = new AtomicInteger();
        final CountDownLatch initialCredit = new CountDownLatch(1);
        final CountDownLatch refreshedCredit = new CountDownLatch(1);
        AmqpClient client = this.createAmqpClient(this.guestPass, this.guestUser);
        client.setValidator(new AmqpValidator(){

            @Override
            public void inspectCredit(Sender sender) {
                int count = counter.incrementAndGet();
                switch (count) {
                    case 1: {
                        Assertions.assertEquals((int)1000, (int)sender.getCredit(), (String)"Unexpected initial credit");
                        initialCredit.countDown();
                        break;
                    }
                    case 2: {
                        Assertions.assertEquals((int)1000, (int)sender.getCredit(), (String)"Unexpected replenished credit");
                        refreshedCredit.countDown();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected additional flow: " + count);
                    }
                }
            }
        });
        AmqpConnection connection = this.addConnection(client.connect());
        try {
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getQueueName());
            Assertions.assertTrue((boolean)initialCredit.await(3000L, TimeUnit.MILLISECONDS), (String)"Expected credit did not arrive");
            int msgCount = 700;
            for (int i = 1; i <= 699; ++i) {
                AmqpMessage message = new AmqpMessage();
                message.setText("Test-Message: " + i);
                sender.send(message);
            }
            Assertions.assertFalse((boolean)refreshedCredit.await(50L, TimeUnit.MILLISECONDS), (String)"Expected credit not to have been refreshed yet");
            AmqpMessage message = new AmqpMessage();
            message.setText("Test-Message: 700");
            sender.send(message);
            Assertions.assertTrue((boolean)refreshedCredit.await(3000L, TimeUnit.MILLISECONDS), (String)"Expected credit refresh did not occur");
            connection.close();
        }
        finally {
            connection.getStateInspector().assertValid();
        }
    }
}

