/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSTemporaryDestinationTest
extends JMSClientTestSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testCreateTemporaryQueue() throws Throwable {
        try (Connection connection = this.createConnection();){
            Session session = connection.createSession(false, 1);
            TemporaryQueue queue = session.createTemporaryQueue();
            logger.debug("queue:{}", (Object)queue.getQueueName());
            MessageProducer producer = session.createProducer((Destination)queue);
            TextMessage message = session.createTextMessage();
            message.setText("Message temporary");
            producer.send((Message)message);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            connection.start();
            message = (TextMessage)consumer.receive(5000L);
            Assertions.assertNotNull((Object)message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testDeleteTemporaryQueue() throws Exception {
        try (Connection connection = this.createConnection();){
            Session session = connection.createSession(false, 1);
            TemporaryQueue queue = session.createTemporaryQueue();
            Assertions.assertNotNull((Object)queue);
            Assertions.assertTrue((boolean)(queue instanceof TemporaryQueue));
            Queue queueView = this.getProxyToQueue(queue.getQueueName());
            Assertions.assertNotNull((Object)queueView);
            TemporaryQueue tempQueue = queue;
            tempQueue.delete();
            Assertions.assertTrue((boolean)Wait.waitFor(() -> this.lambda$testDeleteTemporaryQueue$0((jakarta.jms.Queue)queue), (long)TimeUnit.SECONDS.toMillis(30L), (long)TimeUnit.MILLISECONDS.toMillis(50L)), (String)"Temp Queue should be deleted.");
        }
    }

    @Test
    @Timeout(value=60L)
    public void testCreateTemporaryTopic() throws Throwable {
        Connection connection = this.createConnection();
        Session session = connection.createSession(false, 1);
        TemporaryTopic topic = session.createTemporaryTopic();
        logger.debug("topic:{}", (Object)topic.getTopicName());
        MessageConsumer consumer = session.createConsumer((Destination)topic);
        MessageProducer producer = session.createProducer((Destination)topic);
        TextMessage message = session.createTextMessage();
        message.setText("Message temporary");
        producer.send((Message)message);
        connection.start();
        message = (TextMessage)consumer.receive(5000L);
        Assertions.assertNotNull((Object)message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testDeleteTemporaryTopic() throws Exception {
        try (Connection connection = this.createConnection();){
            Session session = connection.createSession(false, 1);
            TemporaryTopic topic = session.createTemporaryTopic();
            Assertions.assertNotNull((Object)topic);
            Assertions.assertTrue((boolean)(topic instanceof TemporaryTopic));
            Queue queueView = this.getProxyToQueue(topic.getTopicName());
            Assertions.assertNotNull((Object)queueView);
            TemporaryTopic tempTopic = topic;
            tempTopic.delete();
            Assertions.assertTrue((boolean)Wait.waitFor(() -> this.lambda$testDeleteTemporaryTopic$1((Topic)topic), (long)TimeUnit.SECONDS.toMillis(30L), (long)TimeUnit.MILLISECONDS.toMillis(50L)), (String)"Temp Queue should be deleted.");
        }
    }

    private /* synthetic */ boolean lambda$testDeleteTemporaryTopic$1(Topic topic) throws Exception {
        return this.getProxyToQueue(topic.getTopicName()) == null;
    }

    private /* synthetic */ boolean lambda$testDeleteTemporaryQueue$0(jakarta.jms.Queue queue) throws Exception {
        return this.getProxyToQueue(queue.getQueueName()) == null;
    }
}

