/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.apache.qpid.jms.JmsConnection;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class JMSWebSocketConnectionTest
extends JMSClientTestSupport {
    @Override
    public boolean isUseWebSockets() {
        return true;
    }

    @Test
    @Timeout(value=30L)
    public void testCreateConnectionAndStart() throws Exception {
        JmsConnectionFactory factory = new JmsConnectionFactory(this.getBrokerQpidJMSConnectionURI());
        JmsConnection connection = (JmsConnection)factory.createConnection();
        Assertions.assertNotNull((Object)connection);
        connection.start();
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testSendReceiveOverWS() throws Exception {
        JmsConnectionFactory factory = new JmsConnectionFactory(this.getBrokerQpidJMSConnectionURI());
        try (JmsConnection connection = (JmsConnection)factory.createConnection();){
            Session session = connection.createSession();
            Queue queue = session.createQueue(this.getQueueName());
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.send(session.createMessage());
            producer.close();
            connection.start();
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            Message message = consumer.receive(1000L);
            Assertions.assertNotNull((Object)message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testSendLargeMessageToClientFromOpenWire() throws Exception {
        JmsConnectionFactory factory = new JmsConnectionFactory(this.getBrokerQpidJMSConnectionURI());
        this.sendLargeMessageViaOpenWire();
        try (JmsConnection connection = (JmsConnection)factory.createConnection();){
            Session session = connection.createSession();
            Queue queue = session.createQueue(this.getQueueName());
            connection.start();
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            Message message = consumer.receive(1000L);
            Assertions.assertNotNull((Object)message);
            Assertions.assertTrue((boolean)(message instanceof BytesMessage));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Disabled(value="Broker can't accept messages over 65535 right now")
    @Test
    @Timeout(value=30L)
    public void testSendLargeMessageToClientFromAMQP() throws Exception {
        JmsConnectionFactory factory = new JmsConnectionFactory(this.getBrokerQpidJMSConnectionURI());
        this.sendLargeMessageViaAMQP();
        try (JmsConnection connection = (JmsConnection)factory.createConnection();){
            Session session = connection.createSession();
            Queue queue = session.createQueue(this.getQueueName());
            connection.start();
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            Message message = consumer.receive(1000L);
            Assertions.assertNotNull((Object)message);
            Assertions.assertTrue((boolean)(message instanceof BytesMessage));
        }
    }

    protected void sendLargeMessageViaOpenWire() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.getBrokerOpenWireConnectionURI());
        this.doSendLargeMessageViaOpenWire(factory.createConnection());
    }

    protected void sendLargeMessageViaAMQP() throws Exception {
        JmsConnectionFactory factory = new JmsConnectionFactory(this.getBrokerQpidJMSConnectionURI());
        this.doSendLargeMessageViaOpenWire(factory.createConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSendLargeMessageViaOpenWire(Connection connection) throws Exception {
        try {
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue(this.getQueueName());
            MessageProducer producer = session.createProducer((Destination)queue);
            byte[] payload = new byte[73727];
            for (int i = 0; i < payload.length; ++i) {
                payload[i] = (byte)(i % 256);
            }
            BytesMessage message = session.createBytesMessage();
            message.writeBytes(payload);
            producer.send((Message)message);
        }
        finally {
            connection.close();
        }
    }
}

