/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.connect;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionAddressType;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionElement;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.qpid.proton.amqp.transport.LinkError;
import org.apache.qpid.protonj2.test.driver.ProtonTestServer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=20L)
public class AMQPBrokerConnectionReceiverTest
extends AmqpClientTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    protected String getConfiguredProtocols() {
        return "AMQP,CORE";
    }

    @Override
    protected ActiveMQServer createServer() throws Exception {
        return this.createServer(5672, false);
    }

    @Test
    public void testBrokerConnectionCreatesReceiverOnRemote() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofReceiver().respondInKind();
            peer.expectFlow();
            peer.start();
            URI remoteURI = peer.getServerURI();
            LOG.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPBrokerConnectionElement element = new AMQPBrokerConnectionElement();
            element.setType(AMQPBrokerConnectionAddressType.RECEIVER);
            element.setName(this.getTestName());
            element.setMatchAddress("test");
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement(element);
            amqpConnection.setAutostart(true);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.createQueue(new QueueConfiguration("test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
            peer.waitForScriptToComplete();
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete();
            peer.close();
        }
    }

    @Test
    public void testIncomingMessageWithNoToFieldArrivesOnConfiguredAddress() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.start();
            URI remoteURI = peer.getServerURI();
            LOG.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPBrokerConnectionElement element = new AMQPBrokerConnectionElement();
            element.setType(AMQPBrokerConnectionAddressType.RECEIVER);
            element.setName(this.getTestName());
            element.setMatchAddress("test");
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement(element);
            amqpConnection.setAutostart(true);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withSource().withAddress("test").and().withTarget().withAddress("test").and().respondInKind();
            peer.expectFlow();
            peer.remoteTransfer().withDeliveryId(1).withBody().withString("test-body").also().queue();
            peer.expectDisposition().withState().accepted();
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                Topic topic = session.createTopic("test");
                MessageConsumer consumer = session.createConsumer((Destination)topic);
                connection.start();
                Message received = consumer.receive(5000L);
                Assertions.assertNotNull((Object)received);
                consumer.close();
            }
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete();
            peer.close();
        }
    }

    @Test
    public void testIncomingMessageWithToFieldArrivesOnConfiguredAddress() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.start();
            URI remoteURI = peer.getServerURI();
            LOG.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPBrokerConnectionElement element = new AMQPBrokerConnectionElement();
            element.setType(AMQPBrokerConnectionAddressType.RECEIVER);
            element.setName(this.getTestName());
            element.setMatchAddress("test");
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement(element);
            amqpConnection.setAutostart(true);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withSource().withAddress("test").and().withTarget().withAddress("test").and().respondInKind();
            peer.expectFlow();
            peer.remoteTransfer().withDeliveryId(1).withProperties().withTo("should-not-be-used").also().withBody().withString("test-body").also().queue();
            peer.expectDisposition().withState().accepted();
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                Topic topic = session.createTopic("test");
                MessageConsumer consumer = session.createConsumer((Destination)topic);
                connection.start();
                Message received = consumer.receive(5000L);
                Assertions.assertNotNull((Object)received);
                consumer.close();
            }
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete();
            peer.close();
        }
    }

    @Test
    public void testBrokerConnectionRetriesReceiverOnRemoteIfAttachRejected() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofReceiver().reject(true, LinkError.DETACH_FORCED.toString(), "Attach refused");
            peer.expectDetach().optional();
            peer.expectClose().optional();
            peer.expectConnectionToDrop();
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofReceiver().respondInKind();
            peer.expectFlow();
            peer.start();
            URI remoteURI = peer.getServerURI();
            LOG.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPBrokerConnectionElement element = new AMQPBrokerConnectionElement();
            element.setType(AMQPBrokerConnectionAddressType.RECEIVER);
            element.setName(this.getTestName());
            element.setMatchAddress("test");
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(10);
            amqpConnection.setRetryInterval(100);
            amqpConnection.addElement(element);
            amqpConnection.setAutostart(true);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.createQueue(new QueueConfiguration("test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
            peer.waitForScriptToComplete();
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete();
            peer.close();
        }
    }

    @Test
    public void testBrokerConnectionRetriesReceiverOnRemoteIfTargetQueueRemovedAndLaterAddedBack() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.execute(() -> {
                try {
                    this.server.createQueue(new QueueConfiguration("test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
                }
                catch (Exception e) {
                    LOG.warn("Error on creating server address and queue: ", (Throwable)e);
                }
            }).queue();
            peer.expectAttach().ofReceiver();
            peer.execute(() -> {
                try {
                    this.server.removeAddressInfo(SimpleString.of((String)"test"), null, true);
                }
                catch (Exception e) {
                    LOG.warn("Error on removing server address and queue: ", (Throwable)e);
                }
                peer.respondToLastAttach().now();
            }).queue();
            peer.expectDetach().respond();
            peer.execute(() -> {
                try {
                    this.server.createQueue(new QueueConfiguration("test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
                }
                catch (Exception e) {
                    LOG.warn("Error on creating server address and queue: ", (Throwable)e);
                }
            }).queue();
            peer.expectAttach().ofReceiver().respondInKind();
            peer.expectFlow();
            peer.start();
            URI remoteURI = peer.getServerURI();
            LOG.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPBrokerConnectionElement element = new AMQPBrokerConnectionElement();
            element.setType(AMQPBrokerConnectionAddressType.RECEIVER);
            element.setName(this.getTestName());
            element.setMatchAddress("test");
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(10);
            amqpConnection.setRetryInterval(50);
            amqpConnection.addElement(element);
            amqpConnection.setAutostart(true);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            peer.waitForScriptToComplete();
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete();
            peer.close();
        }
    }
}

