/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.connect;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPMirrorBrokerConnectionElement;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AMQPChainedReplicaTest
extends AmqpClientTestSupport {
    protected static final int AMQP_PORT_2 = 5673;
    protected static final int AMQP_PORT_3 = 5674;
    ActiveMQServer server_2;
    ActiveMQServer server_3;

    @Override
    protected ActiveMQServer createServer() throws Exception {
        return this.createServer(5672, false);
    }

    @Test
    public void testChained() throws Exception {
        TextMessage message;
        MessageConsumer consumer;
        int i;
        Session session;
        this.server_2 = this.createServer(5673, false);
        this.server_3 = this.createServer(5674, false);
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("test", "tcp://localhost:5673").setRetryInterval(100).setReconnectAttempts(-1);
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement());
        this.server.getConfiguration().addAMQPConnection(amqpConnection);
        amqpConnection = new AMQPBrokerConnectConfiguration("test", "tcp://localhost:5674").setRetryInterval(100).setReconnectAttempts(-1);
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement());
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        amqpConnection = new AMQPBrokerConnectConfiguration("test", "tcp://localhost:5672").setRetryInterval(100).setReconnectAttempts(-1);
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement());
        this.server_3.getConfiguration().addAMQPConnection(amqpConnection);
        this.server.start();
        this.server_2.start();
        this.server_3.start();
        this.createAddressAndQueues(this.server);
        Wait.assertTrue(() -> this.server.locateQueue(this.getQueueName()) != null);
        Wait.assertTrue(() -> this.server_2.locateQueue(this.getQueueName()) != null);
        Wait.assertTrue(() -> this.server_3.locateQueue(this.getQueueName()) != null);
        Queue q1 = this.server.locateQueue(this.getQueueName());
        Assertions.assertNotNull((Object)q1);
        Queue q2 = this.server.locateQueue(this.getQueueName());
        Assertions.assertNotNull((Object)q2);
        Queue q3 = this.server.locateQueue(this.getQueueName());
        Assertions.assertNotNull((Object)q3);
        ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
        ConnectionFactory factory2 = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5673");
        ConnectionFactory factory3 = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5674");
        try (Connection conn = factory.createConnection();){
            session = conn.createSession();
            MessageProducer producer = session.createProducer((Destination)session.createQueue(this.getQueueName()));
            for (i = 0; i < 40; ++i) {
                producer.send((Message)session.createTextMessage("message " + i));
            }
        }
        Thread.sleep(100L);
        Wait.assertEquals((Long)40L, () -> ((Queue)q1).getMessageCount(), (long)1000L, (long)100L);
        Wait.assertEquals((Long)40L, () -> ((Queue)q2).getMessageCount(), (long)1000L, (long)100L);
        Wait.assertEquals((Long)40L, () -> ((Queue)q3).getMessageCount(), (long)1000L, (long)100L);
        conn = factory.createConnection();
        try {
            session = conn.createSession();
            conn.start();
            consumer = session.createConsumer((Destination)session.createQueue(this.getQueueName()));
            for (i = 0; i < 10; ++i) {
                message = (TextMessage)consumer.receive(1000L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertEquals((Object)("message " + i), (Object)message.getText());
            }
            consumer.close();
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        Wait.assertEquals((Long)30L, () -> ((Queue)q1).getMessageCount(), (long)1000L, (long)100L);
        Wait.assertEquals((Long)30L, () -> ((Queue)q2).getMessageCount(), (long)1000L, (long)100L);
        Wait.assertEquals((Long)30L, () -> ((Queue)q3).getMessageCount(), (long)1000L, (long)100L);
        conn = factory2.createConnection();
        try {
            session = conn.createSession();
            conn.start();
            consumer = session.createConsumer((Destination)session.createQueue(this.getQueueName()));
            for (i = 10; i < 20; ++i) {
                message = (TextMessage)consumer.receive(1000L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertEquals((Object)("message " + i), (Object)message.getText());
            }
            consumer.close();
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        Wait.assertEquals((Long)20L, () -> ((Queue)q1).getMessageCount(), (long)1000L, (long)100L);
        Wait.assertEquals((Long)20L, () -> ((Queue)q2).getMessageCount(), (long)1000L, (long)100L);
        Wait.assertEquals((Long)20L, () -> ((Queue)q3).getMessageCount(), (long)1000L, (long)100L);
        conn = factory3.createConnection();
        try {
            session = conn.createSession();
            conn.start();
            consumer = session.createConsumer((Destination)session.createQueue(this.getQueueName()));
            for (i = 20; i < 30; ++i) {
                message = (TextMessage)consumer.receive(1000L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertEquals((Object)("message " + i), (Object)message.getText());
            }
            consumer.close();
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        Wait.assertEquals((Long)10L, () -> ((Queue)q1).getMessageCount(), (long)1000L, (long)100L);
        Wait.assertEquals((Long)10L, () -> ((Queue)q2).getMessageCount(), (long)1000L, (long)100L);
        Wait.assertEquals((Long)10L, () -> ((Queue)q3).getMessageCount(), (long)1000L, (long)100L);
        conn = factory.createConnection();
        try {
            session = conn.createSession();
            conn.start();
            consumer = session.createConsumer((Destination)session.createQueue(this.getQueueName()));
            for (i = 30; i < 40; ++i) {
                message = (TextMessage)consumer.receive(1000L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertEquals((Object)("message " + i), (Object)message.getText());
            }
            consumer.close();
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        Wait.assertEquals((Long)0L, () -> ((Queue)q1).getMessageCount(), (long)1000L, (long)100L);
        Wait.assertEquals((Long)0L, () -> ((Queue)q2).getMessageCount(), (long)1000L, (long)100L);
        Wait.assertEquals((Long)0L, () -> ((Queue)q3).getMessageCount(), (long)1000L, (long)100L);
        conn = factory.createConnection();
        try {
            session = conn.createSession();
            conn.start();
            consumer = session.createConsumer((Destination)session.createQueue(this.getQueueName()));
            Assertions.assertNull((Object)consumer.receiveNoWait());
            consumer.close();
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        conn = factory2.createConnection();
        try {
            session = conn.createSession();
            conn.start();
            consumer = session.createConsumer((Destination)session.createQueue(this.getQueueName()));
            Assertions.assertNull((Object)consumer.receiveNoWait());
            consumer.close();
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        conn = factory3.createConnection();
        try {
            session = conn.createSession();
            conn.start();
            consumer = session.createConsumer((Destination)session.createQueue(this.getQueueName()));
            Assertions.assertNull((Object)consumer.receiveNoWait());
            consumer.close();
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }
}

