/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.connect;

import io.netty.util.collection.LongObjectHashMap;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.journal.collections.JournalHashMap;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.impl.Page;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.protocol.amqp.broker.ActiveMQProtonRemotingConnection;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorControllerTarget;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AckManager;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AckManagerProvider;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.ReferenceIDSupplier;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonAbstractReceiver;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AckManagerTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    ActiveMQServer server1;
    private static final String SNF_NAME = "$ACTIVEMQ_ARTEMIS_MIRROR_other";

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server1 = this.createServer(true, this.createDefaultConfig(0, true), 100024, -1L, -1, -1);
        this.server1.getConfiguration().addAddressSetting(SNF_NAME, new AddressSettings().setMaxSizeBytes(-1L).setMaxSizeMessages(-1L).setMaxReadPageMessages(20));
        this.server1.getConfiguration().getAcceptorConfigurations().clear();
        this.server1.getConfiguration().addAcceptorConfiguration("server", "tcp://localhost:61616");
        this.server1.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDirectACK() throws Throwable {
        int i;
        String protocol = "AMQP";
        SimpleString TOPIC_NAME = SimpleString.of((String)("tp" + RandomUtil.randomString()));
        this.server1.addAddressInfo(new AddressInfo(TOPIC_NAME).addRoutingType(RoutingType.MULTICAST));
        ConnectionFactory connectionFactory = CFUtil.createConnectionFactory(protocol, "tcp://localhost:61616");
        for (int i2 = 0; i2 < 5; ++i2) {
            try (Connection connection = connectionFactory.createConnection();){
                connection.setClientID("c" + i2);
                Session session = connection.createSession(false, 1);
                Topic topic = session.createTopic(TOPIC_NAME.toString());
                session.createDurableSubscriber(topic, "s" + i2);
                continue;
            }
        }
        int numberOfMessages = 500;
        int numberOfAcksC1 = 100;
        int numberOfAcksC2 = 200;
        Queue c1s1 = this.server1.locateQueue("c1.s1");
        Assertions.assertNotNull((Object)c1s1);
        Queue c2s2 = this.server1.locateQueue("c2.s2");
        Assertions.assertNotNull((Object)c2s2);
        PagingStore store = this.server1.getPagingManager().getPageStore(TOPIC_NAME);
        store.startPaging();
        try (Connection connection = connectionFactory.createConnection();){
            Session session = connection.createSession(true, 0);
            Topic topic = session.createTopic(TOPIC_NAME.toString());
            MessageProducer producer = session.createProducer((Destination)topic);
            for (int i3 = 0; i3 < numberOfMessages; ++i3) {
                TextMessage m = session.createTextMessage("hello " + i3);
                m.setIntProperty("i", i3);
                producer.send((Message)m);
                if ((i3 + 1) % 100 != 0) continue;
                c1s1.pause();
                c2s2.pause();
                session.commit();
            }
            session.commit();
        }
        ReferenceIDSupplier referenceIDSupplier = new ReferenceIDSupplier(this.server1);
        AckManager ackManager = AckManagerProvider.getManager((ActiveMQServer)this.server1);
        AtomicInteger counter = new AtomicInteger(0);
        for (long pageID = store.getFirstPage(); pageID <= store.getCurrentWritingPage(); ++pageID) {
            Page page = store.usePage(pageID);
            try {
                page.getMessages().forEach(pagedMessage -> {
                    int increment = counter.incrementAndGet();
                    if (increment <= numberOfAcksC1) {
                        ackManager.addRetry(referenceIDSupplier.getServerID(pagedMessage.getMessage()), c1s1, referenceIDSupplier.getID(pagedMessage.getMessage()).longValue(), AckReason.NORMAL);
                    }
                    if (increment <= numberOfAcksC2) {
                        ackManager.addRetry(referenceIDSupplier.getServerID(pagedMessage.getMessage()), c2s2, referenceIDSupplier.getID(pagedMessage.getMessage()).longValue(), AckReason.NORMAL);
                    }
                });
                continue;
            }
            finally {
                page.usageDown();
            }
        }
        for (int repeat = 0; repeat < 2; ++repeat) {
            logger.info("Repeating {}", (Object)repeat);
            AckManager ackManager2 = AckManagerProvider.getManager((ActiveMQServer)this.server1);
            ackManager2.start();
            HashMap sortedRetries = ackManager2.sortRetries();
            Assertions.assertEquals((int)1, (int)sortedRetries.size());
            LongObjectHashMap acksOnAddress = (LongObjectHashMap)sortedRetries.get(c1s1.getAddress());
            Assertions.assertEquals((int)2, (int)acksOnAddress.size());
            JournalHashMap acksOnc1s1 = (JournalHashMap)acksOnAddress.get((Object)c1s1.getID());
            JournalHashMap acksOnc2s2 = (JournalHashMap)acksOnAddress.get((Object)c2s2.getID());
            Assertions.assertEquals((int)numberOfAcksC1, (int)acksOnc1s1.size());
            Assertions.assertEquals((int)numberOfAcksC2, (int)acksOnc2s2.size());
            Wait.assertEquals((long)numberOfMessages, () -> ((Queue)c1s1).getMessageCount());
            Wait.assertEquals((long)numberOfMessages, () -> ((Queue)c2s2).getMessageCount());
            AckManager originalManager = AckManagerProvider.getManager((ActiveMQServer)this.server1);
            this.server1.stop();
            Assertions.assertEquals((int)0, (int)AckManagerProvider.getSize());
            this.server1.start();
            AckManager newManager = AckManagerProvider.getManager((ActiveMQServer)this.server1);
            Assertions.assertEquals((int)1, (int)AckManagerProvider.getSize());
            Assertions.assertNotSame((Object)originalManager, (Object)AckManagerProvider.getManager((ActiveMQServer)this.server1));
            AckManager manager = AckManagerProvider.getManager((ActiveMQServer)this.server1);
            Wait.assertTrue(() -> ((AckManager)manager).isStarted(), (long)5000L);
            Assertions.assertEquals((int)1, (int)AckManagerProvider.getSize());
            Assertions.assertNotSame((Object)newManager, (Object)ackManager2);
        }
        ackManager = AckManagerProvider.getManager((ActiveMQServer)this.server1);
        ackManager.start();
        HashMap sortedRetries = ackManager.sortRetries();
        Assertions.assertEquals((int)1, (int)sortedRetries.size());
        LongObjectHashMap acksOnAddress = (LongObjectHashMap)sortedRetries.get(c1s1.getAddress());
        JournalHashMap acksOnc1s1 = (JournalHashMap)acksOnAddress.get((Object)c1s1.getID());
        JournalHashMap acksOnc2s2 = (JournalHashMap)acksOnAddress.get((Object)c2s2.getID());
        Wait.assertEquals((int)0, () -> acksOnc1s1.size());
        Wait.assertEquals((int)0, () -> acksOnc2s2.size());
        for (i = 0; i < 5; ++i) {
            AtomicInteger counter2 = new AtomicInteger(0);
            for (long pageID = store.getFirstPage(); pageID <= store.getCurrentWritingPage(); ++pageID) {
                Page page = store.usePage(pageID);
                try {
                    page.getMessages().forEach(pagedMessage -> {
                        int increment = counter2.incrementAndGet();
                        if (increment <= numberOfAcksC1) {
                            ackManager.addRetry(referenceIDSupplier.getServerID(pagedMessage.getMessage()), c1s1, referenceIDSupplier.getID(pagedMessage.getMessage()).longValue(), AckReason.NORMAL);
                        }
                        if (increment <= numberOfAcksC2) {
                            ackManager.addRetry(referenceIDSupplier.getServerID(pagedMessage.getMessage()), c2s2, referenceIDSupplier.getID(pagedMessage.getMessage()).longValue(), AckReason.NORMAL);
                        }
                    });
                    continue;
                }
                finally {
                    page.usageDown();
                }
            }
            Wait.assertEquals((int)0, () -> acksOnc1s1.size());
            Wait.assertEquals((int)0, () -> acksOnc2s2.size());
        }
        c1s1.resume();
        c2s2.resume();
        for (i = 0; i < 5; ++i) {
            try (Connection connection = connectionFactory.createConnection();){
                connection.setClientID("c" + i);
                connection.start();
                Session session = connection.createSession(false, 1);
                Topic topic = session.createTopic(TOPIC_NAME.toString());
                TopicSubscriber subscriber = session.createDurableSubscriber(topic, "s" + i);
                switch (i) {
                    case 1: {
                        int start = numberOfAcksC1;
                        break;
                    }
                    case 2: {
                        int start = numberOfAcksC2;
                        break;
                    }
                    default: {
                        int start = 0;
                    }
                }
                logger.debug("receiving messages for {}", (Object)i);
                for (int m = start; m < numberOfMessages; ++m) {
                    logger.debug("Receiving i={}, m={}", (Object)i, (Object)m);
                    TextMessage message = (TextMessage)subscriber.receive(5000L);
                    Assertions.assertNotNull((Object)message);
                    Assertions.assertEquals((Object)("hello " + m), (Object)message.getText());
                    Assertions.assertEquals((int)m, (int)message.getIntProperty("i"));
                }
                Assertions.assertNull((Object)subscriber.receiveNoWait());
                continue;
            }
        }
        this.server1.getStorageManager().getMessageJournal().scheduleCompactAndBlock(10000);
        Assertions.assertEquals((int)0, (int)this.getCounter((byte)53, this.countJournal(this.server1.getConfiguration())));
        Assertions.assertEquals((int)1, (int)AckManagerProvider.getSize());
        Queue c1s1AfterRestart = this.server1.locateQueue("c1.s1");
        Assertions.assertNotNull((Object)c1s1AfterRestart);
        ackManager.addRetry(referenceIDSupplier.getDefaultNodeID(), c1s1, 10000000L, AckReason.NORMAL);
        ackManager.addRetry(referenceIDSupplier.getDefaultNodeID(), c1s1, 10000001L, AckReason.NORMAL);
        Wait.assertTrue(() -> ackManager.sortRetries().isEmpty(), (long)5000L);
        this.server1.getStorageManager().getMessageJournal().scheduleCompactAndBlock(10000);
        Assertions.assertEquals((int)0, (int)this.getCounter((byte)53, this.countJournal(this.server1.getConfiguration())));
        this.server1.stop();
        Assertions.assertEquals((int)0, (int)AckManagerProvider.getSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRetryFromPaging() throws Throwable {
        String protocol = "AMQP";
        SimpleString TOPIC_NAME = SimpleString.of((String)("tp" + RandomUtil.randomString()));
        this.server1.addAddressInfo(new AddressInfo(TOPIC_NAME).addRoutingType(RoutingType.MULTICAST));
        ConnectionFactory connectionFactory = CFUtil.createConnectionFactory(protocol, "tcp://localhost:61616");
        for (int i = 0; i < 2; ++i) {
            try (Connection connection = connectionFactory.createConnection();){
                connection.setClientID("c" + i);
                Session session = connection.createSession(false, 1);
                Topic topic = session.createTopic(TOPIC_NAME.toString());
                session.createDurableSubscriber(topic, "s" + i);
                continue;
            }
        }
        int numberOfMessages = 15000;
        int numberOfAcksC0 = 100;
        int numberOfAcksC1 = 14999;
        String c0s0Name = "c0.s0";
        String c1s1Name = "c1.s1";
        Queue c0s0 = this.server1.locateQueue(c0s0Name);
        Assertions.assertNotNull((Object)c0s0);
        Queue c1s1 = this.server1.locateQueue(c1s1Name);
        Assertions.assertNotNull((Object)c1s1);
        PagingStore store = this.server1.getPagingManager().getPageStore(TOPIC_NAME);
        store.startPaging();
        try (Connection connection = connectionFactory.createConnection();){
            Session session = connection.createSession(true, 0);
            Topic topic = session.createTopic(TOPIC_NAME.toString());
            MessageProducer producer = session.createProducer((Destination)topic);
            for (int i = 0; i < numberOfMessages; ++i) {
                TextMessage m = session.createTextMessage("hello " + i);
                m.setIntProperty("i", i);
                producer.send((Message)m);
                if ((i + 1) % 100 != 0) continue;
                c1s1.pause();
                c0s0.pause();
                session.commit();
            }
            session.commit();
        }
        ReferenceIDSupplier referenceIDSupplier = new ReferenceIDSupplier(this.server1);
        AckManager ackManager = AckManagerProvider.getManager((ActiveMQServer)this.server1);
        ackManager.stop();
        AtomicInteger counter = new AtomicInteger(0);
        for (long pageID = store.getFirstPage(); pageID <= store.getCurrentWritingPage(); ++pageID) {
            Page page = store.usePage(pageID);
            try {
                page.getMessages().forEach(pagedMessage -> {
                    int increment = counter.incrementAndGet();
                    if (increment <= numberOfAcksC0) {
                        ackManager.addRetry(referenceIDSupplier.getServerID(pagedMessage.getMessage()), c0s0, referenceIDSupplier.getID(pagedMessage.getMessage()).longValue(), AckReason.NORMAL);
                    }
                    if (increment <= numberOfAcksC1) {
                        ackManager.addRetry(referenceIDSupplier.getServerID(pagedMessage.getMessage()), c1s1, referenceIDSupplier.getID(pagedMessage.getMessage()).longValue(), AckReason.NORMAL);
                    }
                });
                continue;
            }
            finally {
                page.usageDown();
            }
        }
        this.server1.stop();
        this.server1.start();
        Queue c0s0AfterRestart = this.server1.locateQueue(c0s0Name);
        Assertions.assertNotNull((Object)c0s0AfterRestart);
        Queue c1s1AfterRestart = this.server1.locateQueue(c1s1Name);
        Assertions.assertNotNull((Object)c1s1AfterRestart);
        Wait.assertEquals((long)(numberOfMessages - numberOfAcksC1), () -> ((Queue)c1s1AfterRestart).getMessageCount(), (long)10000L);
        Wait.assertEquals((long)numberOfAcksC1, () -> ((Queue)c1s1AfterRestart).getMessagesAcknowledged(), (long)10000L);
        Wait.assertEquals((long)(numberOfMessages - numberOfAcksC0), () -> ((Queue)c0s0AfterRestart).getMessageCount(), (long)10000L);
        Wait.assertEquals((long)numberOfAcksC0, () -> ((Queue)c0s0AfterRestart).getMessagesAcknowledged(), (long)10000L);
        this.server1.stop();
        Assertions.assertEquals((int)0, (int)AckManagerProvider.getSize());
    }

    private int getCounter(byte typeRecord, HashMap<Integer, AtomicInteger> values) {
        AtomicInteger value = values.get(typeRecord);
        if (value == null) {
            return 0;
        }
        return value.get();
    }

    protected static AMQPMirrorControllerTarget locateMirrorTarget(ActiveMQServer server) {
        ActiveMQServerImpl theServer = (ActiveMQServerImpl)server;
        for (RemotingConnection connection : theServer.getRemotingService().getConnections()) {
            if (!(connection instanceof ActiveMQProtonRemotingConnection)) continue;
            ActiveMQProtonRemotingConnection protonRC = (ActiveMQProtonRemotingConnection)connection;
            for (AMQPSessionContext sessionContext : protonRC.getAmqpConnection().getSessions().values()) {
                for (ProtonAbstractReceiver receiver : sessionContext.getReceivers().values()) {
                    if (!(receiver instanceof AMQPMirrorControllerTarget)) continue;
                    return (AMQPMirrorControllerTarget)receiver;
                }
            }
        }
        return null;
    }

    private int acksCount(File countJournalLocation) throws Exception {
        HashMap<Integer, AtomicInteger> countJournal = this.countJournal(countJournalLocation, 0xA00000, 2, 2);
        AtomicInteger acksCount = countJournal.get(39);
        return acksCount != null ? acksCount.get() : 0;
    }
}

