/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.interop;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.jms.client.ActiveMQSession;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.apache.qpid.jms.JmsTopic;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpCoreTest
extends JMSClientTestSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    protected String getConfiguredProtocols() {
        return "AMQP,OPENWIRE,CORE";
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testMultipleCoreReceiving() throws Exception {
        int total = 100;
        try (Connection coreJmsConn = this.createCoreConnection();){
            Session session = coreJmsConn.createSession(false, 1);
            ClientSession coreSession = ((ActiveMQSession)session).getCoreSession();
            coreSession.createQueue(QueueConfiguration.of((String)"exampleQueue1").setAddress("exampleQueueAddress"));
            coreSession.createQueue(QueueConfiguration.of((String)"exampleQueue2").setAddress("exampleQueueAddress"));
            coreSession.createQueue(QueueConfiguration.of((String)"exampleQueue3").setAddress("exampleQueueAddress"));
            ClientConsumer consumer1 = coreSession.createConsumer("exampleQueue1");
            CoreMessageHandler handler1 = new CoreMessageHandler(1);
            consumer1.setMessageHandler((MessageHandler)handler1);
            ClientConsumer consumer2 = coreSession.createConsumer("exampleQueue2");
            CoreMessageHandler handler2 = new CoreMessageHandler(2);
            consumer2.setMessageHandler((MessageHandler)handler2);
            CoreMessageHandler handler3 = new CoreMessageHandler(3);
            ClientConsumer consumer3 = coreSession.createConsumer("exampleQueue3");
            consumer3.setMessageHandler((MessageHandler)handler3);
            this.sendAmqpMessages("exampleQueueAddress", 100);
            handler1.assertMessagesReceived(100);
            handler2.assertMessagesReceived(100);
            handler3.assertMessagesReceived(100);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testAmqpFailedConversionFromCore() throws Exception {
        SimpleString message = RandomUtil.randomSimpleString();
        Connection coreJmsConn = this.createCoreConnection();
        JmsConnectionFactory cfAMQP = new JmsConnectionFactory("amqp://127.0.0.1:5672");
        Connection connectionAMQP = cfAMQP.createConnection();
        try {
            connectionAMQP.start();
            Session sessionAMQP = connectionAMQP.createSession(false, 1);
            Queue destination = sessionAMQP.createQueue(this.getQueueName());
            MessageConsumer consumer = sessionAMQP.createConsumer((Destination)destination);
            Session session = coreJmsConn.createSession(false, 1);
            ClientSession coreSession = ((ActiveMQSession)session).getCoreSession();
            ClientProducer producer = coreSession.createProducer(this.getQueueName());
            ClientMessage m = coreSession.createMessage(true);
            m.setType((byte)3);
            m.getBodyBuffer().writeBytes(message.getData());
            producer.send((org.apache.activemq.artemis.api.core.Message)m);
            Wait.assertEquals((Long)1L, () -> this.server.locateQueue(this.getDeadLetterAddress()).getMessageCount(), (long)2000L, (long)100L);
            m = coreSession.createMessage(true);
            m.setType((byte)3);
            m.getBodyBuffer().writeNullableSimpleString(message);
            producer.send((org.apache.activemq.artemis.api.core.Message)m);
            Assertions.assertNotNull((Object)consumer.receive(500L));
        }
        finally {
            coreJmsConn.close();
            connectionAMQP.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAmqpMessages(String address, int total) throws Exception {
        JmsConnectionFactory cfAMQP = new JmsConnectionFactory("amqp://127.0.0.1:5672");
        try (Connection connectionAMQP = cfAMQP.createConnection();){
            connectionAMQP.start();
            Session sessionAMQP = connectionAMQP.createSession(false, 1);
            MessageProducer sender = sessionAMQP.createProducer((Destination)new JmsTopic(address));
            for (int i = 0; i < total; ++i) {
                sender.send((Message)sessionAMQP.createTextMessage("hello"));
            }
        }
    }

    private class CoreMessageHandler
    implements MessageHandler {
        int id;
        AtomicInteger numMsg = new AtomicInteger();
        AtomicBoolean zeroLen = new AtomicBoolean();

        CoreMessageHandler(int id) {
            this.id = id;
        }

        public void onMessage(ClientMessage message) {
            logger.debug("received: {}", (Object)message.getBodySize());
            if (message.getBodySize() == 0) {
                logger.debug("xxx found zero len message!");
                this.zeroLen.set(true);
            }
            logger.debug("[receiver {}] recieved: {}", (Object)this.id, (Object)this.numMsg.incrementAndGet());
        }

        public void assertMessagesReceived(int num) throws Exception {
            Wait.assertEquals((int)num, this.numMsg::get, (long)30000L);
            Assertions.assertFalse((boolean)this.zeroLen.get());
        }
    }
}

