/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import io.netty.util.internal.PlatformDependent;
import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.Deflater;
import javax.management.openmbean.CompositeData;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.management.impl.QueueControlImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.integration.client.LargeMessageTest;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class LargeMessageCompressTest
extends LargeMessageTest {
    public LargeMessageCompressTest(StoreConfiguration.StoreType storeType) {
        super(storeType);
        this.isCompressedTest = true;
    }

    @Override
    protected void validateLargeMessageComplete(ActiveMQServer server) throws Exception {
    }

    @Override
    protected boolean isNetty() {
        return false;
    }

    @Override
    protected ServerLocator createFactory(boolean isNetty) throws Exception {
        return super.createFactory(isNetty).setCompressLargeMessage(true);
    }

    @Override
    @TestTemplate
    @Disabled
    public void testDeleteUnreferencedMessage() {
    }

    @TestTemplate
    public void testLargeMessageCompressionNotCompressedAndBrowsed() throws Exception {
        int messageSize = 358400;
        ActiveMQServer server = this.createServer(true, this.isNetty());
        server.start();
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(sf.createSession(false, false, false));
        session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS).setAddress(this.ADDRESS).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        ClientMessage clientFile = this.createLargeClientMessageStreaming(session, 358400L, true);
        clientFile.setType((byte)3);
        producer.send((org.apache.activemq.artemis.api.core.Message)clientFile);
        session.commit();
        session.close();
        QueueControlImpl queueControl = (QueueControlImpl)server.getManagementService().getResource("queue.SimpleAddress");
        CompositeData[] browse = queueControl.browse();
        Assertions.assertNotNull((Object)browse);
        Assertions.assertEquals((int)browse.length, (int)1);
        Assertions.assertEquals((Object)browse[0].get("text"), (Object)"[compressed]");
        session = this.addClientSession(sf.createSession(false, false, false));
        session.start();
        ClientConsumer consumer = session.createConsumer(this.ADDRESS);
        ClientMessage msg1 = consumer.receive(1000L);
        Assertions.assertNotNull((Object)msg1);
        for (int i = 0; i < 358400; ++i) {
            byte b = msg1.getBodyBuffer().readByte();
            Assertions.assertEquals((byte)LargeMessageCompressTest.getSamplebyte(i), (byte)b, (String)("position = " + i));
        }
        msg1.acknowledge();
        session.commit();
        consumer.close();
        session.close();
        this.validateNoFilesOnLargeDir();
    }

    @TestTemplate
    public void testNoDirectByteBufLeaksOnLargeMessageCompression() throws Exception {
        Assumptions.assumeTrue((PlatformDependent.usedDirectMemory() != -1L ? 1 : 0) != 0);
        int messageSize = 358400;
        ActiveMQServer server = this.createServer(true, this.isNetty());
        server.start();
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(sf.createSession(false, false, false));
        session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS).setAddress(this.ADDRESS).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        ClientMessage clientFile = this.createLargeClientMessageStreaming(session, 358400L, true);
        producer.send((org.apache.activemq.artemis.api.core.Message)clientFile);
        session.commit();
        session.start();
        ClientConsumer consumer = session.createConsumer(this.ADDRESS);
        long usedDirectMemoryBeforeReceive = PlatformDependent.usedDirectMemory();
        ClientMessage msg1 = consumer.receive(1000L);
        Assertions.assertNotNull((Object)msg1);
        long usedDirectMemoryAfterReceive = PlatformDependent.usedDirectMemory();
        Assertions.assertEquals((long)usedDirectMemoryBeforeReceive, (long)usedDirectMemoryAfterReceive, (String)"large message compression is leaking some Netty direct ByteBuff");
        msg1.acknowledge();
        session.commit();
        consumer.close();
        session.close();
    }

    @TestTemplate
    public void testLargeMessageCompression() throws Exception {
        int messageSize = 358400;
        ActiveMQServer server = this.createServer(true, this.isNetty());
        server.start();
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(sf.createSession(false, false, false));
        session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS).setAddress(this.ADDRESS).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        ClientMessage clientFile = this.createLargeClientMessageStreaming(session, 358400L, true);
        producer.send((org.apache.activemq.artemis.api.core.Message)clientFile);
        session.commit();
        session.start();
        ClientConsumer consumer = session.createConsumer(this.ADDRESS);
        ClientMessage msg1 = consumer.receive(1000L);
        Assertions.assertNotNull((Object)msg1);
        for (int i = 0; i < 358400; ++i) {
            byte b = msg1.getBodyBuffer().readByte();
            Assertions.assertEquals((byte)LargeMessageCompressTest.getSamplebyte(i), (byte)b, (String)("position = " + i));
        }
        msg1.acknowledge();
        session.commit();
        consumer.close();
        session.close();
        this.validateNoFilesOnLargeDir();
    }

    @TestTemplate
    public void testLargeMessageCompression2() throws Exception {
        int messageSize = 358400;
        ActiveMQServer server = this.createServer(true, this.isNetty());
        server.start();
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(sf.createSession(false, false, false));
        session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS).setAddress(this.ADDRESS).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        ClientMessage clientFile = this.createLargeClientMessageStreaming(session, 358400L, true);
        producer.send((org.apache.activemq.artemis.api.core.Message)clientFile);
        session.commit();
        session.start();
        ClientConsumer consumer = session.createConsumer(this.ADDRESS);
        ClientMessage msg1 = consumer.receive(1000L);
        Assertions.assertNotNull((Object)msg1);
        String testDir = this.getTestDir();
        File testFile = new File(testDir, "async_large_message");
        FileOutputStream output = new FileOutputStream(testFile);
        msg1.setOutputStream((OutputStream)output);
        msg1.waitOutputStreamCompletion(0L);
        msg1.acknowledge();
        output.close();
        session.commit();
        consumer.close();
        session.close();
        FileInputStream input = new FileInputStream(testFile);
        for (int i = 0; i < 358400; ++i) {
            byte b = (byte)input.read();
            Assertions.assertEquals((byte)LargeMessageCompressTest.getSamplebyte(i), (byte)b, (String)("position = " + i));
        }
        input.close();
        testFile.delete();
        this.validateNoFilesOnLargeDir();
    }

    @TestTemplate
    public void testLargeMessageCompression3() throws Exception {
        int messageSize = 358400;
        ActiveMQServer server = this.createServer(true, this.isNetty());
        server.start();
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(sf.createSession(false, false, false));
        session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS).setAddress(this.ADDRESS).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        ClientMessage clientFile = this.createLargeClientMessageStreaming(session, 358400L, true);
        producer.send((org.apache.activemq.artemis.api.core.Message)clientFile);
        session.commit();
        session.start();
        ClientConsumer consumer = session.createConsumer(this.ADDRESS);
        ClientMessage msg1 = consumer.receive(1000L);
        Assertions.assertNotNull((Object)msg1);
        String testDir = this.getTestDir();
        File testFile = new File(testDir, "async_large_message");
        FileOutputStream output = new FileOutputStream(testFile);
        msg1.saveToOutputStream((OutputStream)output);
        msg1.acknowledge();
        output.close();
        session.commit();
        consumer.close();
        session.close();
        FileInputStream input = new FileInputStream(testFile);
        for (int i = 0; i < 358400; ++i) {
            byte b = (byte)input.read();
            Assertions.assertEquals((byte)LargeMessageCompressTest.getSamplebyte(i), (byte)b, (String)("position = " + i));
        }
        input.close();
        testFile.delete();
        this.validateNoFilesOnLargeDir();
    }

    @TestTemplate
    public void testHugeStreamingSpacesCompressed() throws Exception {
        long messageSize = 0x100000L;
        ActiveMQServer server = this.createServer(true, this.isNetty());
        server.start();
        this.locator.setMinLargeMessageSize(0x6400000);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(sf.createSession(false, false, false));
        session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        ClientMessage clientMessage = session.createMessage(true);
        clientMessage.setBodyInputStream(new InputStream(){
            private long count;
            private boolean closed = false;

            @Override
            public void close() throws IOException {
                super.close();
                this.closed = true;
            }

            @Override
            public int read() throws IOException {
                if (this.closed) {
                    throw new IOException("Stream was closed");
                }
                if (this.count++ < 0x100000L) {
                    return 32;
                }
                return -1;
            }
        });
        producer.send((org.apache.activemq.artemis.api.core.Message)clientMessage);
        session.commit();
        this.validateNoFilesOnLargeDir();
        session.start();
        ClientConsumer consumer = session.createConsumer(this.ADDRESS);
        ClientMessage msg1 = consumer.receive(1000L);
        Assertions.assertNotNull((Object)msg1);
        final AtomicLong numberOfSpaces = new AtomicLong();
        msg1.saveToOutputStream(new OutputStream(){

            @Override
            public void write(int content) {
                if (content == 32) {
                    numberOfSpaces.incrementAndGet();
                }
            }
        });
        Assertions.assertEquals((long)0x100000L, (long)numberOfSpaces.get());
        msg1.acknowledge();
        session.commit();
        session.close();
    }

    @TestTemplate
    public void testLargeMessageCompressionRestartAndCheckSize() throws Exception {
        int messageSize = 0x100000;
        ActiveMQServer server = this.createServer(true, this.isNetty());
        server.start();
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(sf.createSession(false, false, false));
        session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        byte[] msgs = new byte[0x100000];
        for (int i = 0; i < msgs.length; ++i) {
            msgs[i] = RandomUtil.randomByte();
        }
        ClientMessage clientFile = this.createLargeClientMessage(session, msgs, true);
        producer.send((org.apache.activemq.artemis.api.core.Message)clientFile);
        session.commit();
        session.close();
        sf.close();
        this.locator.close();
        server.stop();
        server = this.createServer(true, this.isNetty());
        server.start();
        this.locator = this.createFactory(this.isNetty());
        sf = this.createSessionFactory(this.locator);
        session = sf.createSession();
        session.start();
        ClientConsumer consumer = session.createConsumer(this.ADDRESS);
        ClientMessage msg1 = consumer.receive(1000L);
        Assertions.assertNotNull((Object)msg1);
        Assertions.assertEquals((int)0x100000, (int)msg1.getBodySize());
        String testDir = this.getTestDir();
        File testFile = new File(testDir, "async_large_message");
        FileOutputStream output = new FileOutputStream(testFile);
        msg1.saveToOutputStream((OutputStream)output);
        msg1.acknowledge();
        session.commit();
        consumer.close();
        session.close();
        FileInputStream input = new FileInputStream(testFile);
        for (int i = 0; i < 0x100000; ++i) {
            byte b = (byte)input.read();
            Assertions.assertEquals((byte)msgs[i], (byte)b, (String)("position = " + i));
        }
        input.close();
        testFile.delete();
        this.validateNoFilesOnLargeDir();
    }

    @TestTemplate
    public void testPreviouslyCompressedMessageCleanup() throws Exception {
        int messageSize = 0x100000;
        byte[] payload = new byte[0x100000];
        byte[] response = new byte[0x100000];
        ActiveMQServer server = this.createServer(true, this.isNetty());
        server.start();
        server.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS).setRoutingType(RoutingType.ANYCAST));
        for (int i = 0; i < payload.length; ++i) {
            payload[i] = RandomUtil.randomByte();
        }
        try (ClientSessionFactory sf = this.locator.createSessionFactory();
             ClientSession session = sf.createSession(true, true);
             ClientProducer producer = session.createProducer(this.ADDRESS);){
            ClientMessage message = session.createMessage(true);
            message.getBodyBuffer().writeBytes(payload);
            Assertions.assertNull((Object)message.getAnnotation(org.apache.activemq.artemis.api.core.Message.HDR_LARGE_COMPRESSED));
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        ServerLocator locator2 = this.createFactory(this.isNetty());
        locator2.setCompressLargeMessage(false);
        locator2.setMinLargeMessageSize(1024);
        try (ClientSessionFactory sf = locator2.createSessionFactory();
             ClientSession session = sf.createSession(true, true);
             ClientConsumer consumer = session.createConsumer(this.ADDRESS);
             ClientProducer producer = session.createProducer(this.ADDRESS);){
            ClientMessage message = session.createMessage(true);
            ICoreMessage serverMessage = ((MessageReference)server.locateQueue(this.ADDRESS).browserIterator().next()).getMessage().copy().toCore();
            message.moveHeadersAndProperties((org.apache.activemq.artemis.api.core.Message)serverMessage);
            message.getBodyBuffer().writeBytes(serverMessage.getReadOnlyBodyBuffer(), serverMessage.getBodyBufferSize());
            Assertions.assertTrue((boolean)message.getBooleanProperty(org.apache.activemq.artemis.api.core.Message.HDR_LARGE_COMPRESSED));
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            session.start();
            for (int i = 0; i < 2; ++i) {
                message = consumer.receive(2000L);
                Assertions.assertNotNull((Object)message);
                message.getBodyBuffer().readBytes(response);
                Assertions.assertTrue((boolean)Arrays.equals(payload, response));
                message.acknowledge();
            }
        }
        locator2.close();
    }

    @TestTemplate
    public void testLargeMessageCompressionLevel() throws Exception {
        SimpleString address1 = SimpleString.of((String)"address1");
        SimpleString address2 = SimpleString.of((String)"address2");
        SimpleString address3 = SimpleString.of((String)"address3");
        ActiveMQServer server = this.createServer(true, true);
        server.start();
        ServerLocator locator1 = ActiveMQClient.createServerLocator((String)"tcp://localhost:61616?compressionLevel=1");
        ServerLocator locator2 = ActiveMQClient.createServerLocator((String)"vm://0?compressionLevel=5");
        ServerLocator locator3 = ActiveMQClient.createServerLocator((String)"vm://0");
        locator1.setCompressLargeMessage(true);
        locator2.setCompressLargeMessage(true);
        locator3.setCompressLargeMessage(true);
        locator3.setCompressionLevel(9);
        ClientSessionFactory sf1 = locator1.createSessionFactory();
        ClientSessionFactory sf2 = locator2.createSessionFactory();
        ClientSessionFactory sf3 = locator3.createSessionFactory();
        ClientSession session1 = sf1.createSession(false, true, true);
        ClientSession session2 = sf2.createSession(false, true, true);
        ClientSession session3 = sf3.createSession(false, true, true);
        ClientProducer producer1 = session1.createProducer(address1);
        ClientProducer producer2 = session2.createProducer(address2);
        ClientProducer producer3 = session3.createProducer(address3);
        session1.createQueue(QueueConfiguration.of((SimpleString)address1));
        session2.createQueue(QueueConfiguration.of((SimpleString)address2));
        session3.createQueue(QueueConfiguration.of((SimpleString)address3));
        Object inputString = "blahblahblah??blahblahblahblahblah??blablahblah??blablahblah??bla";
        for (int i = 0; i < 20; ++i) {
            inputString = (String)inputString + (String)inputString;
        }
        ClientMessage message = session1.createMessage(true);
        message.getBodyBuffer().writeString((String)inputString);
        producer1.send((org.apache.activemq.artemis.api.core.Message)message);
        producer2.send((org.apache.activemq.artemis.api.core.Message)message);
        producer3.send((org.apache.activemq.artemis.api.core.Message)message);
        QueueControl queueControl1 = (QueueControl)server.getManagementService().getResource("queue." + address1);
        QueueControl queueControl2 = (QueueControl)server.getManagementService().getResource("queue." + address2);
        QueueControl queueControl3 = (QueueControl)server.getManagementService().getResource("queue." + address3);
        Assertions.assertTrue((1L == queueControl1.getMessageCount() ? 1 : 0) != 0);
        Assertions.assertTrue((1L == queueControl2.getMessageCount() ? 1 : 0) != 0);
        Assertions.assertTrue((1L == queueControl3.getMessageCount() ? 1 : 0) != 0);
        Assertions.assertTrue((message.getPersistentSize() > queueControl1.getPersistentSize() ? 1 : 0) != 0);
        Assertions.assertTrue((queueControl1.getPersistentSize() > queueControl2.getPersistentSize() ? 1 : 0) != 0);
        Assertions.assertTrue((queueControl2.getPersistentSize() > queueControl3.getPersistentSize() ? 1 : 0) != 0);
        sf1.close();
        sf2.close();
        sf3.close();
        locator1.close();
        locator2.close();
        locator3.close();
    }

    @Override
    @Disabled
    @TestTemplate
    public void testSendServerMessage() throws Exception {
    }

    @TestTemplate
    public void testOverrideSize() throws Exception {
        ActiveMQServer server = this.createServer(true, true);
        server.start();
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("tcp://localhost:61616?minLargeMessageSize=204800&compressLargeMessage=true");
        Connection connection = cf.createConnection();
        Session session = connection.createSession(false, 1);
        connection.start();
        Queue queue = session.createQueue("testQueue");
        MessageProducer producer = session.createProducer((Destination)queue);
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        byte[] data = new byte[307200];
        new DeflateGenerator(new Random(42L), 2.0, 2.0).generate(data, 2.0);
        this.assertCompressionSize(data, 102400, 204800);
        BytesMessage outMessage = session.createBytesMessage();
        outMessage.writeBytes(data);
        producer.send((Message)outMessage);
        Message inMessage = consumer.receive(1000L);
        LargeMessageCompressTest.assertEqualsByteArrays(data, (byte[])inMessage.getBody(byte[].class));
    }

    private void assertCompressionSize(byte[] data, int min, int max) {
        byte[] output = new byte[data.length];
        Deflater deflater = new Deflater();
        deflater.setInput(data);
        deflater.finish();
        int compressed = deflater.deflate(output);
        deflater.end();
        Assertions.assertTrue((compressed > min ? 1 : 0) != 0);
        Assertions.assertTrue((compressed < max ? 1 : 0) != 0);
    }

    public static class DeflateGenerator {
        private static final int MIN_LENGTH = 3;
        private static final int MAX_LENGTH = 258;
        private static final int NUM_LENGTH = 255;
        private static final int LENGTH_PER_CHUNK = 512;
        private final Random rnd;
        private final double dataExp;
        private final double lengthExp;

        public DeflateGenerator(Random rnd, double dataExp, double lengthExp) {
            this.rnd = rnd;
            this.dataExp = dataExp;
            this.lengthExp = lengthExp;
        }

        private void nextBytes(byte[] buffer, int size) {
            for (int i = 0; i < size; ++i) {
                buffer[i] = (byte)(256.0 * Math.pow(this.rnd.nextDouble(), this.dataExp));
            }
        }

        private byte[] nextBytes(int size) {
            byte[] buffer = new byte[size];
            this.nextBytes(buffer, size);
            return buffer;
        }

        private void nextLengthFrequencies(int[] frequencies) {
            Arrays.fill(frequencies, 0);
            for (int i = 0; i < 512; ++i) {
                int length;
                int n = length = (int)((double)frequencies.length * Math.pow(this.rnd.nextDouble(), this.lengthExp));
                frequencies[n] = frequencies[n] + 1;
            }
        }

        public void generate(byte[] result, double ratio) {
            ByteBuffer generated = this.generate(result.length, ratio);
            generated.get(result);
        }

        public ByteBuffer generate(int size, double ratio) {
            int len;
            ByteBuffer result = ByteBuffer.allocate(size);
            byte[] buffer = new byte[258];
            int[] frequencies = new int[255];
            int length = 0;
            boolean repeat = false;
            for (int i = 0; i < size; i += len) {
                while (frequencies[length] == 0) {
                    if (length == 0) {
                        this.nextBytes(buffer, 258);
                        this.nextLengthFrequencies(frequencies);
                        length = 255;
                    }
                    --length;
                }
                len = length + 3;
                int n = length;
                frequencies[n] = frequencies[n] - 1;
                if (len > size - i) {
                    len = size - i;
                }
                if (this.rnd.nextDouble() < 1.0 / ratio) {
                    result.put(this.nextBytes(len));
                    repeat = false;
                    continue;
                }
                if (repeat) {
                    result.put(this.nextBytes(1));
                    ++i;
                }
                result.put(buffer, 0, len);
                repeat = true;
            }
            return result.flip();
        }
    }
}

