/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MessageGroupingConnectionFactoryTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private ClientSession clientSession;
    private final SimpleString qName = SimpleString.of((String)"MessageGroupingTestQueue");

    @Test
    public void testBasicGroupingUsingConnection() throws Exception {
        this.doTestBasicGroupingUsingConnectionFactory();
    }

    @Test
    public void testBasicGroupingMultipleProducers() throws Exception {
        this.doTestBasicGroupingMultipleProducers();
    }

    private void doTestBasicGroupingUsingConnectionFactory() throws Exception {
        ClientProducer clientProducer = this.clientSession.createProducer(this.qName);
        ClientConsumer consumer = this.clientSession.createConsumer(this.qName);
        ClientConsumer consumer2 = this.clientSession.createConsumer(this.qName);
        this.clientSession.start();
        int numMessages = 100;
        for (int i = 0; i < numMessages; ++i) {
            ClientMessage message = this.createTextMessage(this.clientSession, "m" + i);
            clientProducer.send((Message)message);
        }
        CountDownLatch latch = new CountDownLatch(numMessages);
        DummyMessageHandler dummyMessageHandler = new DummyMessageHandler(latch, true);
        consumer.setMessageHandler((MessageHandler)dummyMessageHandler);
        DummyMessageHandler dummyMessageHandler2 = new DummyMessageHandler(latch, true);
        consumer2.setMessageHandler((MessageHandler)dummyMessageHandler2);
        Assertions.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        Assertions.assertEquals((int)100, (int)dummyMessageHandler.list.size());
        Assertions.assertEquals((int)0, (int)dummyMessageHandler2.list.size());
        consumer.close();
        consumer2.close();
    }

    private void doTestBasicGroupingMultipleProducers() throws Exception {
        ClientProducer clientProducer = this.clientSession.createProducer(this.qName);
        ClientProducer clientProducer2 = this.clientSession.createProducer(this.qName);
        ClientProducer clientProducer3 = this.clientSession.createProducer(this.qName);
        ClientConsumer consumer = this.clientSession.createConsumer(this.qName);
        ClientConsumer consumer2 = this.clientSession.createConsumer(this.qName);
        this.clientSession.start();
        int numMessages = 100;
        for (int i = 0; i < numMessages; ++i) {
            ClientMessage message = this.createTextMessage(this.clientSession, "m" + i);
            clientProducer.send((Message)message);
            clientProducer2.send((Message)message);
            clientProducer3.send((Message)message);
        }
        CountDownLatch latch = new CountDownLatch(numMessages * 3);
        DummyMessageHandler dummyMessageHandler = new DummyMessageHandler(latch, true);
        consumer.setMessageHandler((MessageHandler)dummyMessageHandler);
        DummyMessageHandler dummyMessageHandler2 = new DummyMessageHandler(latch, true);
        consumer2.setMessageHandler((MessageHandler)dummyMessageHandler2);
        Assertions.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        Assertions.assertEquals((int)300, (int)dummyMessageHandler.list.size());
        Assertions.assertEquals((int)0, (int)dummyMessageHandler2.list.size());
        consumer.close();
        consumer2.close();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig(), (boolean)false));
        this.server.start();
        ServerLocator locator = this.createInVMNonHALocator().setGroupID("grp1");
        ClientSessionFactory sessionFactory = this.createSessionFactory(locator);
        this.clientSession = this.addClientSession(sessionFactory.createSession(false, true, true));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)this.qName).setDurable(Boolean.valueOf(false)));
    }

    private static class DummyMessageHandler
    implements MessageHandler {
        ArrayList<ClientMessage> list = new ArrayList();
        private final CountDownLatch latch;
        private final boolean acknowledge;

        private DummyMessageHandler(CountDownLatch latch, boolean acknowledge) {
            this.latch = latch;
            this.acknowledge = acknowledge;
        }

        public void onMessage(ClientMessage message) {
            this.list.add(message);
            if (this.acknowledge) {
                try {
                    message.acknowledge();
                }
                catch (ActiveMQException activeMQException) {
                    // empty catch block
                }
            }
            this.latch.countDown();
        }
    }
}

