/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class WildCardRoutingTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private ServerLocator locator;
    private ClientSession clientSession;
    private ClientSessionFactory sf;

    @Test
    public void testBasicWildcardRouting() throws Exception {
        SimpleString addressAB = SimpleString.of((String)"a.b");
        SimpleString addressAC = SimpleString.of((String)"a.c");
        SimpleString address = SimpleString.of((String)"a.*");
        SimpleString queueName1 = SimpleString.of((String)"Q1");
        SimpleString queueName2 = SimpleString.of((String)"Q2");
        SimpleString queueName = SimpleString.of((String)"Q");
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m2", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
    }

    @Test
    public void testBasicWildcardRoutingQueuesDontExist() throws Exception {
        SimpleString addressAB = SimpleString.of((String)"a.b");
        SimpleString addressAC = SimpleString.of((String)"a.c");
        SimpleString address = SimpleString.of((String)"a.*");
        SimpleString queueName = SimpleString.of((String)"Q");
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m2", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
        clientConsumer.close();
        this.clientSession.deleteQueue(queueName);
        Assertions.assertEquals((int)0, (int)this.server.getPostOffice().getBindingsForAddress(addressAB).getBindings().size());
        Assertions.assertEquals((int)0, (int)this.server.getPostOffice().getBindingsForAddress(addressAC).getBindings().size());
        Assertions.assertEquals((int)0, (int)this.server.getPostOffice().getBindingsForAddress(address).getBindings().size());
    }

    @Test
    public void testBasicWildcardRoutingQueuesDontExist2() throws Exception {
        SimpleString addressAB = SimpleString.of((String)"a.b");
        SimpleString addressAC = SimpleString.of((String)"a.c");
        SimpleString address = SimpleString.of((String)"a.*");
        SimpleString queueName = SimpleString.of((String)"Q");
        SimpleString queueName2 = SimpleString.of((String)"Q2");
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName2).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m2", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
        clientConsumer.close();
        this.clientSession.deleteQueue(queueName);
        Assertions.assertEquals((int)1, (int)this.server.getPostOffice().getBindingsForAddress(addressAB).getBindings().size());
        Assertions.assertEquals((int)1, (int)this.server.getPostOffice().getBindingsForAddress(addressAC).getBindings().size());
        Assertions.assertEquals((int)1, (int)this.server.getPostOffice().getBindingsForAddress(address).getBindings().size());
        this.clientSession.deleteQueue(queueName2);
        Assertions.assertEquals((int)0, (int)this.server.getPostOffice().getBindingsForAddress(addressAB).getBindings().size());
        Assertions.assertEquals((int)0, (int)this.server.getPostOffice().getBindingsForAddress(addressAC).getBindings().size());
        Assertions.assertEquals((int)0, (int)this.server.getPostOffice().getBindingsForAddress(address).getBindings().size());
    }

    @Test
    public void testBasicWildcardRoutingWithHash() throws Exception {
        SimpleString addressAB = SimpleString.of((String)"a.b");
        SimpleString addressAC = SimpleString.of((String)"a.c");
        SimpleString address = SimpleString.of((String)"a.#");
        SimpleString queueName1 = SimpleString.of((String)"Q1");
        SimpleString queueName2 = SimpleString.of((String)"Q2");
        SimpleString queueName = SimpleString.of((String)"Q");
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m2", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
    }

    @Test
    public void testWildcardRoutingQueuesAddedAfter() throws Exception {
        SimpleString addressAB = SimpleString.of((String)"a.b");
        SimpleString addressAC = SimpleString.of((String)"a.c");
        SimpleString address = SimpleString.of((String)"a.*");
        SimpleString queueName1 = SimpleString.of((String)"Q1");
        SimpleString queueName2 = SimpleString.of((String)"Q2");
        SimpleString queueName = SimpleString.of((String)"Q");
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.start();
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m2", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
    }

    @Test
    public void testWildcardRoutingQueuesAddedThenDeleted() throws Exception {
        SimpleString addressAB = SimpleString.of((String)"a.b");
        SimpleString addressAC = SimpleString.of((String)"a.c");
        SimpleString address = SimpleString.of((String)"a.*");
        SimpleString queueName1 = SimpleString.of((String)"Q1");
        SimpleString queueName2 = SimpleString.of((String)"Q2");
        SimpleString queueName = SimpleString.of((String)"Q");
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        this.clientSession.deleteQueue(queueName1);
        Assertions.assertEquals((int)this.server.getPostOffice().getBindingsForAddress(addressAB).getBindings().size(), (int)1);
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m2", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        clientConsumer.close();
        this.clientSession.deleteQueue(queueName);
        Assertions.assertEquals((int)this.server.getPostOffice().getBindingsForAddress(addressAB).getBindings().size(), (int)0);
    }

    @Test
    public void testWildcardRoutingLotsOfQueuesAddedThenDeleted() throws Exception {
        SimpleString addressAB = SimpleString.of((String)"a.b");
        SimpleString addressAC = SimpleString.of((String)"a.c");
        SimpleString addressAD = SimpleString.of((String)"a.d");
        SimpleString addressAE = SimpleString.of((String)"a.e");
        SimpleString addressAF = SimpleString.of((String)"a.f");
        SimpleString addressAG = SimpleString.of((String)"a.g");
        SimpleString addressAH = SimpleString.of((String)"a.h");
        SimpleString addressAJ = SimpleString.of((String)"a.j");
        SimpleString addressAK = SimpleString.of((String)"a.k");
        SimpleString address = SimpleString.of((String)"a.*");
        SimpleString queueName1 = SimpleString.of((String)"Q1");
        SimpleString queueName2 = SimpleString.of((String)"Q2");
        SimpleString queueName3 = SimpleString.of((String)"Q3");
        SimpleString queueName4 = SimpleString.of((String)"Q4");
        SimpleString queueName5 = SimpleString.of((String)"Q5");
        SimpleString queueName6 = SimpleString.of((String)"Q6");
        SimpleString queueName7 = SimpleString.of((String)"Q7");
        SimpleString queueName8 = SimpleString.of((String)"Q8");
        SimpleString queueName9 = SimpleString.of((String)"Q9");
        SimpleString queueName = SimpleString.of((String)"Q");
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName3).setAddress(addressAD).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName4).setAddress(addressAE).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName5).setAddress(addressAF).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName6).setAddress(addressAG).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName7).setAddress(addressAH).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName8).setAddress(addressAJ).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName9).setAddress(addressAK).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer();
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send(addressAB, (Message)this.createTextMessage(this.clientSession, "m1"));
        producer.send(addressAC, (Message)this.createTextMessage(this.clientSession, "m2"));
        producer.send(addressAD, (Message)this.createTextMessage(this.clientSession, "m3"));
        producer.send(addressAE, (Message)this.createTextMessage(this.clientSession, "m4"));
        producer.send(addressAF, (Message)this.createTextMessage(this.clientSession, "m5"));
        producer.send(addressAG, (Message)this.createTextMessage(this.clientSession, "m6"));
        producer.send(addressAH, (Message)this.createTextMessage(this.clientSession, "m7"));
        producer.send(addressAJ, (Message)this.createTextMessage(this.clientSession, "m8"));
        producer.send(addressAK, (Message)this.createTextMessage(this.clientSession, "m9"));
        ClientMessage m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m2", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m3", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m4", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m5", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m6", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m7", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m8", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m9", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
        this.clientSession.deleteQueue(queueName1);
        this.clientSession.deleteQueue(queueName2);
        this.clientSession.deleteQueue(queueName3);
        this.clientSession.deleteQueue(queueName4);
        this.clientSession.deleteQueue(queueName5);
        this.clientSession.deleteQueue(queueName6);
        this.clientSession.deleteQueue(queueName7);
        this.clientSession.deleteQueue(queueName8);
        this.clientSession.deleteQueue(queueName9);
        clientConsumer.close();
        this.clientSession.deleteQueue(queueName);
    }

    @Test
    public void testWildcardRoutingLotsOfQueuesAddedThenDeletedHash() throws Exception {
        SimpleString addressAB = SimpleString.of((String)"a.b");
        SimpleString addressAC = SimpleString.of((String)"a.c");
        SimpleString addressAD = SimpleString.of((String)"a.d");
        SimpleString addressAE = SimpleString.of((String)"a.e");
        SimpleString addressAF = SimpleString.of((String)"a.f");
        SimpleString addressAG = SimpleString.of((String)"a.g");
        SimpleString addressAH = SimpleString.of((String)"a.h");
        SimpleString addressAJ = SimpleString.of((String)"a.j");
        SimpleString addressAK = SimpleString.of((String)"a.k");
        SimpleString address = SimpleString.of((String)"#");
        SimpleString queueName1 = SimpleString.of((String)"Q1");
        SimpleString queueName2 = SimpleString.of((String)"Q2");
        SimpleString queueName3 = SimpleString.of((String)"Q3");
        SimpleString queueName4 = SimpleString.of((String)"Q4");
        SimpleString queueName5 = SimpleString.of((String)"Q5");
        SimpleString queueName6 = SimpleString.of((String)"Q6");
        SimpleString queueName7 = SimpleString.of((String)"Q7");
        SimpleString queueName8 = SimpleString.of((String)"Q8");
        SimpleString queueName9 = SimpleString.of((String)"Q9");
        SimpleString queueName = SimpleString.of((String)"Q");
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName3).setAddress(addressAD).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName4).setAddress(addressAE).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName5).setAddress(addressAF).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName6).setAddress(addressAG).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName7).setAddress(addressAH).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName8).setAddress(addressAJ).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName9).setAddress(addressAK).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer();
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send(addressAB, (Message)this.createTextMessage(this.clientSession, "m1"));
        producer.send(addressAC, (Message)this.createTextMessage(this.clientSession, "m2"));
        producer.send(addressAD, (Message)this.createTextMessage(this.clientSession, "m3"));
        producer.send(addressAE, (Message)this.createTextMessage(this.clientSession, "m4"));
        producer.send(addressAF, (Message)this.createTextMessage(this.clientSession, "m5"));
        producer.send(addressAG, (Message)this.createTextMessage(this.clientSession, "m6"));
        producer.send(addressAH, (Message)this.createTextMessage(this.clientSession, "m7"));
        producer.send(addressAJ, (Message)this.createTextMessage(this.clientSession, "m8"));
        producer.send(addressAK, (Message)this.createTextMessage(this.clientSession, "m9"));
        ClientMessage m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m2", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m3", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m4", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m5", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m6", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m7", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m8", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m9", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
        this.clientSession.deleteQueue(queueName1);
        this.clientSession.deleteQueue(queueName2);
        this.clientSession.deleteQueue(queueName3);
        this.clientSession.deleteQueue(queueName4);
        this.clientSession.deleteQueue(queueName5);
        this.clientSession.deleteQueue(queueName6);
        this.clientSession.deleteQueue(queueName7);
        this.clientSession.deleteQueue(queueName8);
        this.clientSession.deleteQueue(queueName9);
        clientConsumer.close();
        this.clientSession.deleteQueue(queueName);
    }

    @Test
    public void testWildcardRoutingWithSingleHash() throws Exception {
        SimpleString addressAB = SimpleString.of((String)"a.b");
        SimpleString addressAC = SimpleString.of((String)"a.c");
        SimpleString address = SimpleString.of((String)"#");
        SimpleString queueName1 = SimpleString.of((String)"Q1");
        SimpleString queueName2 = SimpleString.of((String)"Q2");
        SimpleString queueName = SimpleString.of((String)"Q");
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m2", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
    }

    @Test
    public void testWildcardRoutingWithHash() throws Exception {
        SimpleString addressAB = SimpleString.of((String)"a.b.f");
        SimpleString addressAC = SimpleString.of((String)"a.c.f");
        SimpleString address = SimpleString.of((String)"a.#.f");
        SimpleString queueName1 = SimpleString.of((String)"Q1");
        SimpleString queueName2 = SimpleString.of((String)"Q2");
        SimpleString queueName = SimpleString.of((String)"Q");
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m2", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
    }

    @Test
    public void testWildcardRoutingWithHashMultiLengthAddresses() throws Exception {
        SimpleString addressAB = SimpleString.of((String)"a.b.c.f");
        SimpleString addressAC = SimpleString.of((String)"a.c.f");
        SimpleString address = SimpleString.of((String)"a.#.f");
        SimpleString queueName1 = SimpleString.of((String)"Q1");
        SimpleString queueName2 = SimpleString.of((String)"Q2");
        SimpleString queueName = SimpleString.of((String)"Q");
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m2", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
    }

    @Test
    public void testWildcardRoutingWithDoubleStar() throws Exception {
        SimpleString addressAB = SimpleString.of((String)"a.b");
        SimpleString addressAC = SimpleString.of((String)"a.c");
        SimpleString address = SimpleString.of((String)"*.*");
        SimpleString queueName1 = SimpleString.of((String)"Q1");
        SimpleString queueName2 = SimpleString.of((String)"Q2");
        SimpleString queueName = SimpleString.of((String)"Q");
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m2", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
    }

    @Test
    public void testWildcardRoutingPartialMatchStar() throws Exception {
        SimpleString addressAB = SimpleString.of((String)"a.b");
        SimpleString addressAC = SimpleString.of((String)"a.c");
        SimpleString address = SimpleString.of((String)"*.b");
        SimpleString queueName1 = SimpleString.of((String)"Q1");
        SimpleString queueName2 = SimpleString.of((String)"Q2");
        SimpleString queueName = SimpleString.of((String)"Q");
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
    }

    @Test
    public void testWildcardRoutingVariableLengths() throws Exception {
        SimpleString addressAB = SimpleString.of((String)"a.b.c");
        SimpleString addressAC = SimpleString.of((String)"a.c");
        SimpleString address = SimpleString.of((String)"a.#");
        SimpleString queueName1 = SimpleString.of((String)"Q1");
        SimpleString queueName2 = SimpleString.of((String)"Q2");
        SimpleString queueName = SimpleString.of((String)"Q");
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m2", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
    }

    @Test
    public void testWildcardRoutingVariableLengthsStar() throws Exception {
        SimpleString addressAB = SimpleString.of((String)"a.b.c");
        SimpleString addressAC = SimpleString.of((String)"a.c");
        SimpleString address = SimpleString.of((String)"a.*");
        SimpleString queueName1 = SimpleString.of((String)"Q1");
        SimpleString queueName2 = SimpleString.of((String)"Q2");
        SimpleString queueName = SimpleString.of((String)"Q");
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m2", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
    }

    @Test
    public void testWildcardRoutingMultipleStars() throws Exception {
        SimpleString addressAB = SimpleString.of((String)"a.b.c");
        SimpleString addressAC = SimpleString.of((String)"a.c");
        SimpleString address = SimpleString.of((String)"*.*");
        SimpleString queueName1 = SimpleString.of((String)"Q1");
        SimpleString queueName2 = SimpleString.of((String)"Q2");
        SimpleString queueName = SimpleString.of((String)"Q");
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m2", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
    }

    @Test
    public void testWildcardRoutingStarInMiddle() throws Exception {
        SimpleString addressAB = SimpleString.of((String)"a.b.c");
        SimpleString addressAC = SimpleString.of((String)"a.c");
        SimpleString address = SimpleString.of((String)"*.b.*");
        SimpleString queueName1 = SimpleString.of((String)"Q1");
        SimpleString queueName2 = SimpleString.of((String)"Q2");
        SimpleString queueName = SimpleString.of((String)"Q");
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
    }

    @Test
    public void testWildcardRoutingStarAndHash() throws Exception {
        SimpleString addressAB = SimpleString.of((String)"a.b.c.d");
        SimpleString addressAC = SimpleString.of((String)"a.c");
        SimpleString address = SimpleString.of((String)"*.b.#");
        SimpleString queueName1 = SimpleString.of((String)"Q1");
        SimpleString queueName2 = SimpleString.of((String)"Q2");
        SimpleString queueName = SimpleString.of((String)"Q");
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
    }

    @Test
    public void testWildcardRoutingHashAndStar() throws Exception {
        SimpleString addressAB = SimpleString.of((String)"a.b.c");
        SimpleString addressAC = SimpleString.of((String)"a.c");
        SimpleString address = SimpleString.of((String)"#.b.*");
        SimpleString queueName1 = SimpleString.of((String)"Q1");
        SimpleString queueName2 = SimpleString.of((String)"Q2");
        SimpleString queueName = SimpleString.of((String)"Q");
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
    }

    @Test
    public void testLargeWildcardRouting() throws Exception {
        SimpleString addressAB = SimpleString.of((String)"a.b.c.d.e.f.g.h.i.j.k.l.m.n.o.p.q.r.s.t.u.v.w.x.y.z");
        SimpleString addressAC = SimpleString.of((String)"a.c");
        SimpleString address = SimpleString.of((String)"a.#");
        SimpleString queueName1 = SimpleString.of((String)"Q1");
        SimpleString queueName2 = SimpleString.of((String)"Q2");
        SimpleString queueName = SimpleString.of((String)"Q");
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        Assertions.assertEquals((int)2, (int)this.server.getPostOffice().getBindingsForAddress(addressAB).getBindings().size());
        Assertions.assertEquals((int)2, (int)this.server.getPostOffice().getBindingsForAddress(addressAC).getBindings().size());
        Assertions.assertEquals((int)1, (int)this.server.getPostOffice().getBindingsForAddress(address).getBindings().size());
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m2", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
        clientConsumer.close();
        this.clientSession.deleteQueue(queueName);
        Assertions.assertEquals((int)1, (int)this.server.getPostOffice().getBindingsForAddress(addressAB).getBindings().size());
        Assertions.assertEquals((int)1, (int)this.server.getPostOffice().getBindingsForAddress(addressAC).getBindings().size());
        Assertions.assertEquals((int)0, (int)this.server.getPostOffice().getBindingsForAddress(address).getBindings().size());
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        Configuration configuration = this.createDefaultInVMConfig().setWildcardRoutingEnabled(true).setTransactionTimeoutScanPeriod(500L);
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)configuration, (boolean)false));
        this.server.start();
        this.server.getManagementService().enableNotifications(false);
        this.locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(this.locator);
        this.clientSession = this.addClientSession(this.sf.createSession(false, true, true));
    }
}

