/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.clientcrash;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionReceiveMessage;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DummyInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    boolean sendException = false;
    boolean changeMessage = false;
    AtomicInteger syncCounter = new AtomicInteger(0);

    public int getCounter() {
        return this.syncCounter.get();
    }

    public void clearCounter() {
        this.syncCounter.set(0);
    }

    public boolean intercept(Packet packet, RemotingConnection conn) throws ActiveMQException {
        logger.debug("DummyFilter packet = {}", (Object)packet.getClass().getName());
        this.syncCounter.addAndGet(1);
        if (this.sendException) {
            throw new ActiveMQInternalErrorException();
        }
        if (this.changeMessage && packet instanceof SessionReceiveMessage) {
            SessionReceiveMessage deliver = (SessionReceiveMessage)packet;
            logger.debug("msg = {}", (Object)deliver.getMessage().getClass().getName());
            deliver.getMessage().putStringProperty(SimpleString.of((String)"DummyInterceptor"), SimpleString.of((String)"was here"));
        }
        return true;
    }
}

