/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster;

import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.core.config.storage.DatabaseStorageConfiguration;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.impl.jdbc.JdbcNodeManager;
import org.apache.activemq.artemis.tests.integration.cluster.NodeManagerAction;
import org.apache.activemq.artemis.tests.integration.cluster.NodeManagerTest;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.actors.OrderedExecutorFactory;
import org.junit.jupiter.api.Assertions;

public class JdbcNodeManagerTest
extends NodeManagerTest {
    @Override
    public void performWork(NodeManagerAction ... actions) throws Exception {
        ArrayList<NodeManagerTest.NodeRunner> nodeRunners = new ArrayList<NodeManagerTest.NodeRunner>();
        ThreadFactory daemonThreadFactory = t -> {
            Thread th = new Thread(t);
            th.setDaemon(true);
            return th;
        };
        Thread[] threads = new Thread[actions.length];
        ArrayList<JdbcNodeManager> nodeManagers = new ArrayList<JdbcNodeManager>(actions.length * 2);
        AtomicBoolean failedRenew = new AtomicBoolean(false);
        for (NodeManagerAction action : actions) {
            ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(daemonThreadFactory);
            ExecutorService executor = Executors.newFixedThreadPool(2, daemonThreadFactory);
            DatabaseStorageConfiguration dbConf = this.createDefaultDatabaseStorageConfiguration();
            OrderedExecutorFactory executorFactory = new OrderedExecutorFactory((Executor)executor);
            JdbcNodeManager nodeManager2 = JdbcNodeManager.with((DatabaseStorageConfiguration)dbConf, (ScheduledExecutorService)scheduledExecutorService, (ExecutorFactory)executorFactory);
            nodeManager2.start();
            NodeManagerTest.NodeRunner nodeRunner = new NodeManagerTest.NodeRunner((NodeManager)nodeManager2, action);
            nodeRunners.add(nodeRunner);
            nodeManagers.add(nodeManager2);
            this.runAfter(scheduledExecutorService::shutdownNow);
            this.runAfter(executor::shutdownNow);
        }
        int nodeRunnersSize = nodeRunners.size();
        for (int i = 0; i < nodeRunnersSize; ++i) {
            NodeManagerTest.NodeRunner nodeRunner = (NodeManagerTest.NodeRunner)nodeRunners.get(i);
            threads[i] = new Thread(nodeRunner);
            threads[i].start();
        }
        boolean isDebug = JdbcNodeManagerTest.isDebug();
        for (Thread thread : threads) {
            try {
                if (isDebug) {
                    thread.join();
                } else {
                    thread.join(60000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!thread.isAlive()) continue;
            thread.interrupt();
            Assertions.fail((String)"thread still running");
        }
        nodeManagers.forEach(nodeManager -> {
            try {
                nodeManager.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        for (NodeManagerTest.NodeRunner nodeRunner : nodeRunners) {
            if (nodeRunner.e == null) continue;
            nodeRunner.e.printStackTrace();
            Assertions.fail((String)nodeRunner.e.getMessage());
        }
        Assertions.assertFalse((boolean)failedRenew.get(), (String)"Some of the lease locks has failed to renew the locks");
    }
}

